/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddComputedMeasureAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddMeasureViewHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddRelativeTimePeriodAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.DeleteMeasureHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.ShowAsViewMenuAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;

public class MeasureCrosstabPopMenuProvider
extends ContextMenuProvider {
    public MeasureCrosstabPopMenuProvider(EditPartViewer viewer) {
        super(viewer);
    }

    public void buildContextMenu(IMenuManager menu) {
        if (this.getElements().size() != 1) {
            return;
        }
        Object firstSelectedElement = this.getFirstElement();
        DesignElementHandle element = null;
        if (firstSelectedElement instanceof DesignElementHandle) {
            element = (DesignElementHandle)firstSelectedElement;
        } else if (firstSelectedElement instanceof CrosstabCellAdapter) {
            element = ((CrosstabCellAdapter)firstSelectedElement).getDesignElementHandle();
        }
        this.buildShowMenu(menu, element);
        Object action = new AddRelativeTimePeriodAction(element);
        menu.add((IAction)action);
        action = new AddComputedMeasureAction(element);
        menu.add((IAction)action);
        action = new AddMeasureViewHandleAction(element);
        menu.add((IAction)action);
        action = new DeleteMeasureHandleAction(element);
        menu.add((IAction)action);
    }

    protected void buildShowMenu(IMenuManager menu, DesignElementHandle element) {
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(element);
        MeasureViewHandle measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        if (measureViewHandle == null || measureViewHandle instanceof ComputedMeasureViewHandle || measureViewHandle.getCubeMeasure() != null && measureViewHandle.getCubeMeasure().isCalculated()) {
            return;
        }
        AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(measureViewHandle.getCrosstab());
        IAggregationCellViewProvider[] providers = providerWrapper.getAllProviders();
        int count = 1;
        int i = 0;
        while (i < providers.length) {
            IAggregationCellViewProvider provider = providers[i];
            if (provider != null) {
                ShowAsViewMenuAction showAsViewAction = new ShowAsViewMenuAction(element, provider.getViewName(), count);
                ++count;
                menu.add((IAction)showAsViewAction);
            }
            ++i;
        }
        menu.add((IContributionItem)new Separator());
    }

    protected ISelection getSelection() {
        return this.getViewer().getSelection();
    }

    protected List getElements() {
        return InsertInLayoutUtil.editPart2Model((ISelection)this.getSelection()).toList();
    }

    protected Object getSelectedElement() {
        Object[] array = this.getElements().toArray();
        if (array.length == 1) {
            return array[0];
        }
        return array;
    }

    protected Object getFirstElement() {
        Object[] array = this.getElements().toArray();
        if (array.length > 0) {
            return array[0];
        }
        return null;
    }
}

