/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IComboDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class ComboPropertyDescriptorProvider
extends PropertyDescriptorProvider
implements IComboDescriptorProvider {
    private IChoiceSet choiceSet;
    private String[] items;

    public ComboPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    @Override
    public String[] getItems() {
        if (this.choiceSet == null) {
            this.choiceSet = ChoiceSetFactory.getElementChoiceSet((String)this.getElement(), (String)this.getProperty());
            String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)this.choiceSet, (Comparator)new AlphabeticallyComparator());
            if (this.getProperty().equals("fontFamily")) {
                String[] sysFont = DEUtil.getSystemFontNames();
                String[] items = new String[displayNames.length + sysFont.length + 1];
                items[0] = ChoiceSetFactory.CHOICE_AUTO;
                System.arraycopy(displayNames, 0, items, 1, displayNames.length);
                System.arraycopy(sysFont, 0, items, displayNames.length + 1, sysFont.length);
                int i = 0;
                while (i < items.length) {
                    DEUtil.removeQuote((String)items[i]);
                    ++i;
                }
                this.items = items;
            } else if ("textAlign".equals(this.getProperty()) || "verticalAlign".equals(this.getProperty()) || "whiteSpace".equals(this.getProperty())) {
                String[] items = new String[displayNames.length + 1];
                items[0] = ChoiceSetFactory.CHOICE_AUTO;
                System.arraycopy(displayNames, 0, items, 1, displayNames.length);
                this.items = items;
            } else {
                this.items = displayNames;
            }
        }
        return this.items;
    }

    @Override
    public Object load() {
        if ("fontFamily".equals(this.getProperty())) {
            return DEUtil.removeQuote((String)super.load().toString());
        }
        if ("textAlign".equals(this.getProperty()) || "verticalAlign".equals(this.getProperty()) || "whiteSpace".equals(this.getProperty())) {
            Object rt = super.load();
            if (rt == null || rt instanceof String && ((String)rt).length() == 0 || !this.hasLocalValue()) {
                return ChoiceSetFactory.CHOICE_AUTO;
            }
            return rt;
        }
        return super.load();
    }

    @Override
    public String getDisplayName(String key) {
        IChoice choice = null;
        if (this.choiceSet != null) {
            choice = this.choiceSet.findChoice(key);
        }
        if (choice == null) {
            return null;
        }
        return choice.getDisplayName();
    }

    @Override
    public void save(Object value) throws SemanticException {
        if ("".equals(value)) {
            value = null;
        }
        String pName = this.getProperty();
        if (ChoiceSetFactory.CHOICE_AUTO.equals(value) && ("fontFamily".equals(pName) || "textAlign".equals(pName) || "verticalAlign".equals(pName) || "whiteSpace".equals(pName))) {
            value = null;
        }
        if (ChoiceSetFactory.CHOICE_NONE.equals(value) && "includeResource".equals(pName)) {
            value = null;
        }
        if (value != null && (value = this.getSaveValue(value)) == null) {
            return;
        }
        if ("fontFamily".equals(pName) && this.needAddQuote(value == null ? null : value.toString())) {
            super.save(DEUtil.addQuote((String)(value == null ? null : value.toString())));
        } else {
            super.save(value);
        }
    }

    protected Object getSaveValue(Object value) {
        if (this.items != null && Arrays.asList(this.items).contains(value)) {
            this.choiceSet = ChoiceSetFactory.getElementChoiceSet((String)this.getElement(), (String)this.getProperty());
            int i = 0;
            while (i < this.choiceSet.getChoices().length) {
                if (this.choiceSet.getChoices()[i].getDisplayName().equals(value)) {
                    value = this.choiceSet.getChoices()[i].getName();
                    Object oldValue = super.load();
                    if (!oldValue.equals("") && oldValue.equals(value)) {
                        return null;
                    }
                    return value;
                }
                ++i;
            }
        }
        return value;
    }

    private boolean needAddQuote(String value) {
        IChoiceSet choice = ChoiceSetFactory.getElementChoiceSet((String)this.getElement(), (String)this.getProperty());
        String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)choice, (Comparator)new AlphabeticallyComparator());
        int i = 0;
        while (i < displayNames.length) {
            if (displayNames[i].equals(value)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

