/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samplesview.util;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SampleReportCanvas
extends Canvas {
    private Image sampleImage;

    public SampleReportCanvas(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                SampleReportCanvas.this.paintControl(pe);
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                SampleReportCanvas.this.controlResized(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SampleReportCanvas.this.sampleImage != null && !SampleReportCanvas.this.sampleImage.isDisposed()) {
                    SampleReportCanvas.this.sampleImage.dispose();
                }
            }
        });
    }

    public void setSampleImage(Image sampleImage) {
        Image oldImage = this.sampleImage;
        this.sampleImage = sampleImage;
        if (oldImage != null && oldImage != sampleImage) {
            oldImage.dispose();
        }
    }

    protected void paintControl(PaintEvent pe) {
        GC gc = pe.gc;
        if (this.sampleImage != null) {
            double srcRatio = (double)this.sampleImage.getBounds().width / (double)this.sampleImage.getBounds().height;
            double clntRatio = (double)this.getClientArea().width / (double)this.getClientArea().height;
            if (srcRatio >= clntRatio) {
                gc.drawImage(this.sampleImage, 0, 0, this.sampleImage.getBounds().width, this.sampleImage.getBounds().height, 0, 0, this.getClientArea().width, (int)((double)this.getClientArea().width / srcRatio));
            } else {
                gc.drawImage(this.sampleImage, 0, 0, this.sampleImage.getBounds().width, this.sampleImage.getBounds().height, 0, 0, (int)((double)this.getClientArea().height * srcRatio), this.getClientArea().height);
            }
        }
    }

    protected void controlResized(ControlEvent e) {
        this.redraw();
    }
}

