/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.actions;

import org.eclipse.birt.report.debug.internal.script.model.RunToLinebreakPoint;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.ui.script.editor.DebugJsInput;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.birt.report.debug.ui.DebugUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptRunToLineAdapter
implements IRunToLineTarget {
    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof ScriptDebugElement) {
            IDebugElement element = (IDebugElement)target;
            ScriptDebugTarget adapter = (ScriptDebugTarget)((Object)element.getDebugTarget().getAdapter(IDebugTarget.class));
            return adapter != null;
        }
        return false;
    }

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null) {
            IDocument document;
            IEditorInput input = textEditor.getEditorInput();
            if (input == null || !(input instanceof DebugJsInput)) {
                return;
            }
            DebugJsInput scriptInput = (DebugJsInput)input;
            IResource resource = (IResource)input.getAdapter(IResource.class);
            if (resource == null) {
                resource = ScriptDebugUtil.getDefaultResource();
            }
            if ((document = textEditor.getDocumentProvider().getDocument((Object)input)) != null) {
                int[] validLine = new int[1];
                final int[] lineNumber = new int[1];
                final ITextSelection textSelection = (ITextSelection)selection;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        lineNumber[0] = textSelection.getStartLine() + 1;
                    }
                };
                BusyIndicator.showWhile((Display)DebugUI.getStandardDisplay(), (Runnable)r);
                validLine[0] = lineNumber[0];
                if (validLine[0] == lineNumber[0]) {
                    ScriptDebugTarget debugTarget;
                    RunToLinebreakPoint point = new RunToLinebreakPoint(resource, scriptInput.getFile().getAbsolutePath(), scriptInput.getId(), lineNumber[0]);
                    point.setType("run to line");
                    if (target instanceof IAdaptable && (debugTarget = (ScriptDebugTarget)((Object)((IAdaptable)target).getAdapter(IDebugTarget.class))) != null) {
                        debugTarget.breakpointAdded((IBreakpoint)point);
                        debugTarget.resume();
                    }
                }
            }
        }
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }
}

