/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ExternalCssStyleSheet4Test
extends BaseTestCase {
    private String fileName = "ExternalCssStyleSheetTest4.css";
    private String designFileName = "ExternalCssStyleSheetTest4.xml";
    protected ReportDesignHandle designHandle = null;

    public ExternalCssStyleSheet4Test(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ExternalCssStyleSheet4Test.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        this.copyInputToFile("input/" + this.designFileName);
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.openDesign(this.getTempFolder() + "/input/" + this.designFileName);
    }

    public void testImportDuplicatedStyles() throws Exception {
        CssStyleSheetHandle stylesheet = this.loadStyleSheet(this.fileName);
        ExternalCssStyleSheet4Test.assertNotNull((Object)stylesheet);
        SharedStyleHandle style1 = stylesheet.findStyle("STYLE1");
        SharedStyleHandle style2 = stylesheet.findStyle("STYLE2");
        ExternalCssStyleSheet4Test.assertNotNull((Object)style1);
        ExternalCssStyleSheet4Test.assertNotNull((Object)style2);
        ArrayList<SharedStyleHandle> styleList = new ArrayList<SharedStyleHandle>();
        styleList.add(0, style1);
        styleList.add(1, style2);
        ExternalCssStyleSheet4Test.assertEquals((int)2, (int)styleList.size());
        this.designHandle.importCssStyles(stylesheet, styleList);
        ExternalCssStyleSheet4Test.assertEquals((int)3, (int)this.designHandle.getStyles().getCount());
        ExternalCssStyleSheet4Test.assertEquals((String)"style1", (String)this.designHandle.getStyles().get(0).getName());
        ExternalCssStyleSheet4Test.assertEquals((String)"STYLE11", (String)this.designHandle.getStyles().get(1).getName());
        ExternalCssStyleSheet4Test.assertEquals((String)"STYLE2", (String)this.designHandle.getStyles().get(2).getName());
        TableHandle table = (TableHandle)this.designHandle.findElement("MyTable");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("MyLabel");
        SharedStyleHandle style_a = (SharedStyleHandle)this.designHandle.getStyles().get(0);
        SharedStyleHandle style_b = (SharedStyleHandle)this.designHandle.getStyles().get(1);
        table.setStyle(style_a);
        label.setStyle(style_b);
        ExternalCssStyleSheet4Test.assertEquals((String)"2em", (String)label.getStringProperty("fontSize"));
        ExternalCssStyleSheet4Test.assertEquals((String)"1em", (String)label.getStringProperty("marginLeft"));
        ExternalCssStyleSheet4Test.assertEquals((String)"2em", (String)table.getStringProperty("fontSize"));
        ExternalCssStyleSheet4Test.assertEquals((String)"italic", (String)table.getStringProperty("fontStyle"));
    }

    private CssStyleSheetHandle loadStyleSheet(String fileName) throws Exception {
        fileName = "input/" + (String)fileName;
        InputStream is = ExternalCssStyleSheet4Test.class.getResourceAsStream((String)fileName);
        return this.designHandle.openCssStyleSheet(is);
    }
}

