/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.command.LibraryReloadedEvent;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.LibraryRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.LayoutModule;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ModuleImpl;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.LibraryUtil;

public class LibraryCommandImp
extends AbstractElementCommand {
    private static final int RELOAD_ACTION = 1;
    private static final int SIMPLE_ACTION = 2;
    private static final int APPEND_POS = -1;

    public LibraryCommandImp(Module module) {
        super(module, module);
    }

    public void addLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        if (StringUtil.isBlank(namespace)) {
            namespace = StringUtil.extractFileName(libraryFileName);
        }
        URL fileURL = this.module.findResource(libraryFileName, 2);
        Module outermostModule = this.module.findOutermostModule();
        Library foundLib = null;
        foundLib = LibraryUtil.checkIncludeLibrary(this.module, namespace, fileURL, outermostModule);
        foundLib = foundLib == null ? this.module.loadLibrary(libraryFileName, namespace, new HashMap<String, Library>(), fileURL) : foundLib.contextClone(this.module);
        this.doAddLibrary(libraryFileName, foundLib);
    }

    public void dropLibraryAndBreakExtends(Library library) throws SemanticException {
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        LibraryRecord record = new LibraryRecord(this.module, library, false);
        stack.startTrans(record.getLabel());
        try {
            int slotID = 0;
            while (slotID < library.getDefn().getSlotCount()) {
                if (slotID != 0) {
                    Iterator<DesignElement> iter = library.getSlot(slotID).iterator();
                    while (iter.hasNext()) {
                        DesignElement element = iter.next();
                        List<DesignElement> derived = element.getDerived();
                        int i = 0;
                        while (i < derived.size()) {
                            DesignElement child = derived.get(i);
                            if (child.getRoot() == this.getModule()) {
                                ExtendsCommand command = new ExtendsCommand(this.getModule(), child);
                                command.localizeElement();
                            }
                            ++i;
                        }
                    }
                }
                ++slotID;
            }
            this.getActivityStack().execute(record);
            String libraryFileName = library.getFileName();
            assert (libraryFileName != null);
            this.removeIncludeLibrary(libraryFileName, library.getNamespace());
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        this.getActivityStack().commit();
    }

    public void dropLibrary(Library library) throws SemanticException {
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        this.dealAllElementDecendents(library, 2);
        this.doDropLibrary(library);
    }

    private void doDropLibrary(Library library) throws SemanticException {
        ActivityStack stack = this.getActivityStack();
        LibraryRecord record = new LibraryRecord((Module)library.getHost(), library, false);
        stack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        try {
            String libFileName = library.getFileName();
            assert (libFileName != null);
            this.removeIncludeLibrary(libFileName, library.getNamespace());
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        this.getActivityStack().commit();
    }

    private Map<Long, Map<Long, List<Object>>> dealElementDecendents(Module library, DesignElement parent, int actionCode) throws SemanticException {
        if (!parent.hasDerived()) {
            return Collections.emptyMap();
        }
        ArrayList<DesignElement> allDescendents = new ArrayList<DesignElement>();
        this.getAllDescdents(parent, allDescendents);
        HashMap<Long, Map<Long, List<Object>>> overriddenValues = new HashMap<Long, Map<Long, List<Object>>>();
        int i = 0;
        while (i < allDescendents.size()) {
            DesignElement child = (DesignElement)allDescendents.get(i);
            Module tmpModule = child.getRoot();
            if (child.hasDerived()) {
                this.dealElementDecendents(tmpModule, child, actionCode);
            }
            if (tmpModule == this.module) {
                if (actionCode == 1) {
                    Map<Long, List<Object>> values = this.unresolveElementDescendent(this.module, child);
                    overriddenValues.put(child.getID(), values);
                } else if (actionCode == 2) {
                    throw new LibraryException(library, new String[]{child.getHandle(this.module).getDisplayLabel()}, "Error.LibraryException.LIBRARY_HAS_DESCENDENTS");
                }
            }
            ++i;
        }
        return overriddenValues;
    }

    public void reloadLibrary(Library toReloadLibrary, IncludedLibrary includedLib, Map<String, Library> reloadLibs) throws DesignFileException, SemanticException {
        String location = toReloadLibrary.getLocation();
        if (location == null) {
            location = toReloadLibrary.getFileName();
        }
        Library library = null;
        List<Library> libs = this.module.getLibrariesByLocation(location, Integer.MAX_VALUE);
        int i = 0;
        while (i < libs.size()) {
            if (toReloadLibrary == libs.get(i)) {
                library = toReloadLibrary;
                break;
            }
            ++i;
        }
        if (library == null) {
            library = this.getLibraryByStruct(includedLib);
        }
        if (library == null) {
            throw new LibraryException(this.module, new String[]{toReloadLibrary.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        library = this.findTopLevelLibrary(library);
        assert (library != null);
        LayoutModule host = library.getHost();
        IncludedLibrary tmpIncludedLib = host.findIncludedLibrary(library.getNamespace());
        int removePosn = ((ModuleImpl)host).getIncludedLibraries().indexOf(tmpIncludedLib);
        Map<Long, Map<Long, List<Object>>> overriddenValues = null;
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startSilentTrans(true);
        try {
            overriddenValues = this.dealAllElementDecendents(library, 1);
            this.doDropLibrary(library);
            this.doReloadLibrary(library, tmpIncludedLib.getFileName(), overriddenValues, reloadLibs, removePosn);
        }
        catch (DesignFileException | SemanticException e) {
            activityStack.rollback();
            throw e;
        }
        library = this.module.getLibraryWithNamespace(library.getNamespace(), 1);
        this.doPostReloadAction(library);
    }

    public void reloadLibrary(String location, Map<String, Library> reloadLibs) throws DesignFileException, SemanticException {
        List<Library> libs = this.module.getLibrariesByLocation(location, Integer.MAX_VALUE);
        int i = 0;
        while (i < libs.size()) {
            this.reloadLibrary(libs.get(i), null, reloadLibs);
            ++i;
        }
    }

    private Library findTopLevelLibrary(Library lib) {
        Library tmpLib = lib;
        while (tmpLib != null) {
            if (tmpLib.getHost() == this.module) break;
            tmpLib = (Library)tmpLib.getHost();
        }
        return tmpLib;
    }

    public void reloadLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        if (StringUtil.isBlank(namespace)) {
            namespace = StringUtil.extractFileName(libraryFileName);
        }
        this.addLibrary(libraryFileName, namespace);
        Library lib = this.module.getLibraryWithNamespace(namespace);
        this.doPostReloadAction(lib);
    }

    protected void doPostReloadAction(Library lib) throws DesignFileException, SemanticException {
        LibraryReloadedEvent event = new LibraryReloadedEvent(this.module, lib);
        this.module.broadcast(event);
        ActivityStack activityStack = this.module.getActivityStack();
        activityStack.commit();
        activityStack.flush();
        this.module.setSaveState(0);
        activityStack.sendNotifcations(new ActivityStackEvent(activityStack, 1));
    }

    private Map<Long, Map<Long, List<Object>>> dealAllElementDecendents(Library library, int actionCode) throws SemanticException {
        HashMap<Long, Map<Long, List<Object>>> overriddenValues = new HashMap<Long, Map<Long, List<Object>>>();
        LevelContentIterator contentIter = new LevelContentIterator((Module)library, library, 1);
        while (contentIter.hasNext()) {
            DesignElement tmpElement = contentIter.next();
            if (!tmpElement.getDefn().canExtend()) continue;
            Map<Long, Map<Long, List<Object>>> values = this.dealElementDecendents(library, tmpElement, actionCode);
            if (actionCode != 1) continue;
            overriddenValues.putAll(values);
        }
        return overriddenValues;
    }

    private void doAddLibrary(String libraryFileName, Library foundLib) throws SemanticException, DesignFileException {
        Library library = foundLib;
        library.setReadOnly();
        ActivityStack activityStack = this.getActivityStack();
        LibraryRecord record = new LibraryRecord(this.module, library, true);
        activityStack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        String namespace = foundLib.getNamespace();
        if (this.module.findIncludedLibrary(namespace) == null) {
            this.addLibraryStructure(libraryFileName, namespace, -1);
        }
        activityStack.commit();
    }

    private void doReloadLibrary(Library toReload, String includedLibPath, Map<Long, Map<Long, List<Object>>> overriddenValues, Map<String, Library> reloadLibs, int removePosn) throws SemanticException, DesignFileException {
        String namespace = toReload.getNamespace();
        URL fileURL = this.module.findResource(includedLibPath, 2);
        if (fileURL == null) {
            if (this.module.findIncludedLibrary(namespace) == null) {
                this.addLibraryStructure(includedLibPath, namespace, removePosn);
            }
            Library invalidLib = new Library(this.module.getSession(), this.module);
            invalidLib.setFileName(includedLibPath);
            invalidLib.setNamespace(namespace);
            invalidLib.setID(invalidLib.getNextID());
            invalidLib.addElementID(invalidLib);
            invalidLib.setValid(false);
            ActivityStack activityStack = this.getActivityStack();
            LibraryRecord record = new LibraryRecord(this.module, invalidLib, overriddenValues, removePosn);
            activityStack.startTrans(record.getLabel());
            activityStack.execute(record);
            activityStack.commit();
            return;
        }
        Library library = null;
        Library reloadLibrary = reloadLibs.get(toReload.getNamespace());
        if (reloadLibrary == null) {
            library = this.module.loadLibrary(includedLibPath, namespace, reloadLibs, fileURL);
            LibraryUtil.insertReloadLibs(reloadLibs, library);
        } else {
            library = reloadLibrary.contextClone(this.module);
        }
        library.setReadOnly();
        ActivityStack activityStack = this.getActivityStack();
        LibraryRecord record = new LibraryRecord(this.module, library, overriddenValues, removePosn);
        assert (record != null);
        activityStack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        if (this.module.findIncludedLibrary(namespace) == null) {
            this.addLibraryStructure(includedLibPath, namespace, removePosn);
        }
        activityStack.commit();
    }

    private void addLibraryStructure(String libraryFileName, String namespace, int removePosn) throws SemanticException {
        IncludedLibrary includeLibrary = StructureFactory.createIncludeLibrary();
        includeLibrary.setFileName(libraryFileName);
        includeLibrary.setNamespace(namespace);
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.module);
        if (removePosn == -1) {
            propCommand.addItem(new StructureContext(this.module, propDefn, null), (Object)includeLibrary);
        } else {
            propCommand.insertItem(new StructureContext(this.module, propDefn, null), includeLibrary, removePosn);
        }
    }

    private Map<Long, List<Object>> unresolveElementDescendent(Module module, DesignElement child) throws SemanticException {
        ElementRefValue value = (ElementRefValue)child.getLocalProperty(module, "extends");
        DesignElement parent = value.getElement();
        assert (parent != null);
        if (child instanceof ExtendedItem) {
            assert (parent instanceof ExtendedItem);
            if (!((ExtendedItem)child).hasLocalPropertyValuesOnOwnModel()) {
                ((ExtendedItem)child).getExtensibilityProvider().clearOwnModel();
            }
        }
        if (!child.getDefn().isContainer()) {
            parent.dropDerived(child);
            value.unresolved(value.getName());
            return Collections.emptyMap();
        }
        Map<Long, List<Object>> overriddenValues = ElementStructureUtil.collectPropertyValues(module, child);
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startSilentTrans(null);
        LevelContentIterator contentIter = new LevelContentIterator(module, child, 1);
        while (contentIter.hasNext()) {
            DesignElement tmpElement = contentIter.next();
            ContentCommand command = new ContentCommand(module, tmpElement.getContainerInfo(), true, true);
            command.remove(tmpElement);
        }
        activityStack.commit();
        parent.dropDerived(child);
        value.unresolved(value.getName());
        return overriddenValues;
    }

    private void getAllDescdents(DesignElement tmpElement, List<DesignElement> results) {
        List<DesignElement> descends = tmpElement.getDerived();
        results.addAll(descends);
        int i = 0;
        while (i < descends.size()) {
            this.getAllDescdents(descends.get(i), results);
            ++i;
        }
    }

    private void removeIncludeLibrary(String fileName, String namespace) throws PropertyValueException {
        assert (fileName != null);
        assert (namespace != null);
        List<IncludedLibrary> includeLibraries = this.module.getIncludedLibraries();
        int i = 0;
        while (i < includeLibraries.size()) {
            IncludedLibrary includeLibrary = includeLibraries.get(i);
            if (namespace.equals(includeLibrary.getNamespace()) && fileName.endsWith(StringUtil.extractFileNameWithSuffix(includeLibrary.getFileName()))) {
                ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
                ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.module);
                propCommand.removeItem(new StructureContext(this.module, propDefn, null), includeLibrary);
                break;
            }
            ++i;
        }
    }

    private Library getLibraryByStruct(IncludedLibrary includedLib) {
        List<Object> includedLibs = this.module.getListProperty(this.module, "libraries");
        if (includedLibs == null) {
            return null;
        }
        int index = includedLibs.indexOf(includedLib);
        if (index == -1) {
            return null;
        }
        Library retLib = this.module.getLibraries().get(index);
        if (retLib.getNamespace().equalsIgnoreCase(includedLib.getNamespace())) {
            return retLib;
        }
        return null;
    }
}

