/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ResetAttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatStringDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.FormatStringSection;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormatStringAttributePage
extends ResetAttributePage {
    private FormatStringDescriptorProvider provider;
    private FormatStringSection formatSection;

    @Override
    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.provider = new FormatStringDescriptorProvider();
        this.formatSection = new FormatStringSection(this.container, 0, true);
        this.formatSection.setProvider(this.provider);
        this.addSection("FORMATSTRING_FORMAT", this.formatSection);
        this.createSections();
        this.layoutSections();
        this.formatSection.addFormatChangeListener(new IFormatChangeListener(){

            public void formatChange(FormatChangeEvent event) {
                if (FormatStringAttributePage.this.formatSection.getFormatControl().isDirty() && FormatStringAttributePage.this.formatSection.getFormatControl().isFormatModified()) {
                    try {
                        FormatStringAttributePage.this.provider.save(new String[]{event.getCategory(), event.getPattern(), event.getLocale()});
                    }
                    catch (Exception e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                    if (event.getCategory() != null || event.getPattern() != null || event.getLocale() != null) {
                        FormatStringAttributePage.this.refresh();
                    }
                }
            }
        });
    }
}

