/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptEditor;
import org.eclipse.birt.report.designer.internal.ui.script.JSDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.script.JSEditorInput;
import org.eclipse.birt.report.designer.internal.ui.script.JSSourceViewerConfiguration;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.schematic.action.TextSaveAction;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class ScriptEditor
extends StatusTextEditor
implements IScriptEditor {
    private final JSSyntaxContext context = new JSSyntaxContext();
    private IEditorInput input = this.createScriptInput(null);
    private ActionRegistry actionRegistry = null;
    private final IEditorPart parent;

    public ScriptEditor(IEditorPart parent) {
        this(parent, null);
    }

    public ScriptEditor(IEditorPart parent, String script) {
        this.parent = parent;
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JSSourceViewerConfiguration(this.context));
        this.setDocumentProvider((IDocumentProvider)new JSDocumentProvider((ISaveablePart)parent));
        this.setScript(script);
    }

    public void createPartControl(Composite parent) {
        if (this.input != null) {
            this.setInput(this.input);
        }
        super.createPartControl(parent);
        this.getSourceViewer().getTextWidget().setOrientation(0x2000000);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("additions"));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return false;
    }

    protected IEditorInput createScriptInput(String script) {
        return new JSEditorInput(script);
    }

    public IWorkbenchPartSite getSite() {
        IWorkbenchPartSite site = super.getSite();
        if (site == null) {
            site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite();
        }
        return site;
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction contentAssistAction = new TextOperationAction(Messages.getReportResourceBundle(), "ContentAssistProposal_", (ITextEditor)this, 13, true);
        contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)contentAssistAction);
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)new TextSaveAction((ITextEditor)this));
    }

    public void setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
        if (action != null) {
            if (action.getId() == null) {
                action.setId(actionID);
            }
            this.getActionRegistry().registerAction(action);
        }
    }

    @Override
    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    @Override
    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    @Override
    public String getScript() {
        IDocument document;
        IDocumentProvider provider = this.getDocumentProvider();
        String script = "";
        if (provider != null && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
            script = document.get();
        }
        return script;
    }

    @Override
    public void setScript(String script) {
        try {
            IDocument document;
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider != null && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
                document.set(script == null ? "" : script);
                return;
            }
            this.input = this.createScriptInput(script);
        }
        finally {
            IUndoManager undoManager;
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof SourceViewer && (undoManager = ((SourceViewer)viewer).getUndoManager()) != null) {
                undoManager.reset();
            }
        }
    }

    @Override
    public JSSyntaxContext getContext() {
        return this.context;
    }

    private IVerticalRulerColumn createLineNumberRulerColumn() {
        LineNumberRulerColumn column = new LineNumberRulerColumn();
        column.setForeground(JSSourceViewerConfiguration.getColorByCategory((String)"linenumberColor"));
        return column;
    }

    private CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.setModel((IAnnotationModel)new AnnotationModel());
        return ruler;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        ruler.addDecorator(0, this.createLineNumberRulerColumn());
        return ruler;
    }

    protected IEditorPart getParent() {
        return this.parent;
    }
}

