/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AutomaticRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Vector;

public class FanRouter
extends AutomaticRouter {
    private int separation = 10;

    public int getSeparation() {
        return this.separation;
    }

    @Override
    protected void handleCollision(PointList points, int index) {
        Point end;
        Point start = points.getFirstPoint();
        if (start.equals(end = points.getLastPoint())) {
            return;
        }
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        int position = end.getPosition(start);
        Vector ray = position == 4 || position == 16 ? new Vector(start, end) : new Vector(end, start);
        double length = ray.getLength();
        double xSeparation = (double)this.separation * ray.x / length * (double)(index / 2);
        double ySeparation = (double)this.separation * ray.y / length * (double)(index / 2);
        PrecisionPoint bendPoint = index % 2 == 0 ? new PrecisionPoint((double)midPoint.x + -1.0 * ySeparation, (double)midPoint.y + xSeparation) : new PrecisionPoint((double)midPoint.x + ySeparation, (double)midPoint.y + -1.0 * xSeparation);
        if (!((Point)bendPoint).equals(midPoint)) {
            points.insertPoint(bendPoint, 1);
        }
    }

    public void setSeparation(int value) {
        this.separation = value;
    }
}

