/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.SQLException;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResultSetTest {
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private java.sql.Connection jdbcConn = null;
    private java.sql.Statement jdbcStmt = null;
    private java.sql.ResultSet jdbcRs = null;

    @Before
    public void resultSetSetUp() throws Exception {
        TestUtil.createTestData();
        this.conn = TestUtil.openConnection();
        this.stmt = (Statement)this.conn.newQuery("");
        String sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        this.jdbcConn = TestUtil.openJDBCConnection();
        this.jdbcStmt = this.jdbcConn.createStatement(1005, 1008);
        this.jdbcRs = this.jdbcStmt.executeQuery(sql);
    }

    @After
    public void resultSetTearDown() throws Exception {
        try {
            this.rs.close();
            this.jdbcRs.close();
        }
        catch (Exception e) {
            System.out.println("Close result set failed. Might have already been closed in testClose().");
        }
        this.stmt.close();
        this.conn.close();
        this.jdbcStmt.close();
        this.jdbcConn.close();
        TestUtil.deleteTestData();
    }

    @Test
    public void testResultValuesByIndex() throws Exception {
        Assert.assertEquals((long)this.rs.getRow(), (long)this.jdbcRs.getRow());
        while (this.rs.next()) {
            this.jdbcRs.next();
            Assert.assertEquals((Object)this.rs.wasNull(), (Object)this.jdbcRs.wasNull());
            Assert.assertEquals((long)this.rs.getRow(), (long)this.jdbcRs.getRow());
            Assert.assertEquals((Object)this.rs.getBigDecimal(1), (Object)this.jdbcRs.getBigDecimal(1));
            Assert.assertEquals((Object)this.rs.getDate(2), (Object)this.jdbcRs.getDate(2));
            Assert.assertEquals((double)this.rs.getDouble(3), (double)this.jdbcRs.getDouble(3), (double)Double.MIN_VALUE);
            Assert.assertEquals((long)this.rs.getInt(4), (long)this.jdbcRs.getInt(4));
            Assert.assertEquals((Object)this.rs.getString(5), (Object)this.jdbcRs.getString(5));
            Assert.assertEquals((Object)this.rs.getTime(6), (Object)this.jdbcRs.getTime(6));
            Assert.assertEquals((Object)this.rs.getTimestamp(7), (Object)this.jdbcRs.getTimestamp(7));
        }
    }

    @Test
    public void testResultValuesByColName() throws Exception {
        int i = 0;
        while (this.rs.next()) {
            this.jdbcRs.next();
            String colName = "col" + i;
            ++i;
            Assert.assertEquals((Object)this.rs.getString(colName), (Object)this.jdbcRs.getString(colName));
        }
    }

    @Test
    public void testGetMetaData() throws Exception {
        Assert.assertNotNull((Object)this.rs.getMetaData());
    }

    @Test
    public void testClose() throws Exception {
        this.rs.close();
        this.jdbcRs.close();
        String sqlState = null;
        try {
            this.rs.next();
            Assert.fail((String)"Call \"getRow\" when the result set is closed. Should have thrown JDBCException, but havn't.");
        }
        catch (JDBCException e) {
            sqlState = e.getSQLState();
        }
        try {
            this.jdbcRs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)e.getSQLState(), (Object)sqlState);
        }
    }

    @Test
    public void testSetMaxRows() throws Exception {
        int max = 0;
        this.rs.setMaxRows(max);
        int rowCount = 0;
        while (this.jdbcRs.next()) {
            Assert.assertTrue((boolean)this.rs.next());
            ++rowCount;
        }
        Assert.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        String sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = 1;
        this.rs.setMaxRows(max);
        Assert.assertTrue((boolean)this.rs.next());
        Assert.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = rowCount;
        this.rs.setMaxRows(max);
        int i = 0;
        while (i < rowCount) {
            Assert.assertTrue((boolean)this.rs.next());
            ++i;
        }
        Assert.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = rowCount + 10;
        this.rs.setMaxRows(max);
        i = 0;
        while (i < rowCount) {
            Assert.assertTrue((boolean)this.rs.next());
            ++i;
        }
        Assert.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = -1;
        this.rs.setMaxRows(max);
        i = 0;
        while (i < rowCount) {
            Assert.assertTrue((boolean)this.rs.next());
            ++i;
        }
        Assert.assertFalse((boolean)this.rs.next());
    }

    @Test
    public void testFindColumn() throws Exception {
        int columnCount = this.jdbcRs.getMetaData().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Assert.assertEquals((long)this.rs.findColumn(this.jdbcRs.getMetaData().getColumnName(i + 1)), (long)(i + 1));
            ++i;
        }
    }
}

