/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.core.data.DateUtil;
import org.junit.Test;

public class DateUtilTest
extends TestCase {
    @Test
    public void testCheckValid() {
        ULocale locale = ULocale.UK;
        DateFormat df = DateFormat.getDateInstance((int)3, (Locale)locale.toLocale());
        String dateStr = "25/11/16 ";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        boolean isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertTrue((boolean)isValid);
        dateStr = "25/11/6 ";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertTrue((boolean)isValid);
        dateStr = "2005/11/16 ";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        locale = ULocale.US;
        df = DateFormat.getDateInstance((int)3, (Locale)locale.toLocale());
        dateStr = "11/25/16";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertTrue((boolean)isValid);
        dateStr = "21/11/6";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "2005/11/6";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "11/44/16";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "11/31/1990";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "02/29/1990";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "02/28/1990";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertTrue((boolean)isValid);
        locale = ULocale.CHINA;
        df = DateFormat.getDateInstance((int)3, (Locale)locale.toLocale());
        dateStr = "2005/3/3";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertTrue((boolean)isValid);
        dateStr = "2005/13/6";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "2005/11/36";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "5/13/2005";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "2005/11/31";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        dateStr = "2005/2/29";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertFalse((boolean)isValid);
        dateStr = "2005/2/28";
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            DateUtilTest.fail((String)"can not reach here");
        }
        isValid = DateUtil.checkValid((DateFormat)df, (String)dateStr);
        DateUtilTest.assertTrue((boolean)isValid);
    }
}

