/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider.CrosstabFilterModelProvider;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class CrosstabFilterHandleProvider
extends AbstractFilterHandleProvider {
    private String[] columnKeys = new String[]{"level", "expr", "operator", "value1", "value2"};
    private static int[] columnWidth = new int[]{180, 150, 100, 150, 150};
    private String[] columnNames;
    private CellEditor[] editors;

    public CrosstabFilterHandleProvider() {
        this.modelAdapter = new CrosstabFilterModelProvider();
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.modelAdapter.getColumnNames(this.columnKeys);
        }
        return this.columnNames;
    }

    public String getDisplayName() {
        return Messages.getString("FilterHandleProvider.Label.Filterby");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnKeys.length];
            this.editors[0] = new TextCellEditor((Composite)table);
            this.editors[1] = new TextCellEditor((Composite)table);
            this.editors[2] = new TextCellEditor((Composite)table);
            this.editors[3] = new TextCellEditor((Composite)table);
            this.editors[4] = new TextCellEditor((Composite)table);
        }
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws PropertyValueException {
        return false;
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        return this.modelAdapter.deleteItem(this.contentInput.get(0), pos);
    }

    public boolean doAddItem(int pos) throws SemanticException {
        return this.modelAdapter.doAddItem(this.contentInput.get(0), pos);
    }

    public boolean doEditItem(int pos) {
        return ((CrosstabFilterModelProvider)this.modelAdapter).doEditItem(this.contentInput.get(0), pos);
    }

    public String getColumnText(Object element, int columnIndex) {
        String key = this.columnKeys[columnIndex];
        return this.modelAdapter.getText(element, key);
    }

    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            this.contentInput = (List)inputElement;
        } else {
            this.contentInput = new ArrayList();
            this.contentInput.add(inputElement);
        }
        Object[] elements = this.modelAdapter.getElements(this.contentInput);
        return elements;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws NameException, SemanticException {
        return false;
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        String propertyName;
        return event instanceof PropertyEvent && ("filter".equals(propertyName = ((PropertyEvent)event).getPropertyName()) || "paramBindings".equals(propertyName) || "level".equals(propertyName));
    }

    public IFormProvider getConcreteFilterProvider() {
        return this;
    }
}

