/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.internal;

import junit.framework.TestCase;
import org.eclipse.birt.chart.internal.computations.Matrix;

public class MatrixTest
extends TestCase {
    Matrix matrix;

    protected void setUp() throws Exception {
        super.setUp();
        double[][] d = new double[][]{{1.0, 2.0}, {3.0, 4.0}};
        this.matrix = new Matrix((double[][])d, 2, 2);
    }

    protected void tearDown() throws Exception {
        this.matrix = null;
        super.tearDown();
    }

    public void testCopy() {
        Matrix matrixCopy = this.matrix.copy();
        int i = 0;
        while (i < 2) {
            MatrixTest.assertEquals((double)matrixCopy.get(i, 0), (double)(i * 2 + 1), (double)0.0);
            MatrixTest.assertEquals((double)matrixCopy.get(i, 1), (double)(i * 2 + 2), (double)0.0);
            ++i;
        }
    }

    public void testGetDimension() {
        MatrixTest.assertEquals((int)this.matrix.getRowDimension(), (int)2);
        MatrixTest.assertEquals((int)this.matrix.getColumnDimension(), (int)2);
    }

    public void testTranspose() {
        Matrix matrixTrans = this.matrix.transpose();
        MatrixTest.assertEquals((double)matrixTrans.get(0, 0), (double)1.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixTrans.get(0, 1), (double)3.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixTrans.get(1, 0), (double)2.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixTrans.get(1, 1), (double)4.0, (double)0.0);
    }

    public void testTimes() {
        Matrix matrixTimes = this.matrix.times(this.matrix);
        MatrixTest.assertEquals((double)matrixTimes.get(0, 0), (double)7.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixTimes.get(0, 1), (double)10.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixTimes.get(1, 0), (double)15.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixTimes.get(1, 1), (double)22.0, (double)0.0);
    }

    public void testIdentity() {
        Matrix matrixId = Matrix.identity((int)3, (int)3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i == j) {
                    MatrixTest.assertEquals((double)matrixId.get(i, j), (double)1.0, (double)0.0);
                } else {
                    MatrixTest.assertEquals((double)matrixId.get(i, j), (double)0.0, (double)0.0);
                }
                ++j;
            }
            ++i;
        }
    }

    public void testInverse() {
        Matrix matrixInv = this.matrix.inverse();
        MatrixTest.assertEquals((double)matrixInv.get(0, 0), (double)-2.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixInv.get(0, 1), (double)1.0, (double)0.0);
        MatrixTest.assertEquals((double)matrixInv.get(1, 0), (double)1.5, (double)0.0);
        MatrixTest.assertEquals((double)matrixInv.get(1, 1), (double)-0.5, (double)0.0);
    }
}

