/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import com.ibm.icu.util.Calendar;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeOfUtilTest {
    private ResultClass resultClass;
    private SizeOfUtil sizeOfUtil;

    @Before
    public void sizeOfUtilsSetUp() throws DataException {
        this.resultClass = this.getResultClass();
        this.sizeOfUtil = new SizeOfUtil((IResultClass)this.resultClass);
    }

    @Test
    public void testSizeOfUtil() throws DataException {
        String x = System.getProperty("java.version");
        this.runWithJDK18();
    }

    private void runWithJDK18() throws DataException {
        Assert.assertEquals((long)520L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(1, 1)));
        Assert.assertEquals((long)528L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(3, 3)));
        Assert.assertEquals((long)536L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(3, 7)));
        Assert.assertEquals((long)536L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(5, 8)));
        Assert.assertEquals((long)552L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(12, 7)));
        Assert.assertEquals((long)544L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(7, 12)));
        Assert.assertEquals((long)576L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(18, 22)));
        Assert.assertEquals((long)632L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(38, 42)));
        Assert.assertEquals((long)192L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 3, new int[]{2, 4, 6, 7})));
        Assert.assertEquals((long)280L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 3, new int[]{2, 4})));
        Assert.assertEquals((long)256L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 7, new int[]{2, 7})));
        Assert.assertEquals((long)472L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(5, 8, new int[]{3, 6})));
        Assert.assertEquals((long)464L, (long)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(12, 7, new int[]{1, 4, 5})));
    }

    private ResultClass getResultClass() throws DataException {
        ArrayList<ResultFieldMetadata> columnList = new ArrayList<ResultFieldMetadata>();
        ResultFieldMetadata metaData = new ResultFieldMetadata(1, "1", "1", Integer.class, Integer.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(2, "2", "2", Double.class, Double.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(3, "3", "3", BigDecimal.class, BigDecimal.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(4, "4", "4", Date.class, Date.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(5, "5", "5", Time.class, Time.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(6, "6", "6", Timestamp.class, Timestamp.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(7, "7", "7", byte[].class, byte[].class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(8, "8", "8", String.class, String.class.getName(), false);
        columnList.add(metaData);
        ResultClass reClass = new ResultClass(columnList);
        return reClass;
    }

    private ResultObject getResultObject(int strLen, int byteLen) {
        return this.getResultObjectWithNull(strLen, byteLen, new int[0]);
    }

    private ResultObject getResultObjectWithNull(int strLen, int byteLen, int[] nullPos) {
        Object[] objectArray = new Object[8];
        Calendar calendar = Calendar.getInstance();
        objectArray[0] = new Integer(10);
        objectArray[1] = new Double(10.0);
        objectArray[2] = new BigDecimal("1111111111111111111111111111");
        calendar.clear();
        calendar.set(1919, 2, 2);
        objectArray[3] = calendar.getTime();
        calendar.clear();
        calendar.set(1970, 0, 1, 19, 2, 2);
        objectArray[4] = new Time(calendar.getTimeInMillis());
        calendar.clear();
        calendar.set(1919, 2, 2, 2, 2, 2);
        objectArray[5] = new Timestamp(calendar.getTimeInMillis());
        ((Timestamp)objectArray[5]).setNanos(2);
        objectArray[6] = new byte[byteLen];
        objectArray[7] = org.eclipse.birt.data.engine.perf.util.SizeOfUtil.newString(strLen);
        int i = 0;
        while (i < nullPos.length) {
            objectArray[nullPos[i]] = null;
            ++i;
        }
        ResultObject object = new ResultObject((IResultClass)this.resultClass, objectArray);
        return object;
    }
}

