/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LineHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class GroupElementHandleTest
extends BaseTestCase {
    ElementFactory elemFactory = null;

    @Override
    protected void setUp() throws Exception {
        this.design = (ReportDesign)DesignEngine.newSession((ULocale)ULocale.ENGLISH).createDesign().getModule();
        this.designHandle = (ReportDesignHandle)this.design.getHandle((Module)this.design);
        this.elemFactory = new ElementFactory((Module)this.design);
    }

    public void testGetCommonProperties() throws MetaDataException {
        MockupElementDefn elemDefn1 = new MockupElementDefn();
        MockupElementDefn elemDefn2 = new MockupElementDefn();
        MockupElementDefn elemDefn3 = new MockupElementDefn();
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        PropertyType type = dd.getPropertyType(0);
        SystemPropertyDefn prop1 = new SystemPropertyDefn();
        prop1.setName("prop1");
        prop1.setType(type);
        SystemPropertyDefn prop2 = new SystemPropertyDefn();
        prop2.setName("prop2");
        prop2.setType(type);
        SystemPropertyDefn prop3 = new SystemPropertyDefn();
        prop3.setName("prop3");
        prop3.setType(type);
        SystemPropertyDefn prop4 = new SystemPropertyDefn();
        prop4.setName("prop4");
        prop4.setType(type);
        SystemPropertyDefn prop5 = new SystemPropertyDefn();
        prop5.setName("prop5");
        prop5.setType(type);
        elemDefn1.addProperty((PropertyDefn)prop1);
        elemDefn1.addProperty((PropertyDefn)prop2);
        elemDefn1.addProperty((PropertyDefn)prop3);
        elemDefn1.addProperty((PropertyDefn)prop4);
        elemDefn1.addProperty((PropertyDefn)prop5);
        elemDefn2.addProperty((PropertyDefn)prop1);
        elemDefn2.addProperty((PropertyDefn)prop2);
        elemDefn2.addProperty((PropertyDefn)prop3);
        elemDefn3.addProperty((PropertyDefn)prop3);
        elemDefn3.addProperty((PropertyDefn)prop4);
        elemDefn3.addProperty((PropertyDefn)prop5);
        elemDefn1.build();
        elemDefn2.build();
        elemDefn3.build();
        FakeElementHandle handle1 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn1));
        FakeElementHandle handle2 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn2));
        FakeElementHandle handle3 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn3));
        ArrayList<FakeElementHandle> elements = new ArrayList<FakeElementHandle>();
        elements.add(handle1);
        elements.add(handle2);
        elements.add(handle3);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertEquals((int)elements.size(), (int)groupElementHandle.getElements().size());
        List commProperties = groupElementHandle.getCommonProperties();
        GroupElementHandleTest.assertEquals((int)1, (int)commProperties.size());
        GroupElementHandleTest.assertEquals((String)"prop3", (String)((PropertyDefn)commProperties.get(0)).getName());
        elemDefn1 = new MockupElementDefn();
        elemDefn2 = new MockupElementDefn();
        elemDefn3 = new MockupElementDefn();
        elemDefn1.addProperty((PropertyDefn)prop1);
        elemDefn2.addProperty((PropertyDefn)prop1);
        elemDefn3.addProperty((PropertyDefn)prop3);
        elemDefn1.build();
        elemDefn2.build();
        elemDefn3.build();
        handle1 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn1));
        handle2 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn2));
        handle3 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn3));
        elements = new ArrayList();
        elements.add(handle1);
        elements.add(handle2);
        elements.add(handle3);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        commProperties = groupElementHandle.getCommonProperties();
        GroupElementHandleTest.assertEquals((int)0, (int)commProperties.size());
        elemDefn1 = new MockupElementDefn();
        elemDefn2 = new MockupElementDefn();
        elemDefn3 = new MockupElementDefn();
        elemDefn1.addProperty((PropertyDefn)prop1);
        elemDefn2.addProperty((PropertyDefn)prop2);
        elemDefn3.addProperty((PropertyDefn)prop3);
        elemDefn1.build();
        elemDefn2.build();
        elemDefn3.build();
        handle1 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn1));
        handle2 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn2));
        handle3 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn3));
        elements = new ArrayList();
        elements.add(handle1);
        elements.add(handle2);
        elements.add(handle3);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        commProperties = groupElementHandle.getCommonProperties();
        GroupElementHandleTest.assertEquals((int)0, (int)commProperties.size());
        elemDefn1 = new MockupElementDefn();
        elemDefn2 = new MockupElementDefn();
        elemDefn1.addProperty((PropertyDefn)prop1);
        elemDefn2.addProperty((PropertyDefn)prop2);
        elemDefn1.build();
        elemDefn2.build();
        MockupDesignElement element1 = new MockupDesignElement(elemDefn1);
        MockupDesignElement element2 = new MockupDesignElement(elemDefn2);
        UserPropertyDefn up1 = new UserPropertyDefn();
        up1.setName("UP1");
        UserPropertyDefn up2 = new UserPropertyDefn();
        up2.setName("UP2");
        element1.addUserPropertyDefn(up1);
        element1.addUserPropertyDefn(up2);
        element2.addUserPropertyDefn(up1);
        handle1 = new FakeElementHandle(this.design, element1);
        handle2 = new FakeElementHandle(this.design, element2);
        elements = new ArrayList();
        elements.add(handle1);
        elements.add(handle2);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        commProperties = groupElementHandle.getCommonProperties();
        GroupElementHandleTest.assertEquals((int)1, (int)commProperties.size());
        elemDefn1 = new MockupElementDefn();
        elemDefn2 = new MockupElementDefn();
        elemDefn1.addProperty((PropertyDefn)prop1);
        elemDefn1.addProperty((PropertyDefn)prop2);
        elemDefn2.addProperty((PropertyDefn)prop1);
        elemDefn1.build();
        elemDefn2.build();
        handle1 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn1));
        handle2 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn2));
        elements = new ArrayList();
        elements.add(handle1);
        elements.add(handle2);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        commProperties = groupElementHandle.getCommonProperties();
        GroupElementHandleTest.assertEquals((int)1, (int)commProperties.size());
        elemDefn3 = new MockupElementDefn();
        elemDefn3.addProperty((PropertyDefn)prop3);
        elemDefn3.build();
        handle3 = new FakeElementHandle(this.design, new MockupDesignElement(elemDefn3));
        elements.add(handle3);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        commProperties = groupElementHandle.getCommonProperties();
        GroupElementHandleTest.assertEquals((int)0, (int)commProperties.size());
    }

    public void testGetCommonPropertiesWithSlotHandle() throws MetaDataException {
        ArrayList<Object> elements1 = new ArrayList<Object>();
        FreeFormHandle formHandle = this.elemFactory.newFreeForm("ex");
        elements1.add(formHandle);
        elements1.add(this.elemFactory.newOdaDataSource("ex", null));
        elements1.add(new SlotHandle((DesignElementHandle)formHandle, 0));
        SimpleGroupElementHandle groupElementHandle1 = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements1);
        GroupElementHandleTest.assertEquals((int)0, (int)groupElementHandle1.getCommonProperties().size());
    }

    public void testIsSameType() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(this.elemFactory.newOdaDataSource("ex1", null));
        elements.add(this.elemFactory.newScriptDataSource("script1"));
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.isSameType());
        ArrayList<OdaDataSourceHandle> elements2 = new ArrayList<OdaDataSourceHandle>();
        elements2.add(this.elemFactory.newOdaDataSource("ex", null));
        elements2.add(this.elemFactory.newOdaDataSource("ex", null));
        SimpleGroupElementHandle groupElementHandle2 = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements2);
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle2.isSameType());
        ArrayList<Object> elements3 = new ArrayList<Object>();
        FreeFormHandle formHandle = this.elemFactory.newFreeForm("ex");
        elements3.add(formHandle);
        elements3.add(this.elemFactory.newFreeForm("ex"));
        elements3.add(new SlotHandle((DesignElementHandle)formHandle, 0));
        SimpleGroupElementHandle groupElementHandle3 = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements3);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle3.isSameType());
    }

    public void testSetValue() throws SemanticException, UserPropertyException, PropertyValueException, MetaDataException {
        GraphicMasterPageHandle handle1 = this.elemFactory.newGraphicMasterPage("page1");
        SimpleMasterPageHandle handle2 = this.elemFactory.newSimpleMasterPage("page2");
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(handle1);
        elements.add(handle2);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        groupElementHandle.setStringProperty("type", "custom");
        groupElementHandle.setStringProperty("height", "12pt");
        GroupElementHandleTest.assertEquals((String)"12pt", (String)handle1.getStringProperty("height"));
        GroupElementHandleTest.assertEquals((String)"12pt", (String)handle2.getStringProperty("height"));
        groupElementHandle.clearProperty("height");
        GroupElementHandleTest.assertNull((Object)handle1.getStringProperty("height"));
        GroupElementHandleTest.assertNull((Object)handle2.getStringProperty("height"));
        UserPropertyDefn up1 = new UserPropertyDefn();
        up1.setName("UP1");
        up1.setType(MetaDataDictionary.getInstance().getPropertyType(2));
        handle1.addUserPropertyDefn(up1);
        handle2.addUserPropertyDefn(up1);
        groupElementHandle.setProperty("UP1", (Object)"123");
        GroupElementHandleTest.assertEquals((String)"123", (String)handle1.getStringProperty("UP1"));
        GroupElementHandleTest.assertEquals((String)"123", (String)handle2.getStringProperty("UP1"));
        GroupPropertyHandle propHandle = groupElementHandle.getPropertyHandle("height");
        GroupElementHandleTest.assertNotNull((Object)propHandle);
        propHandle = groupElementHandle.getPropertyHandle("headerHeight");
        GroupElementHandleTest.assertNull((Object)propHandle);
    }

    public void testClearAllProperties() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        LabelHandle element1 = this.elemFactory.newLabel("label");
        TextItemHandle element2 = this.elemFactory.newTextItem("text");
        element1.setComments("New ReportItem");
        element1.setHeight("12pt");
        element1.setWidth("24pt");
        element1.setAction(new Action());
        element2.setComments("New ReportItem");
        element2.setHeight("12pt");
        element2.setWidth("24mm");
        element2.setContent("New Text");
        elements.add(element2);
        elements.add(element1);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertEquals((String)"12pt", (String)groupElementHandle.getStringProperty("height"));
        GroupElementHandleTest.assertEquals((String)"New ReportItem", (String)groupElementHandle.getStringProperty("comments"));
        GroupElementHandleTest.assertNull((Object)groupElementHandle.getStringProperty("width"));
        GroupElementHandleTest.assertNull((Object)groupElementHandle.getStringProperty("content"));
        groupElementHandle.clearLocalProperties();
        GroupElementHandleTest.assertNull((Object)groupElementHandle.getStringProperty("height"));
        GroupElementHandleTest.assertNull((Object)groupElementHandle.getStringProperty("comments"));
        GroupElementHandleTest.assertEquals((String)"New Text", (String)element2.getContent());
        GroupElementHandleTest.assertNotNull((Object)element1.getActionHandle());
        GroupElementHandleTest.assertEquals((String)"New Text", (String)element2.getContent());
        GroupElementHandleTest.assertNotNull((Object)element1.getActionHandle());
        LabelHandle baseLabel1 = this.elemFactory.newLabel("BaseLabel1");
        LabelHandle baseLabel2 = this.elemFactory.newLabel("BaseLabel2");
        this.designHandle.getComponents().add((DesignElementHandle)baseLabel1);
        this.designHandle.getComponents().add((DesignElementHandle)baseLabel2);
        LabelHandle label1 = (LabelHandle)this.elemFactory.newElementFrom((DesignElementHandle)baseLabel1, "Label1");
        LabelHandle label2 = (LabelHandle)this.elemFactory.newElementFrom((DesignElementHandle)baseLabel2, "Label2");
        elements = new ArrayList();
        elements.add(label1);
        elements.add(label2);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        groupElementHandle.clearLocalProperties();
        GroupElementHandleTest.assertNotNull((Object)label1.getExtends());
        GroupElementHandleTest.assertNotNull((Object)label2.getExtends());
        GraphicMasterPageHandle masterPage1 = this.elemFactory.newGraphicMasterPage("page1");
        this.designHandle.getMasterPages().add((DesignElementHandle)masterPage1);
        elements.clear();
        elements.add(masterPage1);
        elements.add(label1);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        groupElementHandle.clearLocalProperties();
        ExtendedItemHandle parentExtendedItem = this.elemFactory.newExtendedItem("parent", "TestingMatrix");
        this.designHandle.getComponents().add((DesignElementHandle)parentExtendedItem);
        DesignElementHandle childExtendedItem = this.elemFactory.newElementFrom((DesignElementHandle)parentExtendedItem, "child");
        this.designHandle.getBody().add(childExtendedItem);
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)parentExtendedItem.getProperty("xScale"));
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)childExtendedItem.getProperty("xScale"));
        elements.clear();
        elements.add(childExtendedItem);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        childExtendedItem.setProperty("xScale", (Object)"3");
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)parentExtendedItem.getProperty("xScale"));
        GroupElementHandleTest.assertEquals((Object)new Integer(3), (Object)childExtendedItem.getProperty("xScale"));
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        groupElementHandle.clearLocalProperties();
        ((ExtendedItemHandle)childExtendedItem).loadExtendedElement();
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)parentExtendedItem.getProperty("xScale"));
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)childExtendedItem.getProperty("xScale"));
        this.design.getActivityStack().undo();
        ((ExtendedItemHandle)childExtendedItem).loadExtendedElement();
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)parentExtendedItem.getProperty("xScale"));
        GroupElementHandleTest.assertEquals((Object)new Integer(3), (Object)childExtendedItem.getProperty("xScale"));
        this.design.getActivityStack().redo();
        ((ExtendedItemHandle)childExtendedItem).loadExtendedElement();
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)parentExtendedItem.getProperty("xScale"));
        GroupElementHandleTest.assertEquals((Object)new Integer(0), (Object)childExtendedItem.getProperty("xScale"));
    }

    public void testIsExtendedElements() throws ContentException, NameException, ExtendsException {
        ArrayList<Object> elements = new ArrayList<Object>();
        LabelHandle baseLabel = this.elemFactory.newLabel("baseLabel");
        TextItemHandle baseText = this.elemFactory.newTextItem("baseText");
        this.designHandle.getComponents().add((DesignElementHandle)baseLabel);
        this.designHandle.getComponents().add((DesignElementHandle)baseText);
        LabelHandle element1 = this.elemFactory.newLabel("label");
        TextItemHandle element2 = this.elemFactory.newTextItem("text");
        element1.setExtends((DesignElementHandle)baseLabel);
        element2.setExtends((DesignElementHandle)baseText);
        elements.add(element2);
        elements.add(element1);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.isExtendedElements());
        element2.setExtends(null);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.isExtendedElements());
    }

    public void testExtendsItemHasLocalProperties() throws Exception {
        this.openDesign("GroupElementHandleTest.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("aa");
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(labelHandle);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        labelHandle.setText("test aa");
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        labelHandle = (LabelHandle)this.designHandle.getElementByID(20L);
        elements.clear();
        elements.add(labelHandle);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        labelHandle.setStringProperty("text", "liblabeltext");
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        CubeHandle cube = this.designHandle.findCube("Data Cube");
        elements.clear();
        elements.add(cube);
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
    }

    public void testHasLocalProperties() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        LabelHandle element1 = this.elemFactory.newLabel("label1");
        LabelHandle element2 = this.elemFactory.newLabel("label2");
        element1.setText("new Label1");
        TextItemHandle element3 = this.elemFactory.newTextItem("text");
        elements.add(element1);
        elements.add(element2);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        LabelHandle baseLabel = this.elemFactory.newLabel("baseLabel");
        this.designHandle.getComponents().add((DesignElementHandle)baseLabel);
        element1.setExtends((DesignElementHandle)baseLabel);
        element2.setExtends((DesignElementHandle)baseLabel);
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
        elements.add(element3);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.hasLocalPropertiesForExtendedElements());
    }

    public void testGetPropertyIterator() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        LabelHandle element1 = this.elemFactory.newLabel("label");
        TextItemHandle element2 = this.elemFactory.newTextItem("text");
        elements.add(element2);
        elements.add(element1);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        Iterator iter = groupElementHandle.propertyIterator();
        while (iter.hasNext()) {
            GroupPropertyHandle propHandle = (GroupPropertyHandle)iter.next();
            IElementPropertyDefn propDefn = propHandle.getPropertyDefn();
            if (!"height".equalsIgnoreCase(propDefn.getName())) continue;
            propHandle.setStringValue("12pt");
            GroupElementHandleTest.assertEquals((String)"12pt", (String)propHandle.getStringValue());
            propHandle.clearValue();
        }
    }

    public void testGetVisiblePropertyIterator() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        LabelHandle element1 = this.elemFactory.newLabel("label");
        TextItemHandle element2 = this.elemFactory.newTextItem("text");
        elements.add(element2);
        elements.add(element1);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        Iterator iter = groupElementHandle.visiblePropertyIterator();
        while (iter.hasNext()) {
            GroupPropertyHandle propHandle = (GroupPropertyHandle)iter.next();
            GroupElementHandleTest.assertTrue((boolean)propHandle.isVisible());
        }
    }

    public void testShareSameValue() throws SemanticException {
        ArrayList<LabelHandle> elements = new ArrayList<LabelHandle>();
        LabelHandle label1 = this.elemFactory.newLabel("Label1");
        LabelHandle label2 = this.elemFactory.newLabel("Label2");
        elements.add(label1);
        elements.add(label2);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.shareSameValue("not-defined-prop"));
        label1.setBookmark("bookmark1");
        label2.setBookmark("bookmark1");
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.shareSameValue("bookmark"));
        GroupElementHandleTest.assertEquals((String)"bookmark1", (String)groupElementHandle.getStringProperty("bookmark"));
        label1.setBookmark(null);
        label2.setBookmark(null);
        GroupElementHandleTest.assertTrue((boolean)groupElementHandle.shareSameValue("bookmark"));
        GroupElementHandleTest.assertEquals(null, (String)groupElementHandle.getStringProperty("bookmark"));
        label1.setBookmark(null);
        label2.setBookmark("bookmark2");
        GroupElementHandleTest.assertFalse((boolean)groupElementHandle.shareSameValue("bookmark"));
        GroupElementHandleTest.assertEquals(null, (String)groupElementHandle.getStringProperty("bookmark"));
    }

    public void testGetStringValue() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        LineHandle element1 = this.elemFactory.newLineItem("item1");
        LineHandle element2 = this.elemFactory.newLineItem("item2");
        LineHandle element3 = this.elemFactory.newLineItem("item3");
        elements.add(element1);
        elements.add(element2);
        elements.add(element3);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        element1.setProperty("comments", (Object)"Hi, Rock");
        element2.setProperty("comments", (Object)"Hi, Rock");
        element3.setProperty("comments", (Object)"Hi, Rock");
        GroupElementHandleTest.assertEquals((String)"Hi, Rock", (String)groupElementHandle.getStringProperty("comments"));
        element2.setProperty("comments", (Object)"Hi, Ivy");
        GroupElementHandleTest.assertEquals(null, (String)groupElementHandle.getStringProperty("comments"));
        element1.setProperty("comments", null);
        element2.setProperty("comments", null);
        element3.setProperty("comments", null);
        GroupElementHandleTest.assertEquals(null, (String)groupElementHandle.getStringProperty("comments"));
        elements = new ArrayList();
        LabelHandle label1 = this.elemFactory.newLabel("Label1");
        LabelHandle label2 = this.elemFactory.newLabel("Label2");
        elements.add(label1);
        elements.add(label2);
        label1.setX("123.123mm");
        label2.setX("123.123mm");
        groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertEquals((String)"123.123mm", (String)groupElementHandle.getStringProperty("x"));
        label1.setX("123.123mm");
        label2.setX("111.123mm");
        GroupElementHandleTest.assertEquals(null, (String)groupElementHandle.getStringProperty("x"));
    }

    public void testGetDesign() throws SemanticException {
        GraphicMasterPageHandle handle1 = this.elemFactory.newGraphicMasterPage("page1");
        SimpleMasterPageHandle handle2 = this.elemFactory.newSimpleMasterPage("page2");
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(handle1);
        elements.add(handle2);
        SimpleGroupElementHandle groupElementHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertEquals((Object)this.design, (Object)groupElementHandle.getModule());
        GroupElementHandleTest.assertEquals((Object)this.designHandle, (Object)groupElementHandle.getModuleHandle());
    }

    public void testPropertyVisibilities() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        DataItemHandle element1 = this.elemFactory.newDataItem("data1");
        TextItemHandle element2 = this.elemFactory.newTextItem("text");
        LabelHandle element3 = this.elemFactory.newLabel("label1");
        elements.add(element1);
        elements.add(element2);
        elements.add(element3);
        ReportDesignHandle designHandle = (ReportDesignHandle)this.design.getHandle((Module)this.design);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)designHandle, elements);
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("name").isVisible());
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("height").isVisible());
        GroupElementHandleTest.assertFalse((boolean)groupHandle.getPropertyHandle("propertyMasks").isVisible());
        GroupElementHandleTest.assertFalse((boolean)groupHandle.getPropertyHandle("dataSet").isVisible());
        GroupElementHandleTest.assertFalse((boolean)groupHandle.getPropertyHandle("x").isVisible());
    }

    public void testGetDisplayValue() throws SemanticException {
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.GERMAN);
        ReportDesignHandle designHandle = session.createDesign();
        ArrayList<SimpleMasterPageHandle> elements = new ArrayList<SimpleMasterPageHandle>();
        ElementFactory factory = designHandle.getElementFactory();
        SimpleMasterPageHandle page1 = factory.newSimpleMasterPage("page1");
        SimpleMasterPageHandle page2 = factory.newSimpleMasterPage("page2");
        elements.add(page1);
        elements.add(page2);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)designHandle, elements);
        GroupPropertyHandle groupPropertyHandle = groupHandle.getPropertyHandle("headerHeight");
        groupPropertyHandle.setValue((Object)"500.0");
        GroupElementHandleTest.assertEquals((String)"5.000in", (String)groupPropertyHandle.getDisplayValue());
        GroupElementHandleTest.assertEquals((String)"5000in", (String)groupPropertyHandle.getStringValue());
    }

    public void testIsPropertyReadOnlyAndIsPropertyVisible() throws SemanticException {
        ArrayList<Object> elements = new ArrayList<Object>();
        SimpleMasterPageHandle element = this.elemFactory.newSimpleMasterPage("my page");
        LabelHandle element1 = this.elemFactory.newLabel("label1");
        element.addElement((DesignElementHandle)element1, 0);
        elements.add(element1);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertTrue((!groupHandle.getPropertyHandle("toc").isVisible() ? 1 : 0) != 0);
        GroupElementHandleTest.assertTrue((!groupHandle.getPropertyHandle("bookmark").isVisible() ? 1 : 0) != 0);
        GroupElementHandleTest.assertTrue((!groupHandle.getPropertyHandle("pageBreakAfter").isVisible() ? 1 : 0) != 0);
        GroupElementHandleTest.assertTrue((!groupHandle.getPropertyHandle("pageBreakBefore").isVisible() ? 1 : 0) != 0);
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("toc").isReadOnly());
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("bookmark").isReadOnly());
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("pageBreakAfter").isReadOnly());
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("pageBreakBefore").isReadOnly());
        elements.clear();
        TableHandle table = this.elemFactory.newTableItem("table");
        RowHandle row = this.elemFactory.newTableRow();
        CellHandle cell = this.elemFactory.newCell();
        row.addElement((DesignElementHandle)cell, 0);
        elements.add(cell);
        groupHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertTrue((!groupHandle.getPropertyHandle("drop").isVisible() ? 1 : 0) != 0);
        GroupElementHandleTest.assertTrue((boolean)groupHandle.getPropertyHandle("drop").isReadOnly());
    }

    public void testGetDisplayProperty() throws Exception {
        this.createDesign(TEST_LOCALE);
        this.elemFactory = new ElementFactory((Module)this.design);
        ArrayList<LabelHandle> elements = new ArrayList<LabelHandle>();
        LabelHandle element1 = this.elemFactory.newLabel("label1");
        this.designHandle.addElement((DesignElementHandle)element1, 6);
        elements.add(element1);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, elements);
        GroupElementHandleTest.assertEquals((String)"\u9ed1\u8272", (String)groupHandle.getDisplayProperty("color"));
    }

    static class FakeElementHandle
    extends DesignElementHandle {
        DesignElement element = null;

        public FakeElementHandle(ReportDesign design, DesignElement element) {
            super((Module)design);
            this.element = element;
        }

        public DesignElement getElement() {
            return this.element;
        }
    }

    static class MockupDesignElement
    extends DesignElement {
        MockupElementDefn defn = null;

        public MockupDesignElement(MockupElementDefn defn) {
            this.cachedDefn = defn;
            this.defn = defn;
        }

        public IElementDefn getDefn() {
            return this.defn;
        }

        public void apply(ElementVisitor visitor) {
        }

        public String getElementName() {
            return null;
        }

        public DesignElementHandle getHandle(Module rootElement) {
            return null;
        }
    }

    static class MockupElementDefn
    extends ElementDefn {
        protected void build() throws MetaDataException {
            MockupElementDefn tmpDefn = this;
            while (tmpDefn != null) {
                List props = tmpDefn.getLocalProperties();
                int i = 0;
                while (i < props.size()) {
                    IElementPropertyDefn propDefn = (IElementPropertyDefn)props.get(i);
                    this.cachedProperties.put(propDefn.getName(), propDefn);
                    ++i;
                }
                tmpDefn = (ElementDefn)tmpDefn.getParent();
            }
        }
    }
}

