/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.Regions;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class PresentationDamager
implements IPresentationDamager {
    public void setDocument(IDocument document) {
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        if (!(e.getDocument() instanceof IXtextDocument)) {
            return new Region(0, 0);
        }
        XtextDocument document = (XtextDocument)e.getDocument();
        IRegion lastDamage = document.getLastDamage();
        if (!this.isEventMatchingLastDamage(e, lastDamage)) {
            return this.computeInterSection(partition, e, document);
        }
        if (!TextUtilities.overlaps((IRegion)partition, (IRegion)lastDamage) && lastDamage.getOffset() < e.getDocument().getLength()) {
            if (documentPartitioningChanged) {
                return partition;
            }
            return lastDamage;
        }
        int offset = Math.max(lastDamage.getOffset(), partition.getOffset());
        int endOffset = Math.min(lastDamage.getOffset() + lastDamage.getLength(), partition.getOffset() + partition.getLength());
        return new Region(offset, endOffset - offset);
    }

    protected IRegion computeInterSection(ITypedRegion partition, DocumentEvent e, XtextDocument document) {
        Iterable tokensInPartition = Iterables.filter(document.getTokens(), Regions.overlaps(partition.getOffset(), partition.getLength()));
        Iterator tokens = Iterables.filter((Iterable)tokensInPartition, Regions.overlaps(e.getOffset(), e.getLength())).iterator();
        if (tokens.hasNext()) {
            ILexerTokenRegion first;
            ILexerTokenRegion last = first = (ILexerTokenRegion)tokens.next();
            while (tokens.hasNext()) {
                last = (ILexerTokenRegion)tokens.next();
            }
            return new Region(first.getOffset(), last.getOffset() + last.getLength() - first.getOffset());
        }
        return partition;
    }

    protected boolean isEventMatchingLastDamage(DocumentEvent e, IRegion lastDamage) {
        int eventStart = e.getOffset();
        int eventEnd = eventStart + e.getText().length();
        int damageStart = lastDamage.getOffset();
        int damageEnd = damageStart + lastDamage.getLength();
        return damageStart <= eventStart && damageEnd >= eventEnd;
    }
}

