/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.type.impl;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.TypeFactory;
import org.eclipse.birt.chart.model.type.TypePackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class StockSeriesImpl
extends SeriesImpl
implements StockSeries {
    protected Fill fill;
    protected LineAttributes lineAttributes;
    protected static final boolean SHOW_AS_BAR_STICK_EDEFAULT = false;
    protected boolean showAsBarStick = false;
    protected boolean showAsBarStickESet;
    protected static final int STICK_LENGTH_EDEFAULT = 5;
    protected int stickLength = 5;
    protected boolean stickLengthESet;

    protected StockSeriesImpl() {
    }

    protected EClass eStaticClass() {
        return TypePackage.Literals.STOCK_SERIES;
    }

    public Fill getFill() {
        return this.fill;
    }

    public NotificationChain basicSetFill(Fill newFill, NotificationChain msgs) {
        Fill oldFill = this.fill;
        this.fill = newFill;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldFill, (Object)newFill);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setFill(Fill newFill) {
        if (newFill != this.fill) {
            NotificationChain msgs = null;
            if (this.fill != null) {
                msgs = ((InternalEObject)this.fill).eInverseRemove((InternalEObject)this, -13, null, msgs);
            }
            if (newFill != null) {
                msgs = ((InternalEObject)newFill).eInverseAdd((InternalEObject)this, -13, null, msgs);
            }
            if ((msgs = this.basicSetFill(newFill, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newFill, (Object)newFill));
        }
    }

    public LineAttributes getLineAttributes() {
        return this.lineAttributes;
    }

    public NotificationChain basicSetLineAttributes(LineAttributes newLineAttributes, NotificationChain msgs) {
        LineAttributes oldLineAttributes = this.lineAttributes;
        this.lineAttributes = newLineAttributes;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldLineAttributes, (Object)newLineAttributes);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setLineAttributes(LineAttributes newLineAttributes) {
        if (newLineAttributes != this.lineAttributes) {
            NotificationChain msgs = null;
            if (this.lineAttributes != null) {
                msgs = ((InternalEObject)this.lineAttributes).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newLineAttributes != null) {
                msgs = ((InternalEObject)newLineAttributes).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetLineAttributes(newLineAttributes, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newLineAttributes, (Object)newLineAttributes));
        }
    }

    public boolean isShowAsBarStick() {
        return this.showAsBarStick;
    }

    public void setShowAsBarStick(boolean newShowAsBarStick) {
        boolean oldShowAsBarStick = this.showAsBarStick;
        this.showAsBarStick = newShowAsBarStick;
        boolean oldShowAsBarStickESet = this.showAsBarStickESet;
        this.showAsBarStickESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldShowAsBarStick, this.showAsBarStick, !oldShowAsBarStickESet));
        }
    }

    public void unsetShowAsBarStick() {
        boolean oldShowAsBarStick = this.showAsBarStick;
        boolean oldShowAsBarStickESet = this.showAsBarStickESet;
        this.showAsBarStick = false;
        this.showAsBarStickESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 14, oldShowAsBarStick, false, oldShowAsBarStickESet));
        }
    }

    public boolean isSetShowAsBarStick() {
        return this.showAsBarStickESet;
    }

    public int getStickLength() {
        return this.stickLength;
    }

    public void setStickLength(int newStickLength) {
        int oldStickLength = this.stickLength;
        this.stickLength = newStickLength;
        boolean oldStickLengthESet = this.stickLengthESet;
        this.stickLengthESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldStickLength, this.stickLength, !oldStickLengthESet));
        }
    }

    public void unsetStickLength() {
        int oldStickLength = this.stickLength;
        boolean oldStickLengthESet = this.stickLengthESet;
        this.stickLength = 5;
        this.stickLengthESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 15, oldStickLength, 5, oldStickLengthESet));
        }
    }

    public boolean isSetStickLength() {
        return this.stickLengthESet;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return this.basicSetFill(null, msgs);
            }
            case 13: {
                return this.basicSetLineAttributes(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.getFill();
            }
            case 13: {
                return this.getLineAttributes();
            }
            case 14: {
                return this.isShowAsBarStick();
            }
            case 15: {
                return this.getStickLength();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setFill((Fill)newValue);
                return;
            }
            case 13: {
                this.setLineAttributes((LineAttributes)newValue);
                return;
            }
            case 14: {
                this.setShowAsBarStick((Boolean)newValue);
                return;
            }
            case 15: {
                this.setStickLength((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setFill(null);
                return;
            }
            case 13: {
                this.setLineAttributes(null);
                return;
            }
            case 14: {
                this.unsetShowAsBarStick();
                return;
            }
            case 15: {
                this.unsetStickLength();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return this.fill != null;
            }
            case 13: {
                return this.lineAttributes != null;
            }
            case 14: {
                return this.isSetShowAsBarStick();
            }
            case 15: {
                return this.isSetStickLength();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (showAsBarStick: ");
        if (this.showAsBarStickESet) {
            result.append(this.showAsBarStick);
        } else {
            result.append("<unset>");
        }
        result.append(", stickLength: ");
        if (this.stickLengthESet) {
            result.append(this.stickLength);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public final boolean canParticipateInCombination() {
        return true;
    }

    public void translateFrom(Series series, int iSeriesDefinitionIndex, Chart chart) {
        this.getLineAttributes().setVisible(true);
        this.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        this.setStacked(false);
        this.setLabel(series.getLabel());
        if (series.getLabelPosition().equals((Object)Position.INSIDE_LITERAL) || series.getLabelPosition().equals((Object)Position.OUTSIDE_LITERAL)) {
            this.setLabelPosition(series.getLabelPosition());
        } else {
            this.setLabelPosition(Position.OUTSIDE_LITERAL);
        }
        this.setVisible(series.isVisible());
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            this.getTriggers().addAll(series.getTriggers());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            this.setDataPoint(series.getDataPoint());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            this.getDataDefinition().addAll(series.getDataDefinition());
            if (!(series instanceof StockSeries)) {
                int length = this.getDataDefinition().size();
                while (length < 4) {
                    this.getDataDefinition().add((Object)QueryImpl.create(""));
                    ++length;
                }
            }
        }
        if (series instanceof BarSeries && ((BarSeries)series).getRiserOutline() != null) {
            this.getLineAttributes().setColor(((BarSeries)series).getRiserOutline());
        } else if (series instanceof LineSeries && ((LineSeries)series).getLineAttributes() != null) {
            this.setLineAttributes(((LineSeries)series).getLineAttributes());
        }
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        if (chart instanceof ChartWithAxes) {
            ((Axis)((ChartWithAxes)chart).getAxes().get(0)).setCategoryAxis(true);
            EList<Axis> axes = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            int i = 0;
            while (i < axes.size()) {
                ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                ((Axis)axes.get(i)).setPercent(false);
                ++i;
            }
        } else {
            throw new IllegalArgumentException(Messages.getString("error.invalid.argument.for.stockSeries", new Object[]{chart.getClass().getName()}, ULocale.getDefault()));
        }
        chart.setSampleData(this.getConvertedSampleData(chart.getSampleData(), iSeriesDefinitionIndex));
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, int iSeriesDefinitionIndex) {
        EList<OrthogonalSampleData> osdList = currentSampleData.getOrthogonalSampleData();
        int i = 0;
        while (i < osdList.size()) {
            if (i == iSeriesDefinitionIndex) {
                OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
                osd.setDataSetRepresentation(this.getConvertedOrthogonalSampleDataRepresentation(osd.getDataSetRepresentation()));
                currentSampleData.getOrthogonalSampleData().set(i, (Object)osd);
            }
            ++i;
        }
        return currentSampleData;
    }

    private String getConvertedOrthogonalSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        NumberFormat nf = NumberFormat.getNumberInstance();
        StringBuffer sbNewRepresentation = new StringBuffer("");
        int iValueCount = 0;
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            try {
                if (nf.parse(sElement).doubleValue() < 0.0) {
                    sElement = String.valueOf(4.0 + (double)iValueCount);
                    ++iValueCount;
                }
            }
            catch (ParseException parseException) {
                sElement = String.valueOf(4.0 + (double)iValueCount);
                ++iValueCount;
            }
            sbNewRepresentation.append("H");
            sbNewRepresentation.append(sElement);
            sbNewRepresentation.append(" ");
            sbNewRepresentation.append(" L");
            sbNewRepresentation.append(sElement);
            sbNewRepresentation.append(" ");
            sbNewRepresentation.append(" O");
            sbNewRepresentation.append(sElement);
            sbNewRepresentation.append(" ");
            sbNewRepresentation.append(" C");
            sbNewRepresentation.append(sElement);
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public boolean canShareAxisUnit() {
        return true;
    }

    public static final Series create() {
        StockSeries ss = TypeFactory.eINSTANCE.createStockSeries();
        ((StockSeriesImpl)ss).initialize();
        return ss;
    }

    protected final void initialize() {
        super.initialize();
        this.setLabelPosition(Position.ABOVE_LITERAL);
        LineAttributes lia = LineAttributesImpl.create(null, LineStyle.SOLID_LITERAL, 0);
        lia.setVisible(true);
        this.setLineAttributes(lia);
    }

    public String getDisplayName() {
        return Messages.getString("StockSeriesImpl.displayName");
    }

    public StockSeries copyInstance() {
        StockSeriesImpl dest = new StockSeriesImpl();
        dest.set(this);
        return dest;
    }

    protected void set(StockSeries src) {
        super.set(src);
        if (src.getFill() != null) {
            this.setFill(src.getFill().copyInstance());
        }
        if (src.getLineAttributes() != null) {
            this.setLineAttributes(src.getLineAttributes().copyInstance());
        }
        this.showAsBarStick = src.isShowAsBarStick();
        this.showAsBarStickESet = src.isSetShowAsBarStick();
        this.stickLength = src.getStickLength();
        this.stickLengthESet = src.isSetStickLength();
    }

    public int[] getDefinedDataDefinitionIndex() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        return nArray;
    }
}

