#!/usr/bin/bash
# Copyright (c) 2015-2021 Contributors to the Eclipse Foundation
# 
# See the NOTICE file(s) distributed with this work for additional
# information regarding copyright ownership.
# 
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0
# 
# SPDX-License-Identifier: EPL-2.0
#


_term() {
    trap - SIGTERM
    echo "SIGTERM in startBridge"
    LOOP=0
    kill -TERM "$bridge" 2>/dev/null
    wait "$bridge"
}

mkdir -p -m 770 /var/lib/amlen-bridge/diag/logs
INITLOG=/var/lib/amlen-bridge/diag/logs/imabridge_start.log
export INITLOG

exec 200> /tmp/imabridge.lock
flock -e -n 200 2> /dev/null
if [ "$?" != "0" ]; then
    echo "imabridge process is already running." >&2
    exit 255
fi

echo "" >> ${INITLOG}
echo "-------------------------------------------------------------------"  >> ${INITLOG}
echo "START imabridge" >> ${INITLOG}
echo "Date: $(date) " >> ${INITLOG}
echo "User: `whoami` " >> ${INITLOG}

# Initialize bridge if systemd hasn't already done it
if [ "$SYSTEMD_STARTED_IMABRIDGE" != "1" ]
then
    /usr/share/amlen-bridge/bin/initBridge.sh
fi

# Start imabridge
echo "Start imabridge" >> ${INITLOG}

LOOP=1

while [ $LOOP -gt 0 ];
do
    # Start service
    echo "Running bridge"
    cd /var/lib/amlen-bridge
    /usr/share/amlen-bridge/bin/imabridge -d >>/var/lib/amlen-bridge/diag/logs/console.log 2>&1 &
    bridge=$!
    trap _term SIGTERM
    wait "$bridge"

    if [ "$?" = "2" ]
    then
        LOOP=0
        /usr/share/amlen-bridge/bin/extractstackfromcore.sh
        exit 0
    fi

    if [ $LOOP -eq 0 ]
    then
        # Extract stack trace if previous run failed for any reason
        /usr/share/amlen-bridge/bin/extractstackfromcore.sh
        echo "startBridge terminated" $?
        exit 15
    fi
    
    # Extract stack trace if previous run failed for any reason
    /usr/share/amlen-bridge/bin/extractstackfromcore.sh
done

# Extract stack trace if previous run failed for any reason
/usr/share/amlen-bridge/bin/extractstackfromcore.sh

