/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;
import org.eclipse.emf.ecore.EPackage;

public class ClassLoaderQualifiedNameResolver
implements IQualifiedNameResolver {
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private final ClassLoader classLoader;
    private IQualifiedNameLookupEngine lookupEngine;
    private final String qualifierSeparator;
    private final List<ILoader> loaders = new ArrayList<ILoader>();
    private final Map<String, Object> qualifiedNameToObject = new HashMap<String, Object>();
    private final Map<Object, String> objectToQualifiedName = new HashMap<Object, String>();
    private final Map<Object, URI> objectToURI = new HashMap<Object, URI>();
    private final Map<String, List<String>> qualifiedNameToImports = new HashMap<String, List<String>>();
    private final Map<String, List<String>> qualifiedNameImportedBy = new HashMap<String, List<String>>();
    private final Map<String, List<String>> qualifiedNameToNsURIImports = new HashMap<String, List<String>>();
    private final Map<String, List<String>> nsURIImportedBy = new HashMap<String, List<String>>();
    private final Map<String, String> qualifiedNameToExtend = new HashMap<String, String>();
    private final Map<IService<?>, String> serviceToContextQualifiedName = new HashMap();
    private final Map<String, Set<IService<?>>> contextQualifiedNameToServices = new HashMap();
    private final Map<String, List<String>> qualifiedNameExtendedBy = new HashMap<String, List<String>>();
    private final EPackage.Registry ePackageRegistry;

    public ClassLoaderQualifiedNameResolver(ClassLoader classLoader, EPackage.Registry ePackageRegistry, String qualifierSeparator) {
        this.classLoader = classLoader;
        this.ePackageRegistry = ePackageRegistry;
        this.qualifierSeparator = qualifierSeparator;
    }

    @Override
    public String getQualifiedName(URI uri) {
        String filePath;
        String res = null;
        try {
            filePath = uri.toURL().getFile();
        }
        catch (MalformedURLException e) {
            filePath = null;
        }
        if (filePath != null) {
            int pathEnd = filePath.lastIndexOf(DOT);
            if (pathEnd < 0) {
                pathEnd = filePath.length();
            }
            String[] segments = filePath.substring(0, pathEnd).split(SLASH);
            StringBuilder moduleQualifiedNameBuilder = new StringBuilder();
            int i = segments.length - 1;
            while (i >= 0) {
                moduleQualifiedNameBuilder.insert(0, segments[i]);
                String qualifiedName = moduleQualifiedNameBuilder.toString();
                if (this.qualifiedNameURIMatch(qualifiedName, uri)) {
                    res = qualifiedName;
                }
                moduleQualifiedNameBuilder.insert(0, this.qualifierSeparator);
                --i;
            }
        }
        return res;
    }

    private boolean qualifiedNameURIMatch(String qualifiedName, URI uri) {
        Object resolved = this.qualifiedNameToObject.get(qualifiedName);
        boolean res = resolved != null ? uri.equals(this.getURI(resolved)) : uri.equals(this.getURI(qualifiedName));
        return res;
    }

    @Override
    public URI getURI(String qualifiedName) {
        URI res = null;
        for (ILoader loader : this.loaders) {
            try {
                res = this.getClassLoader().getResource(loader.resourceName(qualifiedName)).toURI();
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null) break;
        }
        return res;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public URI getSourceURI(String qualifiedName) {
        return this.getURI(qualifiedName);
    }

    @Override
    public ISourceLocation getSourceLocation(IService<?> service) {
        ISourceLocation res = null;
        for (ILoader loader : this.loaders) {
            res = loader.getSourceLocation((IQualifiedNameResolver)this, service);
            if (res != null) break;
        }
        return res;
    }

    @Override
    public URI getBinaryURI(URI sourceURI) {
        URI res = this.getQualifiedName(sourceURI) != null ? sourceURI : null;
        return res;
    }

    @Override
    public ISourceLocation getSourceLocation(String qualifiedName) {
        ISourceLocation res = null;
        for (ILoader loader : this.loaders) {
            res = loader.getSourceLocation((IQualifiedNameResolver)this, qualifiedName);
            if (res != null) break;
        }
        return res;
    }

    protected Object load(String qualifiedName) {
        Object res = null;
        boolean registered = false;
        for (ILoader loader : this.loaders) {
            res = loader.load(this, qualifiedName);
            if (res == null) continue;
            this.register(loader, qualifiedName, res);
            registered = true;
            break;
        }
        if (!registered) {
            this.dummyRegistration(qualifiedName);
        }
        return res;
    }

    protected void dummyRegistration(String qualifiedName) {
        this.qualifiedNameToImports.put(qualifiedName, Collections.emptyList());
        this.qualifiedNameToNsURIImports.put(qualifiedName, Collections.emptyList());
        this.qualifiedNameToExtend.put(qualifiedName, null);
        this.qualifiedNameToObject.put(qualifiedName, null);
    }

    @Override
    public void register(String qualifiedName, Object object) {
        ILoader loader = this.getLoaderFor(object);
        if (loader != null) {
            this.register(loader, qualifiedName, object);
        }
    }

    protected void register(ILoader loader, String qualifiedName, Object object) {
        List<String> imports = loader.getImports(object);
        this.qualifiedNameToImports.put(qualifiedName, imports);
        for (String imp : imports) {
            this.qualifiedNameImportedBy.computeIfAbsent(imp, qn -> new ArrayList()).add(qualifiedName);
        }
        List<String> nsURIImports = loader.getNsURIImports(object);
        this.qualifiedNameToNsURIImports.put(qualifiedName, nsURIImports);
        for (String imp : nsURIImports) {
            this.nsURIImportedBy.computeIfAbsent(imp, qn -> new ArrayList()).add(qualifiedName);
        }
        String ext = loader.getExtends(object);
        this.qualifiedNameToExtend.put(qualifiedName, ext);
        this.qualifiedNameExtendedBy.computeIfAbsent(ext, qn -> new ArrayList()).add(qualifiedName);
        Object removedObject = this.qualifiedNameToObject.put(qualifiedName, object);
        if (removedObject != null) {
            this.objectToQualifiedName.remove(removedObject);
            this.objectToURI.remove(removedObject);
        }
        this.objectToQualifiedName.put(object, qualifiedName);
        try {
            URL resource = this.getClassLoader().getResource(loader.resourceName(qualifiedName));
            if (resource != null) {
                this.objectToURI.put(object, resource.toURI());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private ILoader getLoaderFor(Object object) {
        ILoader res = null;
        for (ILoader loader : this.loaders) {
            if (!loader.canHandle(object)) continue;
            res = loader;
            break;
        }
        return res;
    }

    @Override
    public void clear(Set<String> qualifiedNames) {
        for (String qualifiedName : qualifiedNames) {
            List<String> extendedBy;
            String extended;
            List<String> importNsURIs;
            Object object = this.qualifiedNameToObject.remove(qualifiedName);
            this.objectToQualifiedName.remove(object);
            this.objectToURI.remove(object);
            List<String> imports = this.qualifiedNameToImports.remove(qualifiedName);
            if (imports != null) {
                for (String imported : imports) {
                    List<String> importedBy = this.qualifiedNameImportedBy.get(imported);
                    if (importedBy == null) continue;
                    importedBy.remove(qualifiedName);
                }
            }
            if ((importNsURIs = this.qualifiedNameToNsURIImports.remove(qualifiedName)) != null) {
                for (String imported : importNsURIs) {
                    List<String> importedBy = this.nsURIImportedBy.get(imported);
                    if (importedBy == null) continue;
                    importedBy.remove(qualifiedName);
                }
            }
            if ((extended = this.qualifiedNameToExtend.remove(qualifiedName)) == null || (extendedBy = this.qualifiedNameExtendedBy.get(extended)) == null) continue;
            extendedBy.remove(qualifiedName);
        }
    }

    @Override
    public Object resolve(String qualifiedName) {
        if (!this.qualifiedNameToObject.containsKey(qualifiedName)) {
            this.load(qualifiedName);
        }
        return this.qualifiedNameToObject.get(qualifiedName);
    }

    @Override
    public Set<IService<?>> getServices(IQualifiedNameLookupEngine lookupEngine, Object object, String contextQualifiedName) {
        LinkedHashSet res = new LinkedHashSet();
        ILoader loader = this.getLoaderFor(object);
        if (loader != null) {
            res.addAll(loader.getServices(lookupEngine, object, contextQualifiedName));
            for (IService iService : res) {
                this.serviceToContextQualifiedName.put(iService, contextQualifiedName);
            }
        }
        this.contextQualifiedNameToServices.put(contextQualifiedName, res);
        return res;
    }

    @Override
    public String getContextQualifiedName(IService<?> service) {
        return this.serviceToContextQualifiedName.get(service);
    }

    @Override
    public void cleanContextQualifiedName(String qualifiedName) {
        Set<IService<?>> services = this.contextQualifiedNameToServices.remove(qualifiedName);
        if (services != null) {
            for (IService<?> service : services) {
                this.serviceToContextQualifiedName.remove(service);
            }
        }
    }

    @Override
    public String getExtend(String qualifiedName) {
        if (!this.qualifiedNameToExtend.containsKey(qualifiedName)) {
            this.load(qualifiedName);
        }
        return this.qualifiedNameToExtend.get(qualifiedName);
    }

    @Override
    public List<String> getImports(String qualifiedName) {
        if (!this.qualifiedNameToImports.containsKey(qualifiedName)) {
            this.load(qualifiedName);
        }
        return this.qualifiedNameToImports.getOrDefault(qualifiedName, Collections.emptyList());
    }

    @Override
    public List<String> getNsURIImports(String qualifiedName) {
        if (!this.qualifiedNameToNsURIImports.containsKey(qualifiedName)) {
            this.load(qualifiedName);
        }
        return this.qualifiedNameToNsURIImports.getOrDefault(qualifiedName, Collections.emptyList());
    }

    @Override
    public Set<String> getDependOn(String qualifiedName) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        LinkedHashSet extendedByClosure = new LinkedHashSet();
        LinkedHashSet added = new LinkedHashSet(this.qualifiedNameExtendedBy.getOrDefault(qualifiedName, Collections.emptyList()));
        while (!added.isEmpty()) {
            LinkedHashSet localAdded = new LinkedHashSet();
            for (String addedQualifiedName : added) {
                if (extendedByClosure.contains(addedQualifiedName)) continue;
                localAdded.addAll(this.qualifiedNameExtendedBy.getOrDefault(addedQualifiedName, Collections.emptyList()));
            }
            extendedByClosure.addAll(added);
            added = localAdded;
        }
        res.addAll(extendedByClosure);
        res.addAll(this.qualifiedNameImportedBy.getOrDefault(qualifiedName, Collections.emptyList()));
        for (String extendedBy : extendedByClosure) {
            res.addAll(this.qualifiedNameImportedBy.getOrDefault(extendedBy, Collections.emptyList()));
        }
        return res;
    }

    @Override
    public InputStream getInputStream(String resourceName) {
        return this.getClassLoader().getResourceAsStream(resourceName);
    }

    @Override
    public Class<?> getClass(String qualifiedName) {
        Class<?> res;
        try {
            res = this.getClassLoader().loadClass(qualifiedName.replace(this.qualifierSeparator, DOT));
        }
        catch (Error | Exception e) {
            res = null;
        }
        return res;
    }

    @Override
    public Set<String> getAvailableQualifiedNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        try {
            ClassLoader clsLoader = this.getClassLoader();
            if (clsLoader instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)clsLoader).getURLs();
                int n = uRLArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    res.addAll(this.getQualifiedNamesFromURL(url));
                    ++n2;
                }
            } else {
                Enumeration<URL> rootResources = clsLoader.getResources("");
                while (rootResources.hasMoreElements()) {
                    URL url = rootResources.nextElement();
                    res.addAll(this.getQualifiedNamesFromURL(url));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public Set<String> getResolvedQualifiedNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (Map.Entry<String, Object> entry : this.qualifiedNameToObject.entrySet()) {
            if (entry.getValue() == null) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    protected Set<String> getQualifiedNamesFromURL(URL url) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if ("file".equals(url.getProtocol())) {
            try {
                File file = new File(url.toURI());
                if (file.isDirectory()) {
                    res.addAll(this.getQualifiedNameFromFolder(file, ""));
                } else if (file.isFile()) {
                    res.addAll(this.getQualifiedNameFromJar(file));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return res;
    }

    protected Set<String> getQualifiedNameFromJar(File file) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (ZipFile jarFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                block8: while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    for (ILoader loader : this.loaders) {
                        String qualifiedName = loader.qualifiedName(entry.getName());
                        if (qualifiedName == null) continue;
                        res.add(qualifiedName);
                        continue block8;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    protected Set<String> getQualifiedNameFromFolder(File folder, String nameSpace) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (folder.exists() && folder.canRead()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    res.addAll(this.getQualifiedNameFromFolder(child, nameSpace + child.getName() + this.qualifierSeparator));
                } else if (child.isFile()) {
                    for (ILoader loader : this.loaders) {
                        String lastSegment = loader.qualifiedName(child.getName());
                        if (lastSegment == null) continue;
                        res.add(nameSpace + lastSegment);
                        break;
                    }
                }
                ++n2;
            }
        }
        return res;
    }

    protected List<String> getPossibleResourceNames(String qualifiedName) {
        ArrayList<String> res = new ArrayList<String>();
        for (ILoader loader : this.loaders) {
            res.add(loader.sourceResourceName(qualifiedName));
        }
        return res;
    }

    @Override
    public String getQualifiedName(Object object) {
        return this.objectToQualifiedName.get(object);
    }

    @Override
    public URI getURI(Object object) {
        return this.objectToURI.get(object);
    }

    @Override
    public void addLoader(ILoader loader) {
        this.loaders.add(loader);
    }

    @Override
    public void removeLoader(ILoader loader) {
        this.loaders.remove(loader);
    }

    @Override
    public void clearLoaders() {
        this.loaders.clear();
    }

    @Override
    public void setLookupEngine(IQualifiedNameLookupEngine lookupEngine) {
        this.lookupEngine = lookupEngine;
    }

    @Override
    public IQualifiedNameLookupEngine getLookupEngine() {
        return this.lookupEngine;
    }

    @Override
    public void dispose() {
        if (this.classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.classLoader)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<String> getDependsOnNsURI(String nsURI) {
        LinkedHashSet<String> res = new LinkedHashSet<String>(this.qualifiedNameImportedBy.getOrDefault(nsURI, Collections.emptyList()));
        return res;
    }

    @Override
    public EPackage getEPackage(String nsURI) {
        return this.ePackageRegistry.getEPackage(nsURI);
    }

    @Override
    public Set<String> getAvailableNsURIs() {
        return this.ePackageRegistry.keySet();
    }
}

