/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class DWordValue
implements AnyBitValue {
    public static final DWordValue DEFAULT = new DWordValue(0);
    private final int value;

    private DWordValue(int value) {
        this.value = value;
    }

    public static DWordValue toDWordValue(int value) {
        return new DWordValue(value);
    }

    public static DWordValue toDWordValue(Number value) {
        return new DWordValue(value.intValue());
    }

    public static DWordValue toDWordValue(String value) {
        return DWordValue.toDWordValue((Number)NumericValueConverter.INSTANCE_DWORD.toValue(value));
    }

    public static DWordValue toDWordValue(AnyBitValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    public DwordType getType() {
        return IecTypes.ElementaryTypes.DWORD;
    }

    @Override
    public boolean boolValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return Integer.toUnsignedLong(this.value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DWordValue other = (DWordValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return NumericValueConverter.INSTANCE_DWORD.toString((Object)this.intValue());
    }
}

