/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.breakpoint;

import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.AdapterTypes;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.ui.breakpoint.DeploymentWatchpointUtil;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

@AdapterTypes(adaptableClass={INamedElement.class, EditPart.class, IEditorPart.class, IWatch.class}, adapterNames={IToggleBreakpointsTarget.class})
public class DeploymentToggleBreakpointsTargetExtension
implements IToggleBreakpointsTarget,
IAdapterFactory {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                Optional<INamedElement> element = DeploymentToggleBreakpointsTargetExtension.getElementFromSelection(selectedElement);
                if (!element.isPresent()) continue;
                DeploymentToggleBreakpointsTargetExtension.toggleWatchpoint(element.get());
            }
        }
    }

    protected static void toggleWatchpoint(INamedElement element) throws CoreException {
        EObject eObject = EcoreUtil.getRootContainer((EObject)element);
        if (eObject instanceof AutomationSystem) {
            AutomationSystem system = (AutomationSystem)eObject;
            DeploymentToggleBreakpointsTargetExtension.toggleWatchpoint((IResource)system.getTypeEntry().getFile(), element);
        }
    }

    protected static void toggleWatchpoint(IResource resource, INamedElement element) throws CoreException {
        Optional<DeploymentWatchpoint> existingBreakpoint = DeploymentWatchpointUtil.findExistingWatchpoint(resource, element);
        if (existingBreakpoint.isPresent()) {
            existingBreakpoint.get().delete();
        } else {
            DeploymentWatchpoint breakpoint = new DeploymentWatchpoint(resource, element);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return DeploymentToggleBreakpointsTargetExtension.isApplicable(selection);
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IEditorPart editorPart;
        if (adaptableObject instanceof IEditorPart && (editorPart = (IEditorPart)adaptableObject).getAdapter(AutomationSystem.class) != null && adapterType == IToggleBreakpointsTarget.class) {
            return adapterType.cast(this);
        }
        if (DeploymentToggleBreakpointsTargetExtension.getElementFromSelection(adaptableObject).isPresent() && adapterType == IToggleBreakpointsTarget.class) {
            return adapterType.cast(this);
        }
        return null;
    }

    private static boolean isApplicable(ISelection selection) {
        IStructuredSelection structuredSelection;
        return selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).stream().map(DeploymentToggleBreakpointsTargetExtension::getElementFromSelection).anyMatch(Optional::isPresent);
    }

    private static Optional<INamedElement> getElementFromSelection(Object selection) {
        return DeploymentToggleBreakpointsTargetExtension.getInterfaceElementFromSelection(selection).or(() -> DeploymentToggleBreakpointsTargetExtension.getFBNetworkElementFromSelection(selection)).filter(element -> EcoreUtil.getRootContainer((EObject)element) instanceof AutomationSystem);
    }

    private static Optional<INamedElement> getInterfaceElementFromSelection(Object selection) {
        return Optional.ofNullable((INamedElement)Adapters.adapt((Object)selection, IInterfaceElement.class));
    }

    private static Optional<INamedElement> getFBNetworkElementFromSelection(Object selection) {
        return Optional.ofNullable((INamedElement)Adapters.adapt((Object)selection, FBNetworkElement.class));
    }
}

