/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.provider.AttributeChangeItemProvider;
import org.eclipse.emf.compare.provider.ComparisonItemProvider;
import org.eclipse.emf.compare.provider.ConflictItemProvider;
import org.eclipse.emf.compare.provider.DiffItemProvider;
import org.eclipse.emf.compare.provider.EquivalenceItemProvider;
import org.eclipse.emf.compare.provider.FeatureMapChangeItemProvider;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.MatchResourceItemProvider;
import org.eclipse.emf.compare.provider.ReferenceChangeItemProvider;
import org.eclipse.emf.compare.provider.ResourceAttachmentChangeItemProvider;
import org.eclipse.emf.compare.provider.ResourceLocationChangeItemProvider;
import org.eclipse.emf.compare.util.CompareAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class CompareItemProviderAdapterFactory
extends CompareAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    public static final String copyright = "Copyright (c) 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Disposable disposable = new Disposable();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    public CompareItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
        this.supportedTypes.add(IItemColorProvider.class);
        this.supportedTypes.add(IItemFontProvider.class);
    }

    public Adapter createComparisonAdapter() {
        return new ComparisonItemProvider((AdapterFactory)this);
    }

    public Adapter createMatchResourceAdapter() {
        return new MatchResourceItemProvider((AdapterFactory)this);
    }

    public Adapter createMatchAdapter() {
        return new MatchItemProvider((AdapterFactory)this);
    }

    public Adapter createDiffAdapter() {
        return new DiffItemProvider((AdapterFactory)this);
    }

    public Adapter createResourceAttachmentChangeAdapter() {
        return new ResourceAttachmentChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createResourceLocationChangeAdapter() {
        return new ResourceLocationChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createReferenceChangeAdapter() {
        return new ReferenceChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createAttributeChangeAdapter() {
        return new AttributeChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createFeatureMapChangeAdapter() {
        return new FeatureMapChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createConflictAdapter() {
        return new ConflictItemProvider((AdapterFactory)this);
    }

    public Adapter createEquivalenceAdapter() {
        return new EquivalenceItemProvider((AdapterFactory)this);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter != null) {
            this.disposable.add((Object)adapter);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        this.disposable.dispose();
    }
}

