/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class DocumentTokenSourceAccess {
    @Inject
    private Provider<DocumentTokenSource> tokenSourceProvider;

    public IRegion getLastDamage(IDocument document) {
        if (document instanceof XtextDocument) {
            return ((XtextDocument)document).getLastDamage();
        }
        return new Region(0, document.getLength());
    }

    public Iterable<ILexerTokenRegion> getTokens(IDocument document, boolean nullIfNotCached) {
        if (document instanceof XtextDocument) {
            return ((XtextDocument)document).getTokens();
        }
        if (nullIfNotCached) {
            return null;
        }
        DocumentTokenSource tokenSource = (DocumentTokenSource)this.tokenSourceProvider.get();
        tokenSource.computeDamageRegion(new DocumentEvent(document, 0, document.getLength(), document.get()));
        return tokenSource.getTokenInfos();
    }
}

