/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.actions.MergeToolActionHandler;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.egit.ui.internal.merge.MergeModeDialog;
import org.eclipse.emf.compare.egit.internal.EGitCompatibilityUtil;
import org.eclipse.emf.compare.egit.ui.internal.merge.ModelGitMergeEditorInput;
import org.eclipse.emf.compare.egit.ui.internal.merge.ModelGitMergeEditorInputLegacy;

public class ModelMergeToolActionHandler
extends MergeToolActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompareEditorInput input;
        int mergeMode = Activator.getDefault().getPreferenceStore().getInt("merge_mode");
        IPath[] locations = this.getSelectedLocations(event);
        if (mergeMode == 0) {
            MergeModeDialog dlg = new MergeModeDialog(this.getShell(event));
            if (dlg.open() != 0) {
                return null;
            }
            if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGitCompatibilityUtil.EGIT_6_0) >= 0) {
                input = new ModelGitMergeEditorInput(dlg.getMergeMode(), locations);
            } else {
                Boolean useWs = (Boolean)EGitCompatibilityUtil.invoke(dlg.getClass(), (Object)dlg, (String)"useWorkspace");
                input = new ModelGitMergeEditorInputLegacy(useWs, locations);
            }
        } else if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGitCompatibilityUtil.EGIT_6_0) >= 0) {
            MergeInputMode mode = MergeInputMode.fromInteger((int)mergeMode);
            input = new ModelGitMergeEditorInput(mode, locations);
        } else {
            boolean useWorkspace = mergeMode == 1;
            input = new ModelGitMergeEditorInputLegacy(useWorkspace, locations);
        }
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }
}

