/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenTypeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        EObject object = OpenTypeHandler.getSelectedObject((ISelection)sel);
        if (object != null) {
            OpenTypeHandler.openTypeEditor(object);
        }
        return null;
    }

    private static void openTypeEditor(EObject object) {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            try {
                OpenListenerManager.openEditor((EObject)object);
            }
            catch (Exception e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        ISelection sel = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(OpenTypeHandler.getSelectedObject(sel) != null);
    }

    private static EObject getSelectedObject(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)sel;
            if (!sel.isEmpty() && structSel.size() == 1) {
                EObject eObject;
                Object obj = structSel.getFirstElement();
                if (obj instanceof EditPart) {
                    EditPart ep = (EditPart)obj;
                    obj = ep.getModel();
                }
                Object object = obj;
                Objects.requireNonNull(object);
                Object object2 = object;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBNetwork.class, FBNetworkElement.class, IInterfaceElement.class}, (Object)object2, 0)) {
                    case 0: {
                        FBNetwork fbn = (FBNetwork)object2;
                        EObject eObject2 = OpenTypeHandler.getEObjectForOpening(fbn);
                        break;
                    }
                    case 1: {
                        FBNetworkElement fbnEl = (FBNetworkElement)object2;
                        EObject eObject2 = fbnEl.getType();
                        break;
                    }
                    case 2: {
                        IInterfaceElement ie = (IInterfaceElement)object2;
                        EObject eObject2 = ie.getType();
                        break;
                    }
                    default: {
                        EObject eObject2 = eObject = null;
                    }
                }
                if (eObject != null) {
                    return eObject;
                }
            }
        }
        return null;
    }

    private static EObject getEObjectForOpening(FBNetwork fbn) {
        EObject eObject;
        EObject eObject2 = fbn.eContainer();
        if (eObject2 instanceof UntypedSubApp) {
            UntypedSubApp usa;
            UntypedSubApp element = usa = (UntypedSubApp)eObject2;
            ArrayList<String> subAppNames = new ArrayList<String>();
            while (element != null) {
                EObject eObject3;
                if (element instanceof INamedElement) {
                    INamedElement ine = (INamedElement)element;
                    subAppNames.add(ine.getName());
                }
                if ((eObject3 = element.eContainer()) instanceof TypedSubApp) {
                    TypedSubApp tsa = (TypedSubApp)eObject3;
                    subAppNames.add(tsa.getName());
                    return OpenTypeHandler.getMatchingSubAppFromType((List<String>)subAppNames.reversed(), tsa.getType());
                }
                element = element.eContainer();
            }
        }
        if ((eObject = fbn.eContainer()) instanceof TypedSubApp) {
            TypedSubApp tsa = (TypedSubApp)eObject;
            return tsa.getType().getFBNetwork();
        }
        EObject eObject4 = fbn.eContainer();
        if (eObject4 instanceof CFBInstance) {
            CFBInstance cfb = (CFBInstance)eObject4;
            return cfb.getType().getFBNetwork();
        }
        return null;
    }

    private static SubApp getMatchingSubAppFromType(List<String> subAppNames, SubAppType type) {
        FBNetwork fb = type.getFBNetwork();
        SubApp lastSubapp = null;
        for (String subAppName : subAppNames) {
            SubApp sa = fb.getSubAppNamed(subAppName);
            if (sa == null) continue;
            lastSubapp = sa;
            fb = sa.getSubAppNetwork();
        }
        return lastSubapp;
    }
}

