/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor;

import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorPicker
extends CLabel {
    private Color selectedColor;

    public ColorPicker(Composite parent, Color originalColor) {
        super(parent, 8);
        if (originalColor == null) {
            throw new IllegalArgumentException("null");
        }
        this.selectedColor = originalColor;
        this.setBackground(this.selectedColor);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorDialog dialog = new ColorDialog(new Shell(Display.getDefault(), 1264));
                dialog.setRGB(ColorPicker.this.selectedColor.getRGB());
                RGB selected = dialog.open();
                if (selected != null) {
                    ColorPicker.this.update(selected);
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(GUIHelper.convertHorizontalPixelToDpi(70), GUIHelper.convertVerticalDpiToPixel(20));
    }

    private void update(RGB selected) {
        this.selectedColor = GUIHelper.getColor(selected);
        this.setBackground(this.selectedColor);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(backgroundColor.getRGB());
    }
}

