/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;

public class ColumnGroupEntry {
    private String label;
    private Integer firstElementPosition;
    private Integer firstElementIndex;
    private boolean collapsed;
    private GroupModel.Group group;

    public ColumnGroupEntry(String label, Integer firstElementPosition, Integer firstElementIndex, boolean collapsed) {
        this.label = label;
        this.firstElementPosition = firstElementPosition;
        this.firstElementIndex = firstElementIndex;
        this.collapsed = collapsed;
    }

    public ColumnGroupEntry(GroupModel.Group group) {
        this.group = group;
    }

    public String getLabel() {
        if (this.group != null) {
            return this.group.getName();
        }
        return this.label;
    }

    public Integer getFirstElementPosition() {
        if (this.group != null) {
            return this.group.getVisibleStartPosition();
        }
        return this.firstElementPosition;
    }

    public Integer getFirstElementIndex() {
        if (this.group != null) {
            return this.group.getVisibleStartIndex();
        }
        return this.firstElementIndex;
    }

    public boolean isCollapsed() {
        if (this.group != null) {
            return this.group.isCollapsed();
        }
        return this.collapsed;
    }

    public GroupModel.Group getGroup() {
        return this.group;
    }

    public static List<Integer> getColumnGroupEntryPositions(List<ColumnGroupEntry> columnEntries) {
        ArrayList<Integer> columnGroupEntryPositions = new ArrayList<Integer>();
        for (ColumnGroupEntry columnGroupEntry : columnEntries) {
            columnGroupEntryPositions.add(columnGroupEntry.getFirstElementPosition());
        }
        return columnGroupEntryPositions;
    }

    public String toString() {
        return "ColumnGroupEntry (Label: " + this.getLabel() + ", firstElementPosition: " + String.valueOf(this.getFirstElementPosition()) + ", firstElementIndex: " + String.valueOf(this.getFirstElementIndex()) + ", collapsed: " + this.isCollapsed() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnGroupEntry other = (ColumnGroupEntry)obj;
        if (this.group == null) {
            if (this.firstElementIndex == null ? other.firstElementIndex != null : !this.firstElementIndex.equals(other.firstElementIndex)) {
                return false;
            }
            if (this.firstElementPosition == null ? other.firstElementPosition != null : !this.firstElementPosition.equals(other.firstElementPosition)) {
                return false;
            }
            if (this.collapsed != other.collapsed) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }
        return this.group.equals(other.group);
    }

    public int hashCode() {
        if (this.group == null) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.firstElementIndex == null ? 0 : this.firstElementIndex.hashCode());
            result = 31 * result + (this.firstElementPosition == null ? 0 : this.firstElementPosition.hashCode());
            result = 31 * result + (this.collapsed ? 1231 : 1237);
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }
        return this.group.hashCode();
    }
}

