/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.issuereport;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.fordiac.ide.issuereport.PreferenceConstants;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class GitIssueCreator {
    private static final String FORDIAC_IDE_ISSUE_URL = "https://github.com/eclipse-4diac/4diac-ide/issues/new?title=%s&body=%s";
    private static final String[] LABELS = new String[]{"bug", "autoreport"};
    private static final String SESSION_ID = UUID.randomUUID().toString();
    private static final String CODE_DELIMITER = "```";
    private static final int MAX_MANUAL_ISSUE_BODY_SIZE = 4000;

    public static Optional<String> createIssue(IStatus status) {
        IssueInfo info = new IssueInfo(status.getMessage(), GitIssueCreator.buildBody(status), LABELS);
        return switch (PreferenceConstants.getReportDestination()) {
            case PreferenceConstants.ReportDestination.GITLAB -> GitIssueCreator.createGitLabIssue(info);
            case PreferenceConstants.ReportDestination.GITHUB -> GitIssueCreator.createGitHubIssue(info);
            case PreferenceConstants.ReportDestination.GITHUB_MANUAL -> GitIssueCreator.createGitHubIssueManual(info);
            default -> throw new MatchException(null, null);
        };
    }

    public static boolean openLinkInBrowser(String url) {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWebBrowser browser = wb.getBrowserSupport().createBrowser("org.eclipse.fordiac.ide");
            browser.openURL(new URI(url).toURL());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String buildBody(IStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append("**4diac IDE version:** ");
        sb.append(System.getProperty("org.eclipse.fordiac.ide.version"));
        sb.append('.');
        sb.append(System.getProperty("org.eclipse.fordiac.ide.buildid"));
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        sb.append("**Session ID:** ");
        sb.append(SESSION_ID);
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        sb.append("### Stack trace");
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        sb.append(CODE_DELIMITER);
        sb.append(System.lineSeparator());
        sb.append(GitIssueCreator.getStackTrace(status.getException()));
        sb.append(CODE_DELIMITER);
        return sb.toString();
    }

    private static String getStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static Optional<String> createGitHubIssueManual(IssueInfo info) {
        Object body = info.body();
        if (((String)body).length() > 4000) {
            body = ((String)body).substring(0, 4000) + CODE_DELIMITER;
        }
        try {
            String reportingURI = FORDIAC_IDE_ISSUE_URL.formatted(URLEncoder.encode(info.title(), StandardCharsets.UTF_8), URLEncoder.encode((String)body, StandardCharsets.UTF_8));
            GitIssueCreator.openLinkInBrowser(reportingURI);
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
        }
        return Optional.empty();
    }

    private static Optional<String> createGitLabIssue(IssueInfo info) {
        if (info.body().length() > 1048575) {
            return Optional.empty();
        }
        String baseURI = GitIssueCreator.removeLeadingTrailingSlashes(PreferenceConstants.getReportGitLabURL());
        String projectPath = GitIssueCreator.removeLeadingTrailingSlashes(PreferenceConstants.getReportGitLabProjectPath());
        String accessToken = PreferenceConstants.getReportGitLabToken();
        String labels = String.join((CharSequence)",", info.labels());
        String uri = "%s/api/v4/projects/%s/issues?title=%s&description=%s&labels=%s";
        String reportingURI = "%s/api/v4/projects/%s/issues?title=%s&description=%s&labels=%s".formatted(baseURI, URLEncoder.encode(projectPath, StandardCharsets.UTF_8), URLEncoder.encode(info.title(), StandardCharsets.UTF_8), URLEncoder.encode(info.body(), StandardCharsets.UTF_8), URLEncoder.encode(labels, StandardCharsets.UTF_8));
        Gson gson = new Gson();
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(reportingURI)).header("PRIVATE-TOKEN", accessToken).POST(HttpRequest.BodyPublishers.noBody()).build();
            Optional<String> body = GitIssueCreator.makeRequest(request);
            return Optional.ofNullable(((GitLabResponse)gson.fromJson(body.get(), GitLabResponse.class)).web_url());
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return Optional.empty();
        }
    }

    private static Optional<String> createGitHubIssue(IssueInfo info) {
        String baseURI = GitIssueCreator.removeLeadingTrailingSlashes(PreferenceConstants.getReportGitHubURL());
        String projectPath = GitIssueCreator.removeLeadingTrailingSlashes(PreferenceConstants.getReportGitHubProjectPath());
        String token = PreferenceConstants.getReportGitHubToken();
        Gson gson = new Gson();
        String jsonBody = gson.toJson((Object)info);
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("%s/repos/%s/issues".formatted(baseURI, projectPath))).header("Accept", "application/vnd.github+json").header("Authorization", "Bearer " + token).header("X-GitHub-Api-Version", "2022-11-28").POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
            Optional<String> body = GitIssueCreator.makeRequest(request);
            return Optional.ofNullable(((GitHubResponse)gson.fromJson(body.get(), GitHubResponse.class)).html_url());
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return Optional.empty();
        }
    }

    private static Optional<String> makeRequest(HttpRequest request) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 201) {
                    return Optional.of(response.body());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
            Thread.currentThread().interrupt();
        }
        return Optional.empty();
    }

    private static String removeLeadingTrailingSlashes(String s) {
        return s.replaceAll("^/+|/+$", "");
    }

    private record GitHubResponse(String html_url) {
    }

    private record GitLabResponse(String web_url) {
    }

    private record IssueInfo(String title, String body, String[] labels) {
    }
}

