/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.LineAndColumn;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class IssueListValidationMesageAcceptor
implements ValidationMessageAcceptor {
    private final List<Issue> issues = new ArrayList<Issue>();

    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.addIssue(Severity.ERROR, message, object, feature, index, code, issueData);
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.addIssue(Severity.WARNING, message, object, feature, index, code, issueData);
    }

    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.addIssue(Severity.INFO, message, object, feature, index, code, issueData);
    }

    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.addIssue(Severity.ERROR, message, object, offset, length, code, issueData);
    }

    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.addIssue(Severity.WARNING, message, object, offset, length, code, issueData);
    }

    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.addIssue(Severity.INFO, message, object, offset, length, code, issueData);
    }

    protected void addIssue(Severity severity, String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setSeverity(severity);
        issue.setMessage(message);
        if (object != null) {
            issue.setUriToProblem(EcoreUtil.getURI((EObject)object));
        }
        issue.setCode(code);
        issue.setData(issueData);
        issue.setType(CheckType.FAST);
        IssueListValidationMesageAcceptor.addLocation(issue, object, feature, index);
        this.issues.add((Issue)issue);
    }

    protected void addIssue(Severity severity, String message, EObject object, int offset, int length, String code, String ... issueData) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setSeverity(severity);
        issue.setMessage(message);
        if (object != null) {
            issue.setUriToProblem(EcoreUtil.getURI((EObject)object));
        }
        issue.setCode(code);
        issue.setData(issueData);
        issue.setType(CheckType.FAST);
        IssueListValidationMesageAcceptor.addLocation(issue, object, offset, length);
        this.issues.add((Issue)issue);
    }

    protected static void addLocation(Issue.IssueImpl issue, EObject object, EStructuralFeature feature, int index) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        if (node != null) {
            if (feature != null) {
                List featureNodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
                if (index < 0 && !featureNodes.isEmpty()) {
                    node = (INode)featureNodes.get(0);
                } else if (index < featureNodes.size()) {
                    node = (INode)featureNodes.get(index);
                }
            }
            IssueListValidationMesageAcceptor.addLocation(issue, (INode)node);
        } else if (object != null && object.eContainer() != null) {
            EObject container = object.eContainer();
            EStructuralFeature containingFeature = object.eContainingFeature();
            if (containingFeature.isMany()) {
                IssueListValidationMesageAcceptor.addLocation(issue, container, containingFeature, ((EList)container.eGet(containingFeature)).indexOf((Object)object));
            } else {
                IssueListValidationMesageAcceptor.addLocation(issue, container, containingFeature, -1);
            }
        }
    }

    protected static void addLocation(Issue.IssueImpl issue, EObject object, int offset, int length) {
        issue.setOffset(Integer.valueOf(offset));
        issue.setLength(Integer.valueOf(length));
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        if (node != null) {
            IssueListValidationMesageAcceptor.addLineAndColumn(issue, (INode)node, offset, length);
        }
    }

    protected static void addLocation(Issue.IssueImpl issue, INode node) {
        issue.setOffset(Integer.valueOf(node.getOffset()));
        issue.setLength(Integer.valueOf(node.getLength()));
        IssueListValidationMesageAcceptor.addLineAndColumn(issue, node, node.getOffset(), node.getLength());
    }

    protected static void addLineAndColumn(Issue.IssueImpl issue, INode node, int offset, int length) {
        LineAndColumn startLineAndColumn = NodeModelUtils.getLineAndColumn((INode)node, (int)offset);
        issue.setLineNumber(Integer.valueOf(startLineAndColumn.getLine()));
        issue.setColumn(Integer.valueOf(startLineAndColumn.getColumn()));
        LineAndColumn endLineAndColumn = NodeModelUtils.getLineAndColumn((INode)node, (int)(offset + length));
        issue.setLineNumberEnd(Integer.valueOf(endLineAndColumn.getLine()));
        issue.setColumnEnd(Integer.valueOf(endLineAndColumn.getColumn()));
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public boolean isEmpty() {
        return this.issues.isEmpty();
    }
}

