/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class DateValue
implements AnyDateValue {
    public static final DateValue DEFAULT = new DateValue(0L);
    private final long value;

    private DateValue(long value) {
        this.value = value;
    }

    public static DateValue toDateValue(long value) {
        return new DateValue(value);
    }

    public static DateValue toDateValue(Number value) {
        return new DateValue(value.longValue());
    }

    public static DateValue toDateValue(LocalDate value) {
        return new DateValue(value.toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC) * 1000000000L);
    }

    public static DateValue toDateValue(String value) {
        return DateValue.toDateValue((LocalDate)TypedValueConverter.INSTANCE_DATE.toValue(value));
    }

    public static DateValue toDateValue(AnyDateValue value) {
        return DateValue.toDateValue(value.toNanos());
    }

    public DateType getType() {
        return IecTypes.ElementaryTypes.DATE;
    }

    @Override
    public long toNanos() {
        return this.value;
    }

    public LocalDate toLocalDate() {
        return LocalDateTime.ofEpochSecond(this.value / 1000000000L, (int)(this.value % 1000000000L), ZoneOffset.UTC).toLocalDate();
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateValue other = (DateValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_DATE.toString((Object)this.toLocalDate());
    }
}

