/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/print.h>

        #include <wx/cmndata.h>
        #include <wx/print.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxPrintout : public  ::wxPrintout
{
public:
    sipwxPrintout(const  ::wxString&);
    virtual ~sipwxPrintout();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool OnPrintPage(int) SIP_OVERRIDE;
    void OnPreparePrinting() SIP_OVERRIDE;
    void OnEndPrinting() SIP_OVERRIDE;
    void OnEndDocument() SIP_OVERRIDE;
    void OnBeginPrinting() SIP_OVERRIDE;
    bool OnBeginDocument(int,int) SIP_OVERRIDE;
    bool IsPreview() const SIP_OVERRIDE;
    bool HasPage(int) SIP_OVERRIDE;
     ::wxString GetTitle() const SIP_OVERRIDE;
    void GetPageInfo(int*,int*,int*,int*) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxPrintout(const sipwxPrintout &);
    sipwxPrintout &operator = (const sipwxPrintout &);

    char sipPyMethods[10];
};

sipwxPrintout::sipwxPrintout(const  ::wxString& title):  ::wxPrintout(title), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxPrintout::~sipwxPrintout()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxPrintout::OnPrintPage(int pageNum)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,sipName_Printout,sipName_OnPrintPage);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_143(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_143(sipGILState, 0, sipPySelf, sipMeth, pageNum);
}

void sipwxPrintout::OnPreparePrinting()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,SIP_NULLPTR,sipName_OnPreparePrinting);

    if (!sipMeth)
    {
         ::wxPrintout::OnPreparePrinting();
        return;
    }

    extern void sipVH__core_53(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_53(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPrintout::OnEndPrinting()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,SIP_NULLPTR,sipName_OnEndPrinting);

    if (!sipMeth)
    {
         ::wxPrintout::OnEndPrinting();
        return;
    }

    extern void sipVH__core_53(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_53(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPrintout::OnEndDocument()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,SIP_NULLPTR,sipName_OnEndDocument);

    if (!sipMeth)
    {
         ::wxPrintout::OnEndDocument();
        return;
    }

    extern void sipVH__core_53(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_53(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPrintout::OnBeginPrinting()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[4],sipPySelf,SIP_NULLPTR,sipName_OnBeginPrinting);

    if (!sipMeth)
    {
         ::wxPrintout::OnBeginPrinting();
        return;
    }

    extern void sipVH__core_53(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_53(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPrintout::OnBeginDocument(int startPage,int endPage)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,SIP_NULLPTR,sipName_OnBeginDocument);

    if (!sipMeth)
        return  ::wxPrintout::OnBeginDocument(startPage,endPage);

    extern bool sipVH__core_85(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxCoord, ::wxCoord);

    return sipVH__core_85(sipGILState, 0, sipPySelf, sipMeth, startPage, endPage);
}

bool sipwxPrintout::IsPreview() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[6]),sipPySelf,SIP_NULLPTR,sipName_IsPreview);

    if (!sipMeth)
        return  ::wxPrintout::IsPreview();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPrintout::HasPage(int pageNum)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,SIP_NULLPTR,sipName_HasPage);

    if (!sipMeth)
        return  ::wxPrintout::HasPage(pageNum);

    extern bool sipVH__core_143(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_143(sipGILState, 0, sipPySelf, sipMeth, pageNum);
}

 ::wxString sipwxPrintout::GetTitle() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[8]),sipPySelf,SIP_NULLPTR,sipName_GetTitle);

    if (!sipMeth)
        return  ::wxPrintout::GetTitle();

    extern  ::wxString sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPrintout::GetPageInfo(int*minPage,int*maxPage,int*pageFrom,int*pageTo)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[9],sipPySelf,SIP_NULLPTR,sipName_GetPageInfo);

    if (!sipMeth)
    {
         ::wxPrintout::GetPageInfo(minPage,maxPage,pageFrom,pageTo);
        return;
    }

    extern void sipVH__core_219(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int*,int*,int*,int*);

    sipVH__core_219(sipGILState, 0, sipPySelf, sipMeth, minPage, maxPage, pageFrom, pageTo);
}


PyDoc_STRVAR(doc_wxPrintout_FitThisSizeToPage, "FitThisSizeToPage(imageSize)\n"
"\n"
"Set the user scale and device origin of the wxDC associated with this\n"
"wxPrintout so that the given image size fits entirely within the page\n"
"rectangle and the origin is at the top left corner of the page\n"
"rectangle.");

extern "C" {static PyObject *meth_wxPrintout_FitThisSizeToPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_FitThisSizeToPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* imageSize;
        int imageSizeState = 0;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_imageSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPrintout, &sipCpp, sipType_wxSize, &imageSize, &imageSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FitThisSizeToPage(*imageSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(imageSize),sipType_wxSize,imageSizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_FitThisSizeToPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_FitThisSizeToPageMargins, "FitThisSizeToPageMargins(imageSize, pageSetupData)\n"
"\n"
"Set the user scale and device origin of the wxDC associated with this\n"
"wxPrintout so that the given image size fits entirely within the page\n"
"margins set in the given wxPageSetupDialogData object.");

extern "C" {static PyObject *meth_wxPrintout_FitThisSizeToPageMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_FitThisSizeToPageMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* imageSize;
        int imageSizeState = 0;
        const  ::wxPageSetupDialogData* pageSetupData;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_imageSize,
            sipName_pageSetupData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9", &sipSelf, sipType_wxPrintout, &sipCpp, sipType_wxSize, &imageSize, &imageSizeState, sipType_wxPageSetupDialogData, &pageSetupData))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FitThisSizeToPageMargins(*imageSize,*pageSetupData);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(imageSize),sipType_wxSize,imageSizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_FitThisSizeToPageMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_FitThisSizeToPaper, "FitThisSizeToPaper(imageSize)\n"
"\n"
"Set the user scale and device origin of the wxDC associated with this\n"
"wxPrintout so that the given image size fits entirely within the paper\n"
"and the origin is at the top left corner of the paper.");

extern "C" {static PyObject *meth_wxPrintout_FitThisSizeToPaper(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_FitThisSizeToPaper(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* imageSize;
        int imageSizeState = 0;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_imageSize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPrintout, &sipCpp, sipType_wxSize, &imageSize, &imageSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FitThisSizeToPaper(*imageSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(imageSize),sipType_wxSize,imageSizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_FitThisSizeToPaper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetDC, "GetDC() -> DC\n"
"\n"
"Returns the device context associated with the printout (given to the\n"
"printout at start of printing or previewing).");

extern "C" {static PyObject *meth_wxPrintout_GetDC(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetDC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
             ::wxDC*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDC();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDC,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetDC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetLogicalPageMarginsRect, "GetLogicalPageMarginsRect(pageSetupData) -> Rect\n"
"\n"
"Return the rectangle corresponding to the page margins specified by\n"
"the given wxPageSetupDialogData object in the associated wxDC's\n"
"logical coordinates for the current user scale and device origin.");

extern "C" {static PyObject *meth_wxPrintout_GetLogicalPageMarginsRect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetLogicalPageMarginsRect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPageSetupDialogData* pageSetupData;
        const  ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pageSetupData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPrintout, &sipCpp, sipType_wxPageSetupDialogData, &pageSetupData))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetLogicalPageMarginsRect(*pageSetupData));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetLogicalPageMarginsRect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetLogicalPageRect, "GetLogicalPageRect() -> Rect\n"
"\n"
"Return the rectangle corresponding to the page in the associated wxDC\n"
"'s logical coordinates for the current user scale and device origin.");

extern "C" {static PyObject *meth_wxPrintout_GetLogicalPageRect(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetLogicalPageRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetLogicalPageRect());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetLogicalPageRect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetLogicalPaperRect, "GetLogicalPaperRect() -> Rect\n"
"\n"
"Return the rectangle corresponding to the paper in the associated wxDC\n"
"'s logical coordinates for the current user scale and device origin.");

extern "C" {static PyObject *meth_wxPrintout_GetLogicalPaperRect(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetLogicalPaperRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetLogicalPaperRect());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetLogicalPaperRect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPPIPrinter, "GetPPIPrinter() -> (w, h)\n"
"\n"
"Returns the number of pixels per logical inch of the printer device\n"
"context.");

extern "C" {static PyObject *meth_wxPrintout_GetPPIPrinter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPPIPrinter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int w;
        int h;
        const  ::wxPrintout *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetPPIPrinter(&w,&h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ii)",w,h);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPPIPrinter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPPIScreen, "GetPPIScreen() -> (w, h)\n"
"\n"
"Returns the number of pixels per logical inch of the screen device\n"
"context.");

extern "C" {static PyObject *meth_wxPrintout_GetPPIScreen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPPIScreen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int w;
        int h;
        const  ::wxPrintout *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetPPIScreen(&w,&h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ii)",w,h);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPPIScreen, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPageInfo, "GetPageInfo() -> (minPage, maxPage, pageFrom, pageTo)\n"
"\n"
"Called by the framework to obtain information from the application\n"
"about minimum and maximum page values that the user can select, and\n"
"the required page range to be printed.");

extern "C" {static PyObject *meth_wxPrintout_GetPageInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPageInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int minPage;
        int maxPage;
        int pageFrom;
        int pageTo;
         ::wxPrintout *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPrintout::GetPageInfo(&minPage,&maxPage,&pageFrom,&pageTo) : sipCpp->GetPageInfo(&minPage,&maxPage,&pageFrom,&pageTo));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(iiii)",minPage,maxPage,pageFrom,pageTo);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPageInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPageSizeMM, "GetPageSizeMM() -> (w, h)\n"
"\n"
"Returns the size of the printer page in millimetres.");

extern "C" {static PyObject *meth_wxPrintout_GetPageSizeMM(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPageSizeMM(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int w;
        int h;
        const  ::wxPrintout *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetPageSizeMM(&w,&h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ii)",w,h);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPageSizeMM, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPageSizePixels, "GetPageSizePixels() -> (w, h)\n"
"\n"
"Returns the size of the printer page in pixels, called the page\n"
"rectangle.");

extern "C" {static PyObject *meth_wxPrintout_GetPageSizePixels(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPageSizePixels(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int w;
        int h;
        const  ::wxPrintout *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetPageSizePixels(&w,&h);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(ii)",w,h);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPageSizePixels, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPaperRectPixels, "GetPaperRectPixels() -> Rect\n"
"\n"
"Returns the rectangle that corresponds to the entire paper in pixels,\n"
"called the paper rectangle.");

extern "C" {static PyObject *meth_wxPrintout_GetPaperRectPixels(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPaperRectPixels(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetPaperRectPixels());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPaperRectPixels, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetTitle, "GetTitle() -> String\n"
"\n"
"Returns the title of the printout.");

extern "C" {static PyObject *meth_wxPrintout_GetTitle(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetTitle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString((sipSelfWasArg ? sipCpp-> ::wxPrintout::GetTitle() : sipCpp->GetTitle()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetTitle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_HasPage, "HasPage(pageNum) -> bool\n"
"\n"
"Should be overridden to return true if the document has this page, or\n"
"false if not.");

extern "C" {static PyObject *meth_wxPrintout_HasPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_HasPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int pageNum;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pageNum,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPrintout, &sipCpp, &pageNum))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPrintout::HasPage(pageNum) : sipCpp->HasPage(pageNum));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_HasPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_IsPreview, "IsPreview() -> bool\n"
"\n"
"Returns true if the printout is currently being used for previewing.");

extern "C" {static PyObject *meth_wxPrintout_IsPreview(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_IsPreview(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPrintout::IsPreview() : sipCpp->IsPreview());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_IsPreview, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_GetPreview, "GetPreview() -> PrintPreview\n"
"\n"
"Returns the associated preview object if any.");

extern "C" {static PyObject *meth_wxPrintout_GetPreview(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_GetPreview(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
             ::wxPrintPreview*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPreview();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPrintPreview,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_GetPreview, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_MapScreenSizeToDevice, "MapScreenSizeToDevice()\n"
"\n"
"Set the user scale and device origin of the wxDC associated with this\n"
"wxPrintout so that one screen pixel maps to one device pixel on the\n"
"DC.");

extern "C" {static PyObject *meth_wxPrintout_MapScreenSizeToDevice(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_MapScreenSizeToDevice(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MapScreenSizeToDevice();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_MapScreenSizeToDevice, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_MapScreenSizeToPage, "MapScreenSizeToPage()\n"
"\n"
"This sets the user scale of the wxDC associated with this wxPrintout\n"
"to the same scale as MapScreenSizeToPaper() but sets the logical\n"
"origin to the top left corner of the page rectangle.");

extern "C" {static PyObject *meth_wxPrintout_MapScreenSizeToPage(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_MapScreenSizeToPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MapScreenSizeToPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_MapScreenSizeToPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_MapScreenSizeToPageMargins, "MapScreenSizeToPageMargins(pageSetupData)\n"
"\n"
"This sets the user scale of the wxDC associated with this wxPrintout\n"
"to the same scale as MapScreenSizeToPageMargins() but sets the logical\n"
"origin to the top left corner of the page margins specified by the\n"
"given wxPageSetupDialogData object.");

extern "C" {static PyObject *meth_wxPrintout_MapScreenSizeToPageMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_MapScreenSizeToPageMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPageSetupDialogData* pageSetupData;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pageSetupData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPrintout, &sipCpp, sipType_wxPageSetupDialogData, &pageSetupData))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MapScreenSizeToPageMargins(*pageSetupData);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_MapScreenSizeToPageMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_MapScreenSizeToPaper, "MapScreenSizeToPaper()\n"
"\n"
"Set the user scale and device origin of the wxDC associated with this\n"
"wxPrintout so that the printed page matches the screen size as closely\n"
"as possible and the logical origin is in the top left corner of the\n"
"paper rectangle.");

extern "C" {static PyObject *meth_wxPrintout_MapScreenSizeToPaper(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_MapScreenSizeToPaper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MapScreenSizeToPaper();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_MapScreenSizeToPaper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OffsetLogicalOrigin, "OffsetLogicalOrigin(xoff, yoff)\n"
"\n"
"Shift the device origin by an amount specified in logical coordinates.");

extern "C" {static PyObject *meth_wxPrintout_OffsetLogicalOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OffsetLogicalOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCoord xoff;
         ::wxCoord yoff;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xoff,
            sipName_yoff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPrintout, &sipCpp, &xoff, &yoff))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->OffsetLogicalOrigin(xoff,yoff);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OffsetLogicalOrigin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OnBeginDocument, "OnBeginDocument(startPage, endPage) -> bool\n"
"\n"
"Called by the framework at the start of document printing.");

extern "C" {static PyObject *meth_wxPrintout_OnBeginDocument(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OnBeginDocument(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int startPage;
        int endPage;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_startPage,
            sipName_endPage,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPrintout, &sipCpp, &startPage, &endPage))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPrintout::OnBeginDocument(startPage,endPage) : sipCpp->OnBeginDocument(startPage,endPage));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OnBeginDocument, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OnBeginPrinting, "OnBeginPrinting()\n"
"\n"
"Called by the framework at the start of printing.");

extern "C" {static PyObject *meth_wxPrintout_OnBeginPrinting(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OnBeginPrinting(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPrintout::OnBeginPrinting() : sipCpp->OnBeginPrinting());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OnBeginPrinting, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OnEndDocument, "OnEndDocument()\n"
"\n"
"Called by the framework at the end of document printing.");

extern "C" {static PyObject *meth_wxPrintout_OnEndDocument(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OnEndDocument(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPrintout::OnEndDocument() : sipCpp->OnEndDocument());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OnEndDocument, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OnEndPrinting, "OnEndPrinting()\n"
"\n"
"Called by the framework at the end of printing.");

extern "C" {static PyObject *meth_wxPrintout_OnEndPrinting(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OnEndPrinting(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPrintout::OnEndPrinting() : sipCpp->OnEndPrinting());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OnEndPrinting, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OnPreparePrinting, "OnPreparePrinting()\n"
"\n"
"Called once by the framework before any other demands are made of the\n"
"wxPrintout object.");

extern "C" {static PyObject *meth_wxPrintout_OnPreparePrinting(PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OnPreparePrinting(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPrintout::OnPreparePrinting() : sipCpp->OnPreparePrinting());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OnPreparePrinting, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_OnPrintPage, "OnPrintPage(pageNum) -> bool\n"
"\n"
"Called by the framework when a page should be printed.");

extern "C" {static PyObject *meth_wxPrintout_OnPrintPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_OnPrintPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        int pageNum;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pageNum,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPrintout, &sipCpp, &pageNum))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_Printout, sipName_OnPrintPage);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->OnPrintPage(pageNum);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_OnPrintPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPrintout_SetLogicalOrigin, "SetLogicalOrigin(x, y)\n"
"\n"
"Set the device origin of the associated wxDC so that the current\n"
"logical point becomes the new logical origin.");

extern "C" {static PyObject *meth_wxPrintout_SetLogicalOrigin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPrintout_SetLogicalOrigin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxCoord x;
         ::wxCoord y;
         ::wxPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPrintout, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalOrigin(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Printout, sipName_SetLogicalOrigin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPrintout(void *, const sipTypeDef *);}
static void *cast_wxPrintout(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxPrintout *sipCpp = reinterpret_cast< ::wxPrintout *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPrintout(void *, int);}
static void release_wxPrintout(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxPrintout *>(sipCppV);
    else
        delete reinterpret_cast< ::wxPrintout *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxPrintout(sipSimpleWrapper *);}
static void dealloc_wxPrintout(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxPrintout *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPrintout(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxPrintout(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPrintout(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxPrintout *sipCpp = SIP_NULLPTR;

    {
        const  ::wxString& titledef = "Printout";
        const  ::wxString* title = &titledef;
        int titleState = 0;

        static const char *sipKwdList[] = {
            sipName_title,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1", sipType_wxString,&title, &titleState))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxPrintout(*title);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(title),sipType_wxString,titleState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPrintout[] = {{371, 255, 1}};


static PyMethodDef methods_wxPrintout[] = {
    {SIP_MLNAME_CAST(sipName_FitThisSizeToPage), SIP_MLMETH_CAST(meth_wxPrintout_FitThisSizeToPage), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_FitThisSizeToPage)},
    {SIP_MLNAME_CAST(sipName_FitThisSizeToPageMargins), SIP_MLMETH_CAST(meth_wxPrintout_FitThisSizeToPageMargins), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_FitThisSizeToPageMargins)},
    {SIP_MLNAME_CAST(sipName_FitThisSizeToPaper), SIP_MLMETH_CAST(meth_wxPrintout_FitThisSizeToPaper), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_FitThisSizeToPaper)},
    {SIP_MLNAME_CAST(sipName_GetDC), meth_wxPrintout_GetDC, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_GetDC)},
    {SIP_MLNAME_CAST(sipName_GetLogicalPageMarginsRect), SIP_MLMETH_CAST(meth_wxPrintout_GetLogicalPageMarginsRect), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_GetLogicalPageMarginsRect)},
    {SIP_MLNAME_CAST(sipName_GetLogicalPageRect), meth_wxPrintout_GetLogicalPageRect, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_GetLogicalPageRect)},
    {SIP_MLNAME_CAST(sipName_GetLogicalPaperRect), meth_wxPrintout_GetLogicalPaperRect, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_GetLogicalPaperRect)},
    {SIP_MLNAME_CAST(sipName_GetPPIPrinter), SIP_MLMETH_CAST(meth_wxPrintout_GetPPIPrinter), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_GetPPIPrinter)},
    {SIP_MLNAME_CAST(sipName_GetPPIScreen), SIP_MLMETH_CAST(meth_wxPrintout_GetPPIScreen), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_GetPPIScreen)},
    {SIP_MLNAME_CAST(sipName_GetPageInfo), SIP_MLMETH_CAST(meth_wxPrintout_GetPageInfo), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_GetPageInfo)},
    {SIP_MLNAME_CAST(sipName_GetPageSizeMM), SIP_MLMETH_CAST(meth_wxPrintout_GetPageSizeMM), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_GetPageSizeMM)},
    {SIP_MLNAME_CAST(sipName_GetPageSizePixels), SIP_MLMETH_CAST(meth_wxPrintout_GetPageSizePixels), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_GetPageSizePixels)},
    {SIP_MLNAME_CAST(sipName_GetPaperRectPixels), meth_wxPrintout_GetPaperRectPixels, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_GetPaperRectPixels)},
    {SIP_MLNAME_CAST(sipName_GetPreview), meth_wxPrintout_GetPreview, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_GetPreview)},
    {SIP_MLNAME_CAST(sipName_GetTitle), meth_wxPrintout_GetTitle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_GetTitle)},
    {SIP_MLNAME_CAST(sipName_HasPage), SIP_MLMETH_CAST(meth_wxPrintout_HasPage), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_HasPage)},
    {SIP_MLNAME_CAST(sipName_IsPreview), meth_wxPrintout_IsPreview, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_IsPreview)},
    {SIP_MLNAME_CAST(sipName_MapScreenSizeToDevice), meth_wxPrintout_MapScreenSizeToDevice, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_MapScreenSizeToDevice)},
    {SIP_MLNAME_CAST(sipName_MapScreenSizeToPage), meth_wxPrintout_MapScreenSizeToPage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_MapScreenSizeToPage)},
    {SIP_MLNAME_CAST(sipName_MapScreenSizeToPageMargins), SIP_MLMETH_CAST(meth_wxPrintout_MapScreenSizeToPageMargins), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_MapScreenSizeToPageMargins)},
    {SIP_MLNAME_CAST(sipName_MapScreenSizeToPaper), meth_wxPrintout_MapScreenSizeToPaper, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_MapScreenSizeToPaper)},
    {SIP_MLNAME_CAST(sipName_OffsetLogicalOrigin), SIP_MLMETH_CAST(meth_wxPrintout_OffsetLogicalOrigin), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_OffsetLogicalOrigin)},
    {SIP_MLNAME_CAST(sipName_OnBeginDocument), SIP_MLMETH_CAST(meth_wxPrintout_OnBeginDocument), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_OnBeginDocument)},
    {SIP_MLNAME_CAST(sipName_OnBeginPrinting), meth_wxPrintout_OnBeginPrinting, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_OnBeginPrinting)},
    {SIP_MLNAME_CAST(sipName_OnEndDocument), meth_wxPrintout_OnEndDocument, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_OnEndDocument)},
    {SIP_MLNAME_CAST(sipName_OnEndPrinting), meth_wxPrintout_OnEndPrinting, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_OnEndPrinting)},
    {SIP_MLNAME_CAST(sipName_OnPreparePrinting), meth_wxPrintout_OnPreparePrinting, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPrintout_OnPreparePrinting)},
    {SIP_MLNAME_CAST(sipName_OnPrintPage), SIP_MLMETH_CAST(meth_wxPrintout_OnPrintPage), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_OnPrintPage)},
    {SIP_MLNAME_CAST(sipName_SetLogicalOrigin), SIP_MLMETH_CAST(meth_wxPrintout_SetLogicalOrigin), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPrintout_SetLogicalOrigin)}
};

sipVariableDef variables_wxPrintout[] = {
    {PropertyVariable, sipName_Title, &methods_wxPrintout[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Preview, &methods_wxPrintout[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PaperRectPixels, &methods_wxPrintout[12], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalPaperRect, &methods_wxPrintout[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalPageRect, &methods_wxPrintout[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DC, &methods_wxPrintout[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPrintout, "Printout(title=\"Printout\")\n"
"\n"
"This class encapsulates the functionality of printing out an\n"
"application document.");


sipClassTypeDef sipTypeDef__core_wxPrintout = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPrintout,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Printout,
        {0, 0, 1},
        29, methods_wxPrintout,
        0, SIP_NULLPTR,
        6, variables_wxPrintout,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPrintout,
    -1,
    -1,
    supers_wxPrintout,
    SIP_NULLPTR,
    init_type_wxPrintout,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxPrintout,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxPrintout,
    cast_wxPrintout,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
