; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc %s -x86-early-ifcvt -pass-remarks='early-ifcvt' -pass-remarks-missed='early-ifcvt' -mcpu=k8 -o - 2>&1 | FileCheck %s
target triple = "x86_64-none-none"

; CHECK: remark: <unknown>:0:0: performing if-conversion on branch:
; CHECK-SAME: the condition adds {{[0-9]+}} cycle{{s?}} to the critical path,
; CHECK-SAME: and the short leg adds another {{[0-9]+}} cycles{{s?}},
; CHECK-SAME: and the long leg adds another {{[0-9]+}} cycles{{s?}},
; CHECK-SAME: each staying under the threshold of {{[0-9]+}} cycles{{s?}}.

; CHECK: remark: <unknown>:0:0: did not if-convert branch:
; CHECK-SAME: the condition would add {{[0-9]+}} cycles{{s?}} to the critical path,
; CHECK-SAME: and the short leg would add another {{[0-9]+}} cycles{{s?}},
; CHECK-SAME: and the long leg would add another {{[0-9]+}} cycles{{s?}} exceeding the limit of {{[0-9]+}} cycles{{s?}}.

; CHECK: remark: <unknown>:0:0: did not if-convert branch:
; CHECK-SAME: the resulting critical path ({{[0-9]+}} cycles{{s?}})
; CHECK-SAME: would extend the shorter leg's critical path ({{[0-9]+}} cycle{{s?}})
; CHECK-SAME: by more than the threshold of {{[0-9]+}} cycles{{s?}},
; CHECK-SAME: which cannot be hidden by available ILP.

define i32 @mm1(i1 %pred, i32 %val) {
; CHECK-LABEL: mm1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $esi killed $esi def $rsi
; CHECK-NEXT:    leal 1(%rsi), %eax
; CHECK-NEXT:    testb $1, %dil
; CHECK-NEXT:    cmovel %esi, %eax
; CHECK-NEXT:    retq
entry:
  br i1 %pred, label %if.true, label %if.else

if.true:
  %v1 = add i32 1, %val
  br label %if.else

if.else:
  %res = phi i32 [ %val, %entry ], [ %v1, %if.true ]
  ret i32 %res
}

define i32 @mm2(i1 %pred, i32 %val, i32 %e1, i32 %e2, i32 %e3, i32 %e4, i32 %e5) {
; CHECK-LABEL: mm2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    testb $1, %dil
; CHECK-NEXT:    je .LBB1_2
; CHECK-NEXT:  # %bb.1: # %if.true
; CHECK-NEXT:    addl %eax, %edx
; CHECK-NEXT:    addl %ecx, %r8d
; CHECK-NEXT:    addl %edx, %r8d
; CHECK-NEXT:    addl %r8d, %r9d
; CHECK-NEXT:    movl %r9d, %eax
; CHECK-NEXT:  .LBB1_2: # %if.else
; CHECK-NEXT:    retq
entry:
  br i1 %pred, label %if.true, label %if.else

if.true:
  %v1 = add i32 %e1, %val
  %v2 = add i32 %e2, %v1
  %v3 = add i32 %e3, %v2
  %v4 = add i32 %e4, %v3
  br label %if.else

if.else:
  %res = phi i32 [ %val, %entry ], [ %v4, %if.true ]
  ret i32 %res
}

define i64 @mm3(i1 %pred, i64 %val, i64 %e1, i128 %e2, i128 %e3, i128 %e4, i128 %e5) {
; CHECK-LABEL: mm3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rax
; CHECK-NEXT:    testb $1, %dil
; CHECK-NEXT:    movq %rsi, %r10
; CHECK-NEXT:    jne .LBB2_2
; CHECK-NEXT:  # %bb.1: # %if.false
; CHECK-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; CHECK-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; CHECK-NEXT:    imulq %rdx, %rdx
; CHECK-NEXT:    movq %rdx, %r10
; CHECK-NEXT:    sarq $63, %r10
; CHECK-NEXT:    movq %rcx, %rax
; CHECK-NEXT:    movq %rdx, %r9
; CHECK-NEXT:    mulq %rdx
; CHECK-NEXT:    imulq %rcx, %r10
; CHECK-NEXT:    imulq %r9, %r8
; CHECK-NEXT:    addq %rdx, %r8
; CHECK-NEXT:    addq %r10, %r8
; CHECK-NEXT:    addq {{[0-9]+}}(%rsp), %rax
; CHECK-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; CHECK-NEXT:    xorq {{[0-9]+}}(%rsp), %rdi
; CHECK-NEXT:    xorq %r8, %rdi
; CHECK-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; CHECK-NEXT:    xorq %rsi, %r10
; CHECK-NEXT:    xorq %rax, %r10
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    movl %esi, %ecx
; CHECK-NEXT:    sarq %cl, %rax
; CHECK-NEXT:    addq %rdi, %rdi
; CHECK-NEXT:    notb %cl
; CHECK-NEXT:    shlq %cl, %rdi
; CHECK-NEXT:    movl %esi, %ecx
; CHECK-NEXT:    shrq %cl, %r10
; CHECK-NEXT:    orq %rdi, %r10
; CHECK-NEXT:    testb $64, %sil
; CHECK-NEXT:    cmovneq %rax, %r10
; CHECK-NEXT:    movq %r9, %rax
; CHECK-NEXT:  .LBB2_2: # %if.endif
; CHECK-NEXT:    addq %r10, %rax
; CHECK-NEXT:    retq
entry:
  br i1 %pred, label %if.true, label %if.false

if.true:
  br label %if.endif

if.false:
  %f1 = mul i64 %e1, %e1
  %f3 = sext i64 %f1 to i128
  %f4 = mul i128 %e2, %f3
  %f6 = add i128 %e3, %f4
  %f7 = xor i128 %e4, %f6
  %f8 = xor i128 %e5, %f7
  %a1 = ashr i128 %f8, %e5
  %f5 = trunc i128 %a1 to i64
  br label %if.endif

if.endif:
  %r1 = phi i64 [ %val, %if.true ], [ %f1, %if.false ]
  %r2 = phi i64 [ %val, %if.true ], [ %f5, %if.false ]
  %res = add i64 %r1, %r2
  ret i64 %res
}
