; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=amdgcn- -mcpu=gfx900 -amdgpu-dpp-combine=false -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-O0 %s
; RUN: llc -mtriple=amdgcn- -mcpu=gfx900 -amdgpu-dpp-combine=false -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-O3 %s

define amdgpu_gfx void @strict_wwm_no_cfg(ptr addrspace(8) inreg %tmp14) {
; GFX9-O0-LABEL: strict_wwm_no_cfg:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s40, s6
; GFX9-O0-NEXT:    s_mov_b32 s34, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr40 killed $sgpr40 def $sgpr40_sgpr41
; GFX9-O0-NEXT:    s_mov_b32 s41, s7
; GFX9-O0-NEXT:    s_mov_b32 s42, s41
; GFX9-O0-NEXT:    s_mov_b32 s43, s40
; GFX9-O0-NEXT:    ; kill: def $sgpr34 killed $sgpr34 def $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b32 s35, s5
; GFX9-O0-NEXT:    s_mov_b32 s44, s35
; GFX9-O0-NEXT:    s_mov_b32 s36, s34
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s44
; GFX9-O0-NEXT:    s_mov_b32 s38, s43
; GFX9-O0-NEXT:    s_mov_b32 s39, s42
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_load_dwordx2 v[5:6], off, s[36:39], s34
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr40_sgpr41
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[40:41]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr40_sgpr41
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s34
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s34
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v2, v0 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v0, v0, v2
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v0, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v0, v1, v0
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[40:41], v3, v4
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s[40:41]
; GFX9-O0-NEXT:    s_mov_b32 s35, 1
; GFX9-O0-NEXT:    v_lshlrev_b32_e64 v3, s35, v3
; GFX9-O0-NEXT:    s_mov_b32 s35, 2
; GFX9-O0-NEXT:    v_and_b32_e64 v3, v3, s35
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_no_cfg:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    buffer_load_dwordx2 v[4:5], off, s[4:7], 0
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v2, 0, v4, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v3, 0, v5, s[34:35]
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_mov_b32_dpp v0, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX9-O3-NEXT:    v_add_u32_e32 v0, v3, v0
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-O3-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX9-O3-NEXT:    v_lshlrev_b32_e32 v4, 1, v4
; GFX9-O3-NEXT:    v_and_b32_e32 v4, 2, v4
; GFX9-O3-NEXT:    buffer_store_dword v4, off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %tmp100 = call <2 x float> @llvm.amdgcn.raw.ptr.buffer.load.v2f32(ptr addrspace(8) %tmp14, i32 0, i32 0, i32 0)
  %tmp101 = bitcast <2 x float> %tmp100 to <2 x i32>
  %tmp102 = extractelement <2 x i32> %tmp101, i32 0
  %tmp103 = extractelement <2 x i32> %tmp101, i32 1
  %tmp105 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp102, i32 0)
  %tmp107 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp103, i32 0)


  %tmp120 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp105, i32 323, i32 12, i32 15, i1 false)
  %tmp121 = add i32 %tmp105, %tmp120
  %tmp122 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp121)

  %tmp135 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp107, i32 323, i32 12, i32 15, i1 false)
  %tmp136 = add i32 %tmp107, %tmp135
  %tmp137 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp136)

  %tmp138 = icmp eq i32 %tmp122, %tmp137
  %tmp139 = sext i1 %tmp138 to i32
  %tmp140 = shl nsw i32 %tmp139, 1
  %tmp141 = and i32 %tmp140, 2
  %tmp145 = bitcast i32 %tmp141 to float
  call void @llvm.amdgcn.raw.ptr.buffer.store.f32(float %tmp145, ptr addrspace(8) %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define amdgpu_gfx void @strict_wwm_cfg(ptr addrspace(8) inreg %tmp14, i32 %arg) {
; GFX9-O0-LABEL: strict_wwm_cfg:
; GFX9-O0:       ; %bb.0: ; %entry
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s40, s6
; GFX9-O0-NEXT:    s_mov_b32 s34, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr40 killed $sgpr40 def $sgpr40_sgpr41
; GFX9-O0-NEXT:    s_mov_b32 s41, s7
; GFX9-O0-NEXT:    s_mov_b32 s42, s41
; GFX9-O0-NEXT:    s_mov_b32 s43, s40
; GFX9-O0-NEXT:    ; kill: def $sgpr34 killed $sgpr34 def $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b32 s35, s5
; GFX9-O0-NEXT:    s_mov_b32 s44, s35
; GFX9-O0-NEXT:    s_mov_b32 s36, s34
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s44
; GFX9-O0-NEXT:    s_mov_b32 s38, s43
; GFX9-O0-NEXT:    s_mov_b32 s39, s42
; GFX9-O0-NEXT:    ; implicit-def: $vgpr5 : SGPR spill to VGPR lane
; GFX9-O0-NEXT:    v_writelane_b32 v5, s40, 0
; GFX9-O0-NEXT:    v_writelane_b32 v5, s41, 1
; GFX9-O0-NEXT:    v_writelane_b32 v5, s34, 2
; GFX9-O0-NEXT:    v_writelane_b32 v5, s35, 3
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    s_nop 2
; GFX9-O0-NEXT:    buffer_load_dwordx2 v[3:4], off, s[36:39], s34
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36_sgpr37
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36_sgpr37
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[36:37], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s34
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[36:37]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s34
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v2, v1 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v1, v2
; GFX9-O0-NEXT:    s_mov_b64 exec, s[36:37]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[36:37], v0, s34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[34:35], exec
; GFX9-O0-NEXT:    v_writelane_b32 v5, s34, 4
; GFX9-O0-NEXT:    v_writelane_b32 v5, s35, 5
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[46:47], -1
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[46:47]
; GFX9-O0-NEXT:    s_and_b64 s[34:35], s[34:35], s[36:37]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB1_2
; GFX9-O0-NEXT:  ; %bb.1: ; %if
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v2, v1, v0, s[34:35]
; GFX9-O0-NEXT:    s_nop 1
; GFX9-O0-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v2, v1
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:  .LBB1_2: ; %merge
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[46:47], -1
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[46:47]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s36, v5, 4
; GFX9-O0-NEXT:    v_readlane_b32 s37, v5, 5
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[36:37]
; GFX9-O0-NEXT:    v_readlane_b32 s38, v5, 0
; GFX9-O0-NEXT:    v_readlane_b32 s39, v5, 1
; GFX9-O0-NEXT:    v_readlane_b32 s34, v5, 2
; GFX9-O0-NEXT:    v_readlane_b32 s35, v5, 3
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[36:37], v0, v3
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[36:37]
; GFX9-O0-NEXT:    s_mov_b32 s36, 1
; GFX9-O0-NEXT:    v_lshlrev_b32_e64 v0, s36, v0
; GFX9-O0-NEXT:    s_mov_b32 s36, 2
; GFX9-O0-NEXT:    v_and_b32_e64 v0, v0, s36
; GFX9-O0-NEXT:    s_mov_b32 s40, s35
; GFX9-O0-NEXT:    s_mov_b32 s36, s34
; GFX9-O0-NEXT:    s_mov_b32 s34, s39
; GFX9-O0-NEXT:    s_mov_b32 s35, s38
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s40
; GFX9-O0-NEXT:    s_mov_b32 s38, s35
; GFX9-O0-NEXT:    s_mov_b32 s39, s34
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_cfg:
; GFX9-O3:       ; %bb.0: ; %entry
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    buffer_load_dwordx2 v[3:4], off, s[4:7], 0
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v2, 0, v3, s[34:35]
; GFX9-O3-NEXT:    s_nop 1
; GFX9-O3-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O3-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-O3-NEXT:    s_and_saveexec_b64 s[34:35], vcc
; GFX9-O3-NEXT:  ; %bb.1: ; %if
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[36:37], -1
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v2, 0, v4, s[36:37]
; GFX9-O3-NEXT:    s_nop 1
; GFX9-O3-NEXT:    v_mov_b32_dpp v1, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v2, v1
; GFX9-O3-NEXT:    s_mov_b64 exec, s[36:37]
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O3-NEXT:  ; %bb.2: ; %merge
; GFX9-O3-NEXT:    s_or_b64 exec, exec, s[34:35]
; GFX9-O3-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-O3-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-O3-NEXT:    v_and_b32_e32 v0, 2, v0
; GFX9-O3-NEXT:    buffer_store_dword v0, off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
entry:
  %tmp100 = call <2 x float> @llvm.amdgcn.raw.ptr.buffer.load.v2f32(ptr addrspace(8) %tmp14, i32 0, i32 0, i32 0)
  %tmp101 = bitcast <2 x float> %tmp100 to <2 x i32>
  %tmp102 = extractelement <2 x i32> %tmp101, i32 0
  %tmp105 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp102, i32 0)

  %tmp120 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp105, i32 323, i32 12, i32 15, i1 false)
  %tmp121 = add i32 %tmp105, %tmp120
  %tmp122 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp121)

  %cond = icmp eq i32 %arg, 0
  br i1 %cond, label %if, label %merge
if:
  %tmp103 = extractelement <2 x i32> %tmp101, i32 1
  %tmp107 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %tmp103, i32 0)

  %tmp135 = tail call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %tmp107, i32 323, i32 12, i32 15, i1 false)
  %tmp136 = add i32 %tmp107, %tmp135
  %tmp137 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp136)
  br label %merge

merge:
  %merge_value = phi i32 [ 0, %entry ], [%tmp137, %if ]
  %tmp138 = icmp eq i32 %tmp122, %merge_value
  %tmp139 = sext i1 %tmp138 to i32
  %tmp140 = shl nsw i32 %tmp139, 1
  %tmp141 = and i32 %tmp140, 2
  %tmp145 = bitcast i32 %tmp141 to float
  call void @llvm.amdgcn.raw.ptr.buffer.store.f32(float %tmp145, ptr addrspace(8) %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define hidden amdgpu_gfx i32 @strict_wwm_called(i32 %a) noinline {
; GFX9-O0-LABEL: strict_wwm_called:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v0, v0
; GFX9-O0-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX9-O0-NEXT:    v_sub_u32_e64 v0, v0, v1
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_called:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v0, v0
; GFX9-O3-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX9-O3-NEXT:    v_sub_u32_e32 v0, v0, v1
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %add = add i32 %a, %a
  %mul = mul i32 %add, %a
  %sub = sub i32 %mul, %add
  ret i32 %sub
}

define amdgpu_gfx void @strict_wwm_call(ptr addrspace(8) inreg %tmp14, i32 inreg %arg) {
; GFX9-O0-LABEL: strict_wwm_call:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_mov_b32 s48, s33
; GFX9-O0-NEXT:    s_mov_b32 s33, s32
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_add_i32 s32, s32, 0x400
; GFX9-O0-NEXT:    v_writelane_b32 v3, s30, 0
; GFX9-O0-NEXT:    v_writelane_b32 v3, s31, 1
; GFX9-O0-NEXT:    s_mov_b32 s40, s6
; GFX9-O0-NEXT:    s_mov_b32 s34, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr40 killed $sgpr40 def $sgpr40_sgpr41
; GFX9-O0-NEXT:    s_mov_b32 s41, s7
; GFX9-O0-NEXT:    s_mov_b32 s42, s41
; GFX9-O0-NEXT:    s_mov_b32 s43, s40
; GFX9-O0-NEXT:    ; kill: def $sgpr34 killed $sgpr34 def $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b32 s35, s5
; GFX9-O0-NEXT:    s_mov_b32 s44, s35
; GFX9-O0-NEXT:    s_mov_b32 s36, s34
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s44
; GFX9-O0-NEXT:    s_mov_b32 s38, s43
; GFX9-O0-NEXT:    s_mov_b32 s39, s42
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr40_sgpr41
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s34
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v2, v1, v0, s[40:41]
; GFX9-O0-NEXT:    s_getpc_b64 s[42:43]
; GFX9-O0-NEXT:    s_add_u32 s42, s42, strict_wwm_called@rel32@lo+4
; GFX9-O0-NEXT:    s_addc_u32 s43, s43, strict_wwm_called@rel32@hi+12
; GFX9-O0-NEXT:    s_mov_b64 s[46:47], s[2:3]
; GFX9-O0-NEXT:    s_mov_b64 s[44:45], s[0:1]
; GFX9-O0-NEXT:    s_mov_b64 s[0:1], s[44:45]
; GFX9-O0-NEXT:    s_mov_b64 s[2:3], s[46:47]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    s_swappc_b64 s[30:31], s[42:43]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_add_u32_e64 v1, v1, v2
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    v_readlane_b32 s31, v3, 1
; GFX9-O0-NEXT:    v_readlane_b32 s30, v3, 0
; GFX9-O0-NEXT:    s_mov_b32 s32, s33
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s33, s48
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_call:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_mov_b32 s38, s33
; GFX9-O3-NEXT:    s_mov_b32 s33, s32
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_writelane_b32 v3, s30, 0
; GFX9-O3-NEXT:    s_addk_i32 s32, 0x400
; GFX9-O3-NEXT:    v_writelane_b32 v3, s31, 1
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[34:35]
; GFX9-O3-NEXT:    s_getpc_b64 s[36:37]
; GFX9-O3-NEXT:    s_add_u32 s36, s36, strict_wwm_called@rel32@lo+4
; GFX9-O3-NEXT:    s_addc_u32 s37, s37, strict_wwm_called@rel32@hi+12
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O3-NEXT:    s_swappc_b64 s[30:31], s[36:37]
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O3-NEXT:    v_add_u32_e32 v1, v1, v2
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O3-NEXT:    buffer_store_dword v0, off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    v_readlane_b32 s31, v3, 1
; GFX9-O3-NEXT:    v_readlane_b32 s30, v3, 0
; GFX9-O3-NEXT:    s_mov_b32 s32, s33
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_mov_b32 s33, s38
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %tmp107 = tail call i32 @llvm.amdgcn.set.inactive.i32(i32 %arg, i32 0)
  %tmp134 = call amdgpu_gfx i32 @strict_wwm_called(i32 %tmp107)
  %tmp136 = add i32 %tmp134, %tmp107
  %tmp137 = tail call i32 @llvm.amdgcn.strict.wwm.i32(i32 %tmp136)
  call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %tmp137, ptr addrspace(8) %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define amdgpu_gfx i64 @strict_wwm_called_i64(i64 %a) noinline {
; GFX9-O0-LABEL: strict_wwm_called_i64:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_add_co_u32_e64 v4, s[34:35], v4, v5
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v0, s[34:35], v0, v1, s[34:35]
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-O0-NEXT:    s_mov_b32 s34, 32
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s34, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    v_mul_lo_u32 v1, v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], s34, v[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-O0-NEXT:    v_mul_lo_u32 v2, v2, v3
; GFX9-O0-NEXT:    v_mad_u64_u32 v[6:7], s[36:37], v0, v3, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s35
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    v_lshlrev_b64 v[1:2], s34, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    s_mov_b32 s35, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_or_b32_e64 v0, v0, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_sub_co_u32_e64 v1, s[36:37], v1, v3
; GFX9-O0-NEXT:    v_subb_co_u32_e64 v0, s[36:37], v0, v2, s[36:37]
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_lshrrev_b64 v[1:2], s34, v[1:2]
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 killed $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_called_i64:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    v_add_co_u32_e32 v2, vcc, v0, v0
; GFX9-O3-NEXT:    v_addc_co_u32_e32 v3, vcc, v1, v1, vcc
; GFX9-O3-NEXT:    v_mul_lo_u32 v4, v3, v0
; GFX9-O3-NEXT:    v_mul_lo_u32 v5, v2, v1
; GFX9-O3-NEXT:    v_mad_u64_u32 v[0:1], s[34:35], v2, v0, 0
; GFX9-O3-NEXT:    v_add3_u32 v1, v1, v5, v4
; GFX9-O3-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v2
; GFX9-O3-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %add = add i64 %a, %a
  %mul = mul i64 %add, %a
  %sub = sub i64 %mul, %add
  ret i64 %sub
}

define amdgpu_gfx void @strict_wwm_call_i64(ptr addrspace(8) inreg %tmp14, i64 inreg %arg) {
; GFX9-O0-LABEL: strict_wwm_call_i64:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_mov_b32 s46, s33
; GFX9-O0-NEXT:    s_mov_b32 s33, s32
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_add_i32 s32, s32, 0x1000
; GFX9-O0-NEXT:    v_writelane_b32 v10, s30, 0
; GFX9-O0-NEXT:    v_writelane_b32 v10, s31, 1
; GFX9-O0-NEXT:    s_mov_b32 s34, s8
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr38 killed $sgpr38 def $sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    s_mov_b32 s35, s39
; GFX9-O0-NEXT:    s_mov_b32 s44, s38
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s45, s37
; GFX9-O0-NEXT:    s_mov_b32 s40, s36
; GFX9-O0-NEXT:    ; kill: def $sgpr40 killed $sgpr40 def $sgpr40_sgpr41_sgpr42_sgpr43
; GFX9-O0-NEXT:    s_mov_b32 s41, s45
; GFX9-O0-NEXT:    s_mov_b32 s42, s44
; GFX9-O0-NEXT:    s_mov_b32 s43, s35
; GFX9-O0-NEXT:    ; implicit-def: $vgpr11 : SGPR spill to VGPR lane
; GFX9-O0-NEXT:    v_writelane_b32 v11, s40, 0
; GFX9-O0-NEXT:    v_writelane_b32 v11, s41, 1
; GFX9-O0-NEXT:    v_writelane_b32 v11, s42, 2
; GFX9-O0-NEXT:    v_writelane_b32 v11, s43, 3
; GFX9-O0-NEXT:    ; kill: def $sgpr34 killed $sgpr34 def $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b32 s35, s9
; GFX9-O0-NEXT:    ; kill: def $sgpr36_sgpr37 killed $sgpr34_sgpr35
; GFX9-O0-NEXT:    s_mov_b32 s38, s35
; GFX9-O0-NEXT:    s_mov_b64 s[36:37], 0
; GFX9-O0-NEXT:    s_mov_b32 s40, s37
; GFX9-O0-NEXT:    ; implicit-def: $sgpr42_sgpr43
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s38
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[38:39], -1
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s40
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v2, v2, v0, s[38:39]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[38:39]
; GFX9-O0-NEXT:    ; kill: def $sgpr34 killed $sgpr34 killed $sgpr34_sgpr35
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 killed $sgpr36_sgpr37
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s34
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    v_writelane_b32 v11, s34, 4
; GFX9-O0-NEXT:    v_writelane_b32 v11, s35, 5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s36
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v0, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-O0-NEXT:    s_mov_b32 s34, 32
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], s34, v[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v4
; GFX9-O0-NEXT:    s_getpc_b64 s[34:35]
; GFX9-O0-NEXT:    s_add_u32 s34, s34, strict_wwm_called_i64@gotpcrel32@lo+4
; GFX9-O0-NEXT:    s_addc_u32 s35, s35, strict_wwm_called_i64@gotpcrel32@hi+12
; GFX9-O0-NEXT:    s_load_dwordx2 s[34:35], s[34:35], 0x0
; GFX9-O0-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-O0-NEXT:    s_mov_b64 s[36:37], s[0:1]
; GFX9-O0-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-O0-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-O0-NEXT:    s_swappc_b64 s[30:31], s[34:35]
; GFX9-O0-NEXT:    v_readlane_b32 s34, v11, 4
; GFX9-O0-NEXT:    v_readlane_b32 s35, v11, 5
; GFX9-O0-NEXT:    v_readlane_b32 s36, v11, 0
; GFX9-O0-NEXT:    v_readlane_b32 s37, v11, 1
; GFX9-O0-NEXT:    v_readlane_b32 s38, v11, 2
; GFX9-O0-NEXT:    v_readlane_b32 s39, v11, 3
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr40
; GFX9-O0-NEXT:    ; implicit-def: $sgpr40
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_add_co_u32_e64 v2, s[40:41], v2, v4
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v3, s[40:41], v3, v5, s[40:41]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_store_dwordx2 v[0:1], off, s[36:39], s34 offset:4
; GFX9-O0-NEXT:    v_readlane_b32 s31, v10, 1
; GFX9-O0-NEXT:    v_readlane_b32 s30, v10, 0
; GFX9-O0-NEXT:    s_mov_b32 s32, s33
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s33, s46
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_call_i64:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_mov_b32 s38, s33
; GFX9-O3-NEXT:    s_mov_b32 s33, s32
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v6, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v7, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v8, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_writelane_b32 v8, s30, 0
; GFX9-O3-NEXT:    s_addk_i32 s32, 0x800
; GFX9-O3-NEXT:    v_writelane_b32 v8, s31, 1
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, s9
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v6, 0, v0, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[36:37], -1
; GFX9-O3-NEXT:    s_getpc_b64 s[34:35]
; GFX9-O3-NEXT:    s_add_u32 s34, s34, strict_wwm_called_i64@gotpcrel32@lo+4
; GFX9-O3-NEXT:    s_addc_u32 s35, s35, strict_wwm_called_i64@gotpcrel32@hi+12
; GFX9-O3-NEXT:    s_load_dwordx2 s[34:35], s[34:35], 0x0
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v7, 0, v0, s[36:37]
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O3-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-O3-NEXT:    s_swappc_b64 s[30:31], s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O3-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v7
; GFX9-O3-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v6, vcc
; GFX9-O3-NEXT:    s_mov_b64 exec, s[36:37]
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O3-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0 offset:4
; GFX9-O3-NEXT:    v_readlane_b32 s31, v8, 1
; GFX9-O3-NEXT:    v_readlane_b32 s30, v8, 0
; GFX9-O3-NEXT:    s_mov_b32 s32, s33
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v6, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_mov_b32 s33, s38
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %tmp107 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %arg, i64 0)
  %tmp134 = call amdgpu_gfx i64 @strict_wwm_called_i64(i64 %tmp107)
  %tmp136 = add i64 %tmp134, %tmp107
  %tmp137 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp136)
  %tmp138 = bitcast i64 %tmp137 to <2 x i32>
  call void @llvm.amdgcn.raw.ptr.buffer.store.v2i32(<2 x i32> %tmp138, ptr addrspace(8) %tmp14, i32 4, i32 0, i32 0)
  ret void
}

define amdgpu_gfx void @strict_wwm_amdgpu_cs_main(<4 x i32> inreg %desc, i32 %index) {
; GFX9-O0-LABEL: strict_wwm_amdgpu_cs_main:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_mov_b32 s36, s4
; GFX9-O0-NEXT:    ; kill: def $sgpr36 killed $sgpr36 def $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s37, s5
; GFX9-O0-NEXT:    s_mov_b32 s38, s6
; GFX9-O0-NEXT:    s_mov_b32 s39, s7
; GFX9-O0-NEXT:    ; kill: def $sgpr40_sgpr41_sgpr42_sgpr43 killed $sgpr36_sgpr37_sgpr38_sgpr39
; GFX9-O0-NEXT:    s_mov_b32 s34, 5
; GFX9-O0-NEXT:    v_lshlrev_b32_e64 v0, s34, v0
; GFX9-O0-NEXT:    s_mov_b32 s34, 0
; GFX9-O0-NEXT:    buffer_load_dwordx4 v[11:14], v0, s[36:39], s34 offen
; GFX9-O0-NEXT:    buffer_load_dwordx2 v[4:5], v0, s[36:39], s34 offen offset:16
; GFX9-O0-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    s_mov_b32 s35, 0x7fffffff
; GFX9-O0-NEXT:    s_mov_b32 s44, -1
; GFX9-O0-NEXT:    ; kill: def $sgpr44 killed $sgpr44 def $sgpr44_sgpr45
; GFX9-O0-NEXT:    s_mov_b32 s45, s35
; GFX9-O0-NEXT:    s_mov_b32 s42, s45
; GFX9-O0-NEXT:    ; implicit-def: $sgpr46_sgpr47
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s42
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[40:41]
; GFX9-O0-NEXT:    s_mov_b32 s35, s44
; GFX9-O0-NEXT:    ; implicit-def: $sgpr44_sgpr45
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s35
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[40:41]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr43
; GFX9-O0-NEXT:    ; implicit-def: $sgpr43
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v14
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr44_sgpr45
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s42
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[40:41]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr44_sgpr45
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s35
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[40:41]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr43
; GFX9-O0-NEXT:    ; implicit-def: $sgpr43
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v3
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr44_sgpr45
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s42
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v6, s[40:41]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 killed $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[40:41], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr42_sgpr43
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s35
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[40:41]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    s_mov_b64 exec, s[40:41]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr35
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7_vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v10
; GFX9-O0-NEXT:    buffer_store_dwordx4 v[6:9], v0, s[36:39], s34 offen
; GFX9-O0-NEXT:    buffer_store_dwordx2 v[4:5], v0, s[36:39], s34 offen offset:16
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_amdgpu_cs_main:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX9-O3-NEXT:    buffer_load_dwordx4 v[8:11], v0, s[4:7], 0 offen
; GFX9-O3-NEXT:    buffer_load_dwordx2 v[12:13], v0, s[4:7], 0 offen offset:16
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_bfrev_b32_e32 v1, -2
; GFX9-O3-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v3, v1, v9, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v2, -1, v8, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v5, v1, v11, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v4, -1, v10, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v7, v1, v13, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v6, -1, v12, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O3-NEXT:    v_mov_b32_e32 v10, v4
; GFX9-O3-NEXT:    v_mov_b32_e32 v9, v3
; GFX9-O3-NEXT:    v_mov_b32_e32 v11, v5
; GFX9-O3-NEXT:    v_mov_b32_e32 v12, v6
; GFX9-O3-NEXT:    v_mov_b32_e32 v13, v7
; GFX9-O3-NEXT:    buffer_store_dwordx4 v[8:11], v0, s[4:7], 0 offen
; GFX9-O3-NEXT:    buffer_store_dwordx2 v[12:13], v0, s[4:7], 0 offen offset:16
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %tmp17 = shl i32 %index, 5
  %tmp18 = tail call <4 x i32> @llvm.amdgcn.s.buffer.load.v4i32(<4 x i32> %desc, i32 %tmp17, i32 0)
  %.i0.upto1.bc = bitcast <4 x i32> %tmp18 to <2 x i64>
  %tmp19 = or i32 %tmp17, 16
  %tmp20 = tail call <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32> %desc, i32 %tmp19, i32 0)
  %.i0.upto1.extract = extractelement <2 x i64> %.i0.upto1.bc, i32 0
  %tmp22 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %.i0.upto1.extract, i64 9223372036854775807)
  %tmp97 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp22)
  %.i1.upto1.extract = extractelement <2 x i64> %.i0.upto1.bc, i32 1
  %tmp99 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %.i1.upto1.extract, i64 9223372036854775807)
  %tmp174 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp99)
  %.i25 = bitcast <2 x i32> %tmp20 to i64
  %tmp176 = tail call i64 @llvm.amdgcn.set.inactive.i64(i64 %.i25, i64 9223372036854775807)
  %tmp251 = tail call i64 @llvm.amdgcn.strict.wwm.i64(i64 %tmp176)
  %.cast = bitcast i64 %tmp97 to <2 x float>
  %.cast6 = bitcast i64 %tmp174 to <2 x float>
  %.cast7 = bitcast i64 %tmp251 to <2 x float>
  %tmp254 = shufflevector <2 x float> %.cast, <2 x float> %.cast6, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %desc.int = bitcast <4 x i32> %desc to i128
  %desc.ptr = inttoptr i128 %desc.int to ptr addrspace(8)
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.v4f32(<4 x float> %tmp254, ptr addrspace(8) %desc.ptr, i32 %tmp17, i32 0, i32 0)
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.v2f32(<2 x float> %.cast7, ptr addrspace(8) %desc.ptr, i32 %tmp19, i32 0, i32 0)
  ret void
}

; FIXME: This spills v40 and v41 twice, once in whole-wave-mode and once for the active lanes
define amdgpu_gfx <32 x i32> @strict_wwm_callee_saves(<32 x i32> inreg %keep, ptr addrspace(5) %ptr, i64 %a, i64 %b, i64 %c, i64 %d, i64 %e) #0 {
; GFX9-O0-LABEL: strict_wwm_callee_saves:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_store_dword v32, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_store_dword v34, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, -1
; GFX9-O0-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_writelane_b32 v47, s64, 0
; GFX9-O0-NEXT:    v_writelane_b32 v47, s65, 1
; GFX9-O0-NEXT:    v_writelane_b32 v47, s66, 2
; GFX9-O0-NEXT:    v_writelane_b32 v47, s67, 3
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:20
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:16
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:12
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:8
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-O0-NEXT:    v_mov_b32_e32 v35, s5
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s10
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s12
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s14
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s15
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v40, s18
; GFX9-O0-NEXT:    v_mov_b32_e32 v39, s19
; GFX9-O0-NEXT:    v_mov_b32_e32 v38, s20
; GFX9-O0-NEXT:    v_mov_b32_e32 v37, s21
; GFX9-O0-NEXT:    v_mov_b32_e32 v36, s22
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s23
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v46, s24
; GFX9-O0-NEXT:    v_mov_b32_e32 v45, s25
; GFX9-O0-NEXT:    v_mov_b32_e32 v44, s26
; GFX9-O0-NEXT:    v_mov_b32_e32 v43, s27
; GFX9-O0-NEXT:    v_mov_b32_e32 v42, s28
; GFX9-O0-NEXT:    v_mov_b32_e32 v41, s29
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v40
; GFX9-O0-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v39
; GFX9-O0-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v38
; GFX9-O0-NEXT:    buffer_load_dword v38, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v37
; GFX9-O0-NEXT:    buffer_load_dword v37, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v36
; GFX9-O0-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(5)
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v35
; GFX9-O0-NEXT:    buffer_load_dword v35, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v46
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v45
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v44
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v43
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v42
; GFX9-O0-NEXT:    v_mov_b32_e32 v25, v41
; GFX9-O0-NEXT:    s_waitcnt vmcnt(5)
; GFX9-O0-NEXT:    v_mov_b32_e32 v26, v40
; GFX9-O0-NEXT:    s_waitcnt vmcnt(4)
; GFX9-O0-NEXT:    v_mov_b32_e32 v27, v39
; GFX9-O0-NEXT:    s_waitcnt vmcnt(3)
; GFX9-O0-NEXT:    v_mov_b32_e32 v28, v38
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_mov_b32_e32 v29, v37
; GFX9-O0-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O0-NEXT:    v_mov_b32_e32 v30, v36
; GFX9-O0-NEXT:    ; kill: def $vgpr31 killed $vgpr35 killed $exec
; GFX9-O0-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(4)
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34
; GFX9-O0-NEXT:    ; kill: def $vgpr10 killed $vgpr10 def $vgpr10_vgpr11 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr34_sgpr35
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36_sgpr37_sgpr38_sgpr39_sgpr40_sgpr41_sgpr42_sgpr43_sgpr44_sgpr45_sgpr46_sgpr47_sgpr48_sgpr49_sgpr50_sgpr51_sgpr52_sgpr53_sgpr54_sgpr55_sgpr56_sgpr57_sgpr58_sgpr59_sgpr60_sgpr61_sgpr62_sgpr63_sgpr64_sgpr65_sgpr66_sgpr67
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v11
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    s_mov_b64 s[38:39], 0
; GFX9-O0-NEXT:    s_mov_b32 s37, s39
; GFX9-O0-NEXT:    ; implicit-def: $sgpr40_sgpr41
; GFX9-O0-NEXT:    v_mov_b32_e32 v32, s37
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v32, v32, v0, s[34:35]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v10
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    s_mov_b32 s36, s38
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v33, s36
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v33, v33, v0, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    v_mov_b32_e32 v34, v32
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v33
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v32, s37
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v32, v32, v0, s[34:35]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v33, s36
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v33, v33, v0, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    v_mov_b32_e32 v34, v32
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v33
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v32, s37
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v32, v32, v0, s[34:35]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v6
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v33, s36
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v33, v33, v0, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    v_mov_b32_e32 v34, v32
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v33
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v5
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v32, s37
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v32, v32, v0, s[34:35]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v33, s36
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v33, v33, v0, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38
; GFX9-O0-NEXT:    v_mov_b32_e32 v34, v32
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v33
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v32, s37
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v32, v32, v0, s[34:35]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr38_sgpr39
; GFX9-O0-NEXT:    v_mov_b32_e32 v33, s36
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v33, v33, v0, s[34:35]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36
; GFX9-O0-NEXT:    ; implicit-def: $sgpr36
; GFX9-O0-NEXT:    v_mov_b32_e32 v34, v32
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v33
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v34
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v11
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:4
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v10
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v9
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:12
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:8
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:20
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v6
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:16
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v5
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:28
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:24
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:36
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-O0-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen offset:32
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, s12
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s13
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, s14
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s15
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s16
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, s17
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, s18
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s19
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s21
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, s22
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, s23
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, s24
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, s25
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, s26
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, s27
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, s28
; GFX9-O0-NEXT:    v_mov_b32_e32 v25, s29
; GFX9-O0-NEXT:    v_readlane_b32 s67, v47, 3
; GFX9-O0-NEXT:    v_readlane_b32 s66, v47, 2
; GFX9-O0-NEXT:    v_readlane_b32 s65, v47, 1
; GFX9-O0-NEXT:    v_readlane_b32 s64, v47, 0
; GFX9-O0-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O0-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v34, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, -1
; GFX9-O0-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O3-LABEL: strict_wwm_callee_saves:
; GFX9-O3:       ; %bb.0:
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_store_dword v32, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_nop 0
; GFX9-O3-NEXT:    buffer_store_dword v33, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    buffer_load_dword v26, off, s[0:3], s32
; GFX9-O3-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:4
; GFX9-O3-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:8
; GFX9-O3-NEXT:    buffer_load_dword v29, off, s[0:3], s32 offset:12
; GFX9-O3-NEXT:    buffer_load_dword v30, off, s[0:3], s32 offset:16
; GFX9-O3-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:20
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v33, 0, v2, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v32, 0, v1, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, v32
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, v33
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v33, 0, v4, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v32, 0, v3, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, v32
; GFX9-O3-NEXT:    v_mov_b32_e32 v4, v33
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v33, 0, v6, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v32, 0, v5, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, v32
; GFX9-O3-NEXT:    v_mov_b32_e32 v6, v33
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v33, 0, v8, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v32, 0, v7, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v7, v32
; GFX9-O3-NEXT:    v_mov_b32_e32 v8, v33
; GFX9-O3-NEXT:    s_or_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v33, 0, v10, s[34:35]
; GFX9-O3-NEXT:    v_cndmask_b32_e64 v32, 0, v9, s[34:35]
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    v_mov_b32_e32 v9, v32
; GFX9-O3-NEXT:    v_mov_b32_e32 v10, v33
; GFX9-O3-NEXT:    buffer_store_dword v2, v0, s[0:3], 0 offen offset:4
; GFX9-O3-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-O3-NEXT:    buffer_store_dword v4, v0, s[0:3], 0 offen offset:12
; GFX9-O3-NEXT:    buffer_store_dword v3, v0, s[0:3], 0 offen offset:8
; GFX9-O3-NEXT:    buffer_store_dword v6, v0, s[0:3], 0 offen offset:20
; GFX9-O3-NEXT:    buffer_store_dword v5, v0, s[0:3], 0 offen offset:16
; GFX9-O3-NEXT:    buffer_store_dword v8, v0, s[0:3], 0 offen offset:28
; GFX9-O3-NEXT:    buffer_store_dword v7, v0, s[0:3], 0 offen offset:24
; GFX9-O3-NEXT:    buffer_store_dword v10, v0, s[0:3], 0 offen offset:36
; GFX9-O3-NEXT:    buffer_store_dword v9, v0, s[0:3], 0 offen offset:32
; GFX9-O3-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-O3-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-O3-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-O3-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-O3-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O3-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-O3-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-O3-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-O3-NEXT:    v_mov_b32_e32 v8, s12
; GFX9-O3-NEXT:    v_mov_b32_e32 v9, s13
; GFX9-O3-NEXT:    v_mov_b32_e32 v10, s14
; GFX9-O3-NEXT:    v_mov_b32_e32 v11, s15
; GFX9-O3-NEXT:    v_mov_b32_e32 v12, s16
; GFX9-O3-NEXT:    v_mov_b32_e32 v13, s17
; GFX9-O3-NEXT:    v_mov_b32_e32 v14, s18
; GFX9-O3-NEXT:    v_mov_b32_e32 v15, s19
; GFX9-O3-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-O3-NEXT:    v_mov_b32_e32 v17, s21
; GFX9-O3-NEXT:    v_mov_b32_e32 v18, s22
; GFX9-O3-NEXT:    v_mov_b32_e32 v19, s23
; GFX9-O3-NEXT:    v_mov_b32_e32 v20, s24
; GFX9-O3-NEXT:    v_mov_b32_e32 v21, s25
; GFX9-O3-NEXT:    v_mov_b32_e32 v22, s26
; GFX9-O3-NEXT:    v_mov_b32_e32 v23, s27
; GFX9-O3-NEXT:    v_mov_b32_e32 v24, s28
; GFX9-O3-NEXT:    v_mov_b32_e32 v25, s29
; GFX9-O3-NEXT:    s_xor_saveexec_b64 s[34:35], -1
; GFX9-O3-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    buffer_load_dword v33, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O3-NEXT:    s_mov_b64 exec, s[34:35]
; GFX9-O3-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O3-NEXT:    s_setpc_b64 s[30:31]
  %a2.i = call i64 @llvm.amdgcn.set.inactive.i64(i64 %a, i64 0)
  %a2 = call i64 @llvm.amdgcn.strict.wwm.i64(i64 %a2.i)
  %b2.i = call i64 @llvm.amdgcn.set.inactive.i64(i64 %b, i64 0)
  %b2 = call i64 @llvm.amdgcn.strict.wwm.i64(i64 %b2.i)
  %c2.i = call i64 @llvm.amdgcn.set.inactive.i64(i64 %c, i64 0)
  %c2 = call i64 @llvm.amdgcn.strict.wwm.i64(i64 %c2.i)
  %d2.i = call i64 @llvm.amdgcn.set.inactive.i64(i64 %d, i64 0)
  %d2 = call i64 @llvm.amdgcn.strict.wwm.i64(i64 %d2.i)
  %e2.i = call i64 @llvm.amdgcn.set.inactive.i64(i64 %e, i64 0)
  %e2 = call i64 @llvm.amdgcn.strict.wwm.i64(i64 %e2.i)
  store i64 %a2, ptr addrspace(5) %ptr
  %ptr_b = getelementptr i64, ptr addrspace(5) %ptr, i32 1
  store i64 %b2, ptr addrspace(5) %ptr_b
  %ptr_c = getelementptr i64, ptr addrspace(5) %ptr, i32 2
  store i64 %c2, ptr addrspace(5) %ptr_c
  %ptr_d = getelementptr i64, ptr addrspace(5) %ptr, i32 3
  store i64 %d2, ptr addrspace(5) %ptr_d
  %ptr_e = getelementptr i64, ptr addrspace(5) %ptr, i32 4
  store i64 %e2, ptr addrspace(5) %ptr_e
  ret <32 x i32> %keep
}

declare i32 @llvm.amdgcn.strict.wwm.i32(i32)
declare i64 @llvm.amdgcn.strict.wwm.i64(i64)
declare i32 @llvm.amdgcn.set.inactive.i32(i32, i32)
declare i64 @llvm.amdgcn.set.inactive.i64(i64, i64)
declare i32 @llvm.amdgcn.update.dpp.i32(i32, i32, i32, i32, i32, i1)
declare <2 x float> @llvm.amdgcn.raw.ptr.buffer.load.v2f32(ptr addrspace(8), i32, i32, i32)
declare void @llvm.amdgcn.raw.ptr.buffer.store.f32(float, ptr addrspace(8), i32, i32, i32)
declare void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32, ptr addrspace(8), i32, i32, i32)
declare void @llvm.amdgcn.raw.ptr.buffer.store.v2i32(<2 x i32>, ptr addrspace(8), i32, i32, i32)
declare void @llvm.amdgcn.raw.ptr.buffer.store.v2f32(<2 x float>, ptr addrspace(8), i32, i32, i32)
declare void @llvm.amdgcn.raw.ptr.buffer.store.v4f32(<4 x float>, ptr addrspace(8), i32, i32, i32)
declare <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32>, i32, i32)
declare <4 x i32> @llvm.amdgcn.s.buffer.load.v4i32(<4 x i32>, i32, i32)

attributes #0 = { "amdgpu-waves-per-eu"="5,5" }
