; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE


target triple = "aarch64-unknown-linux-gnu"

;
; ANDV
;

define i8 @andv_v4i8(<4 x i8> %a) {
; CHECK-LABEL: andv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    and w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.and.v4i8(<4 x i8> %a)
  ret i8 %res
}

define i8 @andv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: andv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    andv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #14]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    and w12, w13, w12
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    and w10, w12, w10
; NONEON-NOSVE-NEXT:    and w8, w8, w14
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    and w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.and.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @andv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: andv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    andv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #3]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #2]
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    and w11, w14, w13
; NONEON-NOSVE-NEXT:    and w9, w12, w9
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #7]
; NONEON-NOSVE-NEXT:    and w10, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    and w9, w9, w16
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #9]
; NONEON-NOSVE-NEXT:    and w12, w12, w15
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #14]
; NONEON-NOSVE-NEXT:    and w8, w13, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #15]
; NONEON-NOSVE-NEXT:    and w12, w12, w14
; NONEON-NOSVE-NEXT:    and w8, w8, w11
; NONEON-NOSVE-NEXT:    and w9, w10, w9
; NONEON-NOSVE-NEXT:    and w10, w12, w16
; NONEON-NOSVE-NEXT:    and w8, w8, w15
; NONEON-NOSVE-NEXT:    and w9, w9, w10
; NONEON-NOSVE-NEXT:    and w8, w8, w13
; NONEON-NOSVE-NEXT:    and w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @andv_v32i8(ptr %a) {
; CHECK-LABEL: andv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #2]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #3]
; NONEON-NOSVE-NEXT:    and w9, w11, w10
; NONEON-NOSVE-NEXT:    and w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #5]
; NONEON-NOSVE-NEXT:    and w11, w15, w14
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #4]
; NONEON-NOSVE-NEXT:    and w9, w10, w11
; NONEON-NOSVE-NEXT:    and w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #6]
; NONEON-NOSVE-NEXT:    and w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    and w10, w14, w10
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #7]
; NONEON-NOSVE-NEXT:    and w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w8, w9
; NONEON-NOSVE-NEXT:    and w9, w10, w11
; NONEON-NOSVE-NEXT:    and w10, w14, w13
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #9]
; NONEON-NOSVE-NEXT:    and w8, w8, w9
; NONEON-NOSVE-NEXT:    and w11, w15, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #26]
; NONEON-NOSVE-NEXT:    and w9, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #10]
; NONEON-NOSVE-NEXT:    and w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #12]
; NONEON-NOSVE-NEXT:    and w9, w9, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #14]
; NONEON-NOSVE-NEXT:    and w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #15]
; NONEON-NOSVE-NEXT:    and w10, w13, w10
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #13]
; NONEON-NOSVE-NEXT:    and w14, w15, w14
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #30]
; NONEON-NOSVE-NEXT:    and w9, w9, w14
; NONEON-NOSVE-NEXT:    and w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #31]
; NONEON-NOSVE-NEXT:    and w8, w8, w9
; NONEON-NOSVE-NEXT:    and w10, w10, w12
; NONEON-NOSVE-NEXT:    and w11, w16, w11
; NONEON-NOSVE-NEXT:    and w10, w10, w11
; NONEON-NOSVE-NEXT:    and w11, w17, w13
; NONEON-NOSVE-NEXT:    and w9, w10, w11
; NONEON-NOSVE-NEXT:    and w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.and.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @andv_v2i16(<2 x i16> %a) {
; CHECK-LABEL: andv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    and w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.and.v2i16(<2 x i16> %a)
  ret i16 %res
}

define i16 @andv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: andv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    and w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.and.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @andv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: andv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    and w12, w13, w12
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    and w10, w12, w10
; NONEON-NOSVE-NEXT:    and w8, w8, w14
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    and w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @andv_v16i16(ptr %a) {
; CHECK-LABEL: andv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #4]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #6]
; NONEON-NOSVE-NEXT:    and w9, w11, w10
; NONEON-NOSVE-NEXT:    and w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    and w13, w15, w14
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #8]
; NONEON-NOSVE-NEXT:    and w9, w12, w13
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #12]
; NONEON-NOSVE-NEXT:    and w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #14]
; NONEON-NOSVE-NEXT:    and w10, w14, w10
; NONEON-NOSVE-NEXT:    and w11, w15, w11
; NONEON-NOSVE-NEXT:    and w8, w8, w9
; NONEON-NOSVE-NEXT:    and w9, w10, w11
; NONEON-NOSVE-NEXT:    and w8, w8, w9
; NONEON-NOSVE-NEXT:    and w9, w13, w12
; NONEON-NOSVE-NEXT:    and w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @andv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: andv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    and w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.and.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @andv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: andv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp], #16
; NONEON-NOSVE-NEXT:    and w10, w11, w10
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    and w0, w10, w8
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @andv_v8i32(ptr %a) {
; CHECK-LABEL: andv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp]
; NONEON-NOSVE-NEXT:    ldp w12, w13, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp w14, w15, [sp, #8]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    and w9, w11, w9
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    and w10, w14, w12
; NONEON-NOSVE-NEXT:    and w11, w15, w13
; NONEON-NOSVE-NEXT:    and w9, w10, w11
; NONEON-NOSVE-NEXT:    and w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.and.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @andv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: andv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    andv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    and x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @andv_v4i64(ptr %a) {
; CHECK-LABEL: andv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: andv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp x11, x10, [sp], #32
; NONEON-NOSVE-NEXT:    and x8, x10, x8
; NONEON-NOSVE-NEXT:    and x9, x11, x9
; NONEON-NOSVE-NEXT:    and x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.and.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; EORV
;

define i8 @eorv_v4i8(<4 x i8> %a) {
; CHECK-LABEL: eorv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    eor w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.xor.v4i8(<4 x i8> %a)
  ret i8 %res
}

define i8 @eorv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: eorv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    eorv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    eor w12, w13, w12
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    eor w10, w12, w10
; NONEON-NOSVE-NEXT:    eor w8, w8, w14
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    eor w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.xor.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @eorv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: eorv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    eorv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #3]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #2]
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w11, w14, w13
; NONEON-NOSVE-NEXT:    eor w9, w12, w9
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #7]
; NONEON-NOSVE-NEXT:    eor w10, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    eor w9, w9, w16
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #9]
; NONEON-NOSVE-NEXT:    eor w12, w12, w15
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w8, w13, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #15]
; NONEON-NOSVE-NEXT:    eor w12, w12, w14
; NONEON-NOSVE-NEXT:    eor w8, w8, w11
; NONEON-NOSVE-NEXT:    eor w9, w10, w9
; NONEON-NOSVE-NEXT:    eor w10, w12, w16
; NONEON-NOSVE-NEXT:    eor w8, w8, w15
; NONEON-NOSVE-NEXT:    eor w9, w9, w10
; NONEON-NOSVE-NEXT:    eor w8, w8, w13
; NONEON-NOSVE-NEXT:    eor w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @eorv_v32i8(ptr %a) {
; CHECK-LABEL: eorv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #2]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #3]
; NONEON-NOSVE-NEXT:    eor w9, w11, w10
; NONEON-NOSVE-NEXT:    eor w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #5]
; NONEON-NOSVE-NEXT:    eor w11, w15, w14
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #4]
; NONEON-NOSVE-NEXT:    eor w9, w10, w11
; NONEON-NOSVE-NEXT:    eor w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #6]
; NONEON-NOSVE-NEXT:    eor w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w10, w14, w10
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #7]
; NONEON-NOSVE-NEXT:    eor w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w8, w9
; NONEON-NOSVE-NEXT:    eor w9, w10, w11
; NONEON-NOSVE-NEXT:    eor w10, w14, w13
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #9]
; NONEON-NOSVE-NEXT:    eor w8, w8, w9
; NONEON-NOSVE-NEXT:    eor w11, w15, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w9, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #10]
; NONEON-NOSVE-NEXT:    eor w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #12]
; NONEON-NOSVE-NEXT:    eor w9, w9, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #15]
; NONEON-NOSVE-NEXT:    eor w10, w13, w10
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #13]
; NONEON-NOSVE-NEXT:    eor w14, w15, w14
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #30]
; NONEON-NOSVE-NEXT:    eor w9, w9, w14
; NONEON-NOSVE-NEXT:    eor w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #31]
; NONEON-NOSVE-NEXT:    eor w8, w8, w9
; NONEON-NOSVE-NEXT:    eor w10, w10, w12
; NONEON-NOSVE-NEXT:    eor w11, w16, w11
; NONEON-NOSVE-NEXT:    eor w10, w10, w11
; NONEON-NOSVE-NEXT:    eor w11, w17, w13
; NONEON-NOSVE-NEXT:    eor w9, w10, w11
; NONEON-NOSVE-NEXT:    eor w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.xor.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @eorv_v2i16(<2 x i16> %a) {
; CHECK-LABEL: eorv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.xor.v2i16(<2 x i16> %a)
  ret i16 %res
}

define i16 @eorv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: eorv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    eor w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.xor.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @eorv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: eorv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w12, w13, w12
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    eor w10, w12, w10
; NONEON-NOSVE-NEXT:    eor w8, w8, w14
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    eor w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @eorv_v16i16(ptr %a) {
; CHECK-LABEL: eorv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #4]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #6]
; NONEON-NOSVE-NEXT:    eor w9, w11, w10
; NONEON-NOSVE-NEXT:    eor w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    eor w13, w15, w14
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w9, w12, w13
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #12]
; NONEON-NOSVE-NEXT:    eor w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w10, w14, w10
; NONEON-NOSVE-NEXT:    eor w11, w15, w11
; NONEON-NOSVE-NEXT:    eor w8, w8, w9
; NONEON-NOSVE-NEXT:    eor w9, w10, w11
; NONEON-NOSVE-NEXT:    eor w8, w8, w9
; NONEON-NOSVE-NEXT:    eor w9, w13, w12
; NONEON-NOSVE-NEXT:    eor w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.xor.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @eorv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: eorv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.xor.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @eorv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: eorv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp], #16
; NONEON-NOSVE-NEXT:    eor w10, w11, w10
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    eor w0, w10, w8
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @eorv_v8i32(ptr %a) {
; CHECK-LABEL: eorv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp]
; NONEON-NOSVE-NEXT:    ldp w12, w13, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp w14, w15, [sp, #8]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    eor w9, w11, w9
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    eor w10, w14, w12
; NONEON-NOSVE-NEXT:    eor w11, w15, w13
; NONEON-NOSVE-NEXT:    eor w9, w10, w11
; NONEON-NOSVE-NEXT:    eor w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.xor.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @eorv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: eorv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    eorv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    eor x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @eorv_v4i64(ptr %a) {
; CHECK-LABEL: eorv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: eorv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp x11, x10, [sp], #32
; NONEON-NOSVE-NEXT:    eor x8, x10, x8
; NONEON-NOSVE-NEXT:    eor x9, x11, x9
; NONEON-NOSVE-NEXT:    eor x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.xor.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; ORV
;

define i8 @orv_v4i8(<4 x i8> %a) {
; CHECK-LABEL: orv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    orr w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.or.v4i8(<4 x i8> %a)
  ret i8 %res
}

define i8 @orv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: orv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    orv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    orr w12, w13, w12
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    orr w10, w12, w10
; NONEON-NOSVE-NEXT:    orr w8, w8, w14
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    orr w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.or.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @orv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: orv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    orv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #3]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #2]
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w11, w14, w13
; NONEON-NOSVE-NEXT:    orr w9, w12, w9
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #7]
; NONEON-NOSVE-NEXT:    orr w10, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #13]
; NONEON-NOSVE-NEXT:    orr w9, w9, w16
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #9]
; NONEON-NOSVE-NEXT:    orr w12, w12, w15
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w8, w13, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #15]
; NONEON-NOSVE-NEXT:    orr w12, w12, w14
; NONEON-NOSVE-NEXT:    orr w8, w8, w11
; NONEON-NOSVE-NEXT:    orr w9, w10, w9
; NONEON-NOSVE-NEXT:    orr w10, w12, w16
; NONEON-NOSVE-NEXT:    orr w8, w8, w15
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    orr w8, w8, w13
; NONEON-NOSVE-NEXT:    orr w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.or.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @orv_v32i8(ptr %a) {
; CHECK-LABEL: orv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #2]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #3]
; NONEON-NOSVE-NEXT:    orr w9, w11, w10
; NONEON-NOSVE-NEXT:    orr w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #5]
; NONEON-NOSVE-NEXT:    orr w11, w15, w14
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #4]
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    orr w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #6]
; NONEON-NOSVE-NEXT:    orr w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w10, w14, w10
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #7]
; NONEON-NOSVE-NEXT:    orr w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    orr w10, w14, w13
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #9]
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    orr w11, w15, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #10]
; NONEON-NOSVE-NEXT:    orr w10, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #12]
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w16, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w11, w12, w11
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w17, [sp, #15]
; NONEON-NOSVE-NEXT:    orr w10, w13, w10
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #13]
; NONEON-NOSVE-NEXT:    orr w14, w15, w14
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #30]
; NONEON-NOSVE-NEXT:    orr w9, w9, w14
; NONEON-NOSVE-NEXT:    orr w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #31]
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    orr w10, w10, w12
; NONEON-NOSVE-NEXT:    orr w11, w16, w11
; NONEON-NOSVE-NEXT:    orr w10, w10, w11
; NONEON-NOSVE-NEXT:    orr w11, w17, w13
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    orr w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.or.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @orv_v2i16(<2 x i16> %a) {
; CHECK-LABEL: orv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.or.v2i16(<2 x i16> %a)
  ret i16 %res
}

define i16 @orv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: orv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    orr w0, w10, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.or.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @orv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: orv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w12, w13, w12
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    orr w10, w12, w10
; NONEON-NOSVE-NEXT:    orr w8, w8, w14
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    orr w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.or.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @orv_v16i16(ptr %a) {
; CHECK-LABEL: orv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #4]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w14, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #6]
; NONEON-NOSVE-NEXT:    orr w9, w11, w10
; NONEON-NOSVE-NEXT:    orr w12, w13, w12
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    orr w13, w15, w14
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w16, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w17, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w9, w12, w13
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w15, [sp, #12]
; NONEON-NOSVE-NEXT:    orr w14, w17, w16
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w13, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w10, w14, w10
; NONEON-NOSVE-NEXT:    orr w11, w15, w11
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    orr w9, w13, w12
; NONEON-NOSVE-NEXT:    orr w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.or.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @orv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: orv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w0, w9, w8
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.or.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @orv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: orv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp], #16
; NONEON-NOSVE-NEXT:    orr w10, w11, w10
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    orr w0, w10, w8
; NONEON-NOSVE-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.or.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @orv_v8i32(ptr %a) {
; CHECK-LABEL: orv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w11, w10, [sp]
; NONEON-NOSVE-NEXT:    ldp w12, w13, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp w14, w15, [sp, #8]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    orr w9, w11, w9
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    orr w10, w14, w12
; NONEON-NOSVE-NEXT:    orr w11, w15, w13
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    orr w0, w8, w9
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.or.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @orv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: orv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    orv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp], #16
; NONEON-NOSVE-NEXT:    orr x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.or.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @orv_v4i64(ptr %a) {
; CHECK-LABEL: orv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: orv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp x11, x10, [sp], #32
; NONEON-NOSVE-NEXT:    orr x8, x10, x8
; NONEON-NOSVE-NEXT:    orr x9, x11, x9
; NONEON-NOSVE-NEXT:    orr x0, x9, x8
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.or.v4i64(<4 x i64> %op)
  ret i64 %res
}

declare i8 @llvm.vector.reduce.and.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.and.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.and.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.and.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.and.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.and.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.and.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.and.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.and.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.and.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.and.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.and.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.and.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.or.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.or.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.or.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.or.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.or.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.or.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.or.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.or.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.or.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.or.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.or.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.or.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.or.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.xor.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.xor.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.xor.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.xor.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.xor.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.xor.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.xor.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.xor.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.xor.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.xor.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.xor.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.xor.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.xor.v4i64(<4 x i64>)
