/* registry-view.c generated by valac 0.38.2.7-b777e, the Vala compiler
 * generated from registry-view.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;
typedef struct _RegistryViewPrivate RegistryViewPrivate;

#define TYPE_BEHAVIOUR (behaviour_get_type ())

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;

#define TYPE_REGISTRY_INFO (registry_info_get_type ())
#define REGISTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_INFO, RegistryInfo))
#define REGISTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_INFO, RegistryInfoClass))
#define IS_REGISTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_INFO))
#define IS_REGISTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_INFO))
#define REGISTRY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_INFO, RegistryInfoClass))

typedef struct _RegistryInfo RegistryInfo;
typedef struct _RegistryInfoClass RegistryInfoClass;

#define TYPE_MODIFICATIONS_REVEALER (modifications_revealer_get_type ())
#define MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer))
#define MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))
#define IS_MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_REVEALER))
#define IS_MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_REVEALER))
#define MODIFICATIONS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))

typedef struct _ModificationsRevealer ModificationsRevealer;
typedef struct _ModificationsRevealerClass ModificationsRevealerClass;
enum  {
	REGISTRY_VIEW_0_PROPERTY,
	REGISTRY_VIEW_CURRENT_PATH_PROPERTY,
	REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY,
	REGISTRY_VIEW_BEHAVIOUR_PROPERTY,
	REGISTRY_VIEW_NUM_PROPERTIES
};
static GParamSpec* registry_view_properties[REGISTRY_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CLICKABLE_LIST_BOX_ROW (clickable_list_box_row_get_type ())
#define CLICKABLE_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow))
#define CLICKABLE_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRowClass))
#define IS_CLICKABLE_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLICKABLE_LIST_BOX_ROW))
#define IS_CLICKABLE_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLICKABLE_LIST_BOX_ROW))
#define CLICKABLE_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRowClass))

typedef struct _ClickableListBoxRow ClickableListBoxRow;
typedef struct _ClickableListBoxRowClass ClickableListBoxRowClass;

#define TYPE_SETTING_OBJECT (setting_object_get_type ())
#define SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_OBJECT, SettingObject))
#define SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_OBJECT, SettingObjectClass))
#define IS_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_OBJECT))
#define IS_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_OBJECT))
#define SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_OBJECT, SettingObjectClass))

typedef struct _SettingObject SettingObject;
typedef struct _SettingObjectClass SettingObjectClass;

#define TYPE_DIRECTORY (directory_get_type ())
#define DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY, Directory))
#define DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY, DirectoryClass))
#define IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY))
#define IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY))
#define DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY, DirectoryClass))

typedef struct _Directory Directory;
typedef struct _DirectoryClass DirectoryClass;

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;

#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;

#define TYPE_DCONF_KEY (dconf_key_get_type ())
#define DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_KEY, DConfKey))
#define DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_KEY, DConfKeyClass))
#define IS_DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_KEY))
#define IS_DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_KEY))
#define DCONF_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_KEY, DConfKeyClass))

typedef struct _DConfKey DConfKey;
typedef struct _DConfKeyClass DConfKeyClass;
typedef struct _Block22Data Block22Data;

#define TYPE_FOLDER_LIST_BOX_ROW (folder_list_box_row_get_type ())
#define FOLDER_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOLDER_LIST_BOX_ROW, FolderListBoxRow))
#define FOLDER_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOLDER_LIST_BOX_ROW, FolderListBoxRowClass))
#define IS_FOLDER_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOLDER_LIST_BOX_ROW))
#define IS_FOLDER_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOLDER_LIST_BOX_ROW))
#define FOLDER_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOLDER_LIST_BOX_ROW, FolderListBoxRowClass))

typedef struct _FolderListBoxRow FolderListBoxRow;
typedef struct _FolderListBoxRowClass FolderListBoxRowClass;

#define TYPE_KEY_LIST_BOX_ROW (key_list_box_row_get_type ())
#define KEY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_LIST_BOX_ROW, KeyListBoxRow))
#define KEY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_LIST_BOX_ROW, KeyListBoxRowClass))
#define IS_KEY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_LIST_BOX_ROW))
#define IS_KEY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_LIST_BOX_ROW))
#define KEY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_LIST_BOX_ROW, KeyListBoxRowClass))

typedef struct _KeyListBoxRow KeyListBoxRow;
typedef struct _KeyListBoxRowClass KeyListBoxRowClass;
typedef struct _Block23Data Block23Data;

#define TYPE_GSETTINGS_KEY (gsettings_key_get_type ())
#define GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GSETTINGS_KEY, GSettingsKey))
#define GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GSETTINGS_KEY, GSettingsKeyClass))
#define IS_GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GSETTINGS_KEY))
#define IS_GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GSETTINGS_KEY))
#define GSETTINGS_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GSETTINGS_KEY, GSettingsKeyClass))

typedef struct _GSettingsKey GSettingsKey;
typedef struct _GSettingsKeyClass GSettingsKeyClass;

#define TYPE_KEY_LIST_BOX_ROW_EDITABLE (key_list_box_row_editable_get_type ())
#define KEY_LIST_BOX_ROW_EDITABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE, KeyListBoxRowEditable))
#define KEY_LIST_BOX_ROW_EDITABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE, KeyListBoxRowEditableClass))
#define IS_KEY_LIST_BOX_ROW_EDITABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE))
#define IS_KEY_LIST_BOX_ROW_EDITABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE))
#define KEY_LIST_BOX_ROW_EDITABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE, KeyListBoxRowEditableClass))

typedef struct _KeyListBoxRowEditable KeyListBoxRowEditable;
typedef struct _KeyListBoxRowEditableClass KeyListBoxRowEditableClass;

#define TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA (key_list_box_row_editable_no_schema_get_type ())
#define KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA, KeyListBoxRowEditableNoSchema))
#define KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA, KeyListBoxRowEditableNoSchemaClass))
#define IS_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA))
#define IS_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA))
#define KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA, KeyListBoxRowEditableNoSchemaClass))

typedef struct _KeyListBoxRowEditableNoSchema KeyListBoxRowEditableNoSchema;
typedef struct _KeyListBoxRowEditableNoSchemaClass KeyListBoxRowEditableNoSchemaClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PathElementIface {
	GTypeInterface parent_iface;
};

struct _RegistryView {
	GtkGrid parent_instance;
	RegistryViewPrivate * priv;
};

struct _RegistryViewClass {
	GtkGridClass parent_class;
};

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _RegistryViewPrivate {
	gchar* _current_path;
	gboolean _show_search_bar;
	Behaviour _behaviour;
	GSettings* application_settings;
	GtkRevealer* need_reload_warning_revealer;
	SettingsModel* model;
	GtkTreeView* dir_tree_view;
	GtkTreeSelection* dir_tree_selection;
	GtkStack* stack;
	RegistryInfo* properties_view;
	GtkListBox* key_list_box;
	GListStore* key_model;
	GListStore* rows_possibly_with_popover;
	ModificationsRevealer* revealer;
	GtkSearchBar* search_bar;
	GtkSearchEntry* search_entry;
	GtkButton* search_next_button;
};

struct _Block22Data {
	int _ref_count_;
	RegistryView* self;
	ClickableListBoxRow* row;
	SettingObject* setting_object;
	gulong on_delete_call_handler;
	gulong on_row_clicked_handler;
	gulong button_press_event_handler;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	Key* key;
	KeyListBoxRow* key_row;
	gulong set_key_value_handler;
	gulong change_dismissed_handler;
	gulong key_planned_change_handler;
	gulong key_planned_value_handler;
};

struct _Block24Data {
	int _ref_count_;
	RegistryView* self;
	gulong revealer_reload_handler;
	GtkEntryBuffer* buffer;
	gulong search_entry_buffer_deleted_text_handler;
};


static gpointer registry_view_parent_class = NULL;
static PathElementIface * registry_view_path_element_parent_iface = NULL;

GType path_element_get_type (void) G_GNUC_CONST;
GType registry_view_get_type (void) G_GNUC_CONST;
GType behaviour_get_type (void) G_GNUC_CONST;
GType settings_model_get_type (void) G_GNUC_CONST;
GType registry_info_get_type (void) G_GNUC_CONST;
GType modifications_revealer_get_type (void) G_GNUC_CONST;
#define REGISTRY_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_REGISTRY_VIEW, RegistryViewPrivate))
SettingsModel* settings_model_new (void);
SettingsModel* settings_model_construct (GType object_type);
GType clickable_list_box_row_get_type (void) G_GNUC_CONST;
void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view);
static void registry_view_set_current_path (RegistryView* self, const gchar* value);
void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected);
const gchar* registry_view_get_current_path (RegistryView* self);
static void __lambda57_ (RegistryView* self);
GType setting_object_get_type (void) G_GNUC_CONST;
GType directory_get_type (void) G_GNUC_CONST;
static Directory* registry_view_get_selected_directory (RegistryView* self);
gboolean directory_need_sorting (Directory* self, gboolean case_sensitive);
static void ___lambda57__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void registry_view_show_browse_view (RegistryView* self, const gchar* path, const gchar* selected, gboolean grab);
static void registry_view_update_current_path (RegistryView* self, const gchar* path);
static gint registry_view_get_row_position (RegistryView* self, const gchar* selected);
static void registry_view_scroll_to_row (RegistryView* self, GtkListBoxRow* row, gboolean grab);
void registry_info_clean (RegistryInfo* self);
const gchar* setting_object_get_full_name (SettingObject* self);
static void registry_view_show_properties_view (RegistryView* self, const gchar* path);
void modifications_revealer_path_changed (ModificationsRevealer* self);
GType dconf_window_get_type (void) G_GNUC_CONST;
static DConfWindow* registry_view_get_dconf_window (RegistryView* self);
void dconf_window_update_path_elements (DConfWindow* self);
void registry_view_invalidate_popovers (RegistryView* self);
static void registry_view_dir_selected_cb (RegistryView* self);
void directory_sort_key_model (Directory* self, gboolean case_sensitive);
GListStore* directory_get_key_model (Directory* self);
static GtkWidget* registry_view_new_list_box_row (RegistryView* self, GObject* item);
static GtkWidget* _registry_view_new_list_box_row_gtk_list_box_create_widget_func (GObject* item, gpointer self);
static void _registry_view_dir_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
Directory* settings_model_get_directory (SettingsModel* self, GtkTreeIter* iter);
Directory* settings_model_get_root_directory (SettingsModel* self);
gchar* dconf_window_stripped_path (const gchar* path);
static gboolean registry_view_select_folder (RegistryView* self, const gchar* full_name);
void dconf_window_show_notification (DConfWindow* self, const gchar* notification);
GType key_get_type (void) G_GNUC_CONST;
static Key* registry_view_get_key_from_name (RegistryView* self, const gchar* key_name);
GType dconf_key_get_type (void) G_GNUC_CONST;
gboolean dconf_key_get_is_ghost (DConfKey* self);
void registry_info_populate_properties_list_box (RegistryInfo* self, Key* key);
static gboolean registry_view_get_next_iter (RegistryView* self, GtkTreeIter* iter);
const gchar* setting_object_get_name (SettingObject* self);
GtkWidget* _dconf_window_get_parent (GtkWidget* widget);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
FolderListBoxRow* folder_list_box_row_new (const gchar* label, const gchar* path);
FolderListBoxRow* folder_list_box_row_construct (GType object_type, const gchar* label, const gchar* path);
GType folder_list_box_row_get_type (void) G_GNUC_CONST;
static void ___lambda60_ (Block22Data* _data22_);
static void registry_view_reset_objects (RegistryView* self, GListStore* objects, gboolean recursively);
static void ____lambda60__clickable_list_box_row_on_delete_call (ClickableListBoxRow* _sender, gpointer self);
GType key_list_box_row_get_type (void) G_GNUC_CONST;
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
GType gsettings_key_get_type (void) G_GNUC_CONST;
KeyListBoxRowEditable* key_list_box_row_editable_new (GSettingsKey* _key);
KeyListBoxRowEditable* key_list_box_row_editable_construct (GType object_type, GSettingsKey* _key);
GType key_list_box_row_editable_get_type (void) G_GNUC_CONST;
KeyListBoxRowEditableNoSchema* key_list_box_row_editable_no_schema_new (DConfKey* _key);
KeyListBoxRowEditableNoSchema* key_list_box_row_editable_no_schema_construct (GType object_type, DConfKey* _key);
GType key_list_box_row_editable_no_schema_get_type (void) G_GNUC_CONST;
static void ___lambda79_ (Block23Data* _data23_);
static void registry_view_set_key_value (RegistryView* self, Key* key, GVariant* new_value);
static void ____lambda79__clickable_list_box_row_on_delete_call (ClickableListBoxRow* _sender, gpointer self);
static void ___lambda80_ (Block23Data* _data23_, GVariant* variant);
static void registry_view_set_delayed_icon (RegistryView* self, ClickableListBoxRow* row, Key* key);
static void ____lambda80__key_list_box_row_set_key_value (KeyListBoxRow* _sender, GVariant* new_value, gpointer self);
static void ___lambda81_ (Block23Data* _data23_);
void modifications_revealer_dismiss_change (ModificationsRevealer* self, Key* key);
static void ____lambda81__key_list_box_row_change_dismissed (KeyListBoxRow* _sender, gpointer self);
static void ___lambda82_ (Block23Data* _data23_);
static void ____lambda82__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda83_ (Block23Data* _data23_);
static void ____lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda84_ (Block23Data* _data23_);
static void ____lambda84__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void __lambda85_ (Block22Data* _data22_);
static void ___lambda85__clickable_list_box_row_on_row_clicked (ClickableListBoxRow* _sender, gpointer self);
static gboolean registry_view_on_button_pressed (RegistryView* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _registry_view_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda86_ (Block22Data* _data22_);
static void ___lambda86__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gboolean key_get_planned_change (Key* self);
GVariant* key_get_planned_value (Key* self);
void clickable_list_box_row_show_right_click_popover (ClickableListBoxRow* self, gboolean delayed_apply_menu, gint event_x);
gboolean registry_view_get_current_delay_mode (RegistryView* self);
static void registry_view_row_activated_cb (RegistryView* self, GtkListBoxRow* list_box_row);
static void _registry_view_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void clickable_list_box_row_destroy_popover (ClickableListBoxRow* self);
void dconf_window_update_hamburger_menu (DConfWindow* self);
static void registry_view_reload (RegistryView* self);
static gboolean registry_view_is_not_browsing_view (RegistryView* self);
static void _registry_view_reload_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean modifications_revealer_get_current_delay_mode (ModificationsRevealer* self);
void registry_view_enter_delay_mode (RegistryView* self);
void modifications_revealer_enter_delay_mode (ModificationsRevealer* self);
void modifications_revealer_add_delayed_setting (ModificationsRevealer* self, Key* key, GVariant* new_value);
void key_set_value (Key* self, GVariant* value);
void gsettings_key_set_to_default (GSettingsKey* self);
Behaviour registry_view_get_behaviour (RegistryView* self);
void dconf_key_erase (DConfKey* self);
void registry_view_reset (RegistryView* self, gboolean recursively);
static void registry_view_reset_generic (RegistryView* self, GListStore* objects, gboolean recursively);
void modifications_revealer_warn_if_no_planned_changes (ModificationsRevealer* self);
gboolean gsettings_key_get_is_default (GSettingsKey* self);
void registry_view_set_search_mode (RegistryView* self, gboolean* mode);
gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event);
gboolean registry_view_show_row_popover (RegistryView* self);
static GtkListBoxRow* registry_view_get_key_row (RegistryView* self);
gchar* registry_view_get_copy_text (RegistryView* self);
gchar* registry_info_get_copy_text (RegistryInfo* self);
gchar* clickable_list_box_row_get_text (ClickableListBoxRow* self);
void registry_view_toggle_boolean_key (RegistryView* self);
void key_list_box_row_toggle_boolean_key (KeyListBoxRow* self);
void registry_view_set_to_default (RegistryView* self);
void registry_view_discard_row_popover (RegistryView* self);
void clickable_list_box_row_hide_right_click_popover (ClickableListBoxRow* self);
static void registry_view_find_next_cb (RegistryView* self);
static gboolean registry_view_key_matches (RegistryView* self, Key* key, const gchar* text);
static void _registry_view_find_next_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean gsettings_key_search_for (GSettingsKey* self, const gchar* text);
GVariant* key_get_value (Key* self);
RegistryView* registry_view_new (void);
RegistryView* registry_view_construct (GType object_type);
gboolean registry_view_get_show_search_bar (RegistryView* self);
void registry_view_set_show_search_bar (RegistryView* self, gboolean value);
void registry_view_set_behaviour (RegistryView* self, Behaviour value);
static GObject * registry_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void _registry_view_invalidate_popovers_modifications_revealer_reload (ModificationsRevealer* _sender, gpointer self);
static void _registry_view___lambda87_ (RegistryView* self);
static void __registry_view___lambda87__gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self);
static void _registry_view___lambda88_ (Block24Data* _data24_);
static void __registry_view___lambda88__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void registry_view_finalize (GObject * obj);
static void _vala_registry_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_registry_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void __lambda57_ (RegistryView* self) {
	Directory* _tmp0_;
	Directory* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = registry_view_get_selected_directory (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->application_settings;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "sort-case-sensitive");
	_tmp4_ = directory_need_sorting (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	if (_tmp5_) {
		GtkRevealer* _tmp6_;
		_tmp6_ = self->priv->need_reload_warning_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, TRUE);
	}
}


static void ___lambda57__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda57_ ((RegistryView*) self);
}


void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view) {
	GtkTreeView* _tmp0_;
	SettingsModel* _tmp1_;
	GtkTreeView* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	const gchar* _tmp11_;
	GSettings* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->dir_tree_view;
	_tmp1_ = self->priv->model;
	gtk_tree_view_set_model (_tmp0_, (GtkTreeModel*) _tmp1_);
	_tmp2_ = self->priv->dir_tree_view;
	gtk_tree_view_expand_all (_tmp2_);
	_tmp6_ = restore_view;
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		gchar _tmp9_;
		_tmp8_ = path;
		_tmp9_ = string_get (_tmp8_, (glong) 0);
		_tmp4_ = _tmp9_ == '/';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp10_;
		_tmp10_ = path;
		_tmp3_ = _tmp10_;
	} else {
		_tmp3_ = "/";
	}
	registry_view_set_current_path (self, _tmp3_);
	_tmp11_ = self->priv->_current_path;
	registry_view_path_requested (self, _tmp11_, NULL);
	_tmp12_ = self->priv->application_settings;
	g_signal_connect_object (_tmp12_, "changed::sort-case-sensitive", (GCallback) ___lambda57__g_settings_changed, self, 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void registry_view_show_browse_view (RegistryView* self, const gchar* path, const gchar* selected, gboolean grab) {
	GtkStackTransitionType _tmp0_ = 0;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	GtkStack* _tmp4_;
	GtkRevealer* _tmp5_;
	const gchar* _tmp6_;
	GtkStack* _tmp7_;
	const gchar* _tmp8_;
	RegistryInfo* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp1_ = self->priv->_current_path;
	_tmp2_ = path;
	_tmp3_ = g_str_has_prefix (_tmp1_, _tmp2_);
	if (_tmp3_) {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
	} else {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_NONE;
	}
	_tmp4_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp4_, _tmp0_);
	_tmp5_ = self->priv->need_reload_warning_revealer;
	gtk_revealer_set_reveal_child (_tmp5_, FALSE);
	_tmp6_ = path;
	registry_view_update_current_path (self, _tmp6_);
	_tmp7_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp7_, "browse-view");
	_tmp8_ = selected;
	if (_tmp8_ != NULL) {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		GtkListBoxRow* _tmp12_;
		GtkListBoxRow* _tmp13_;
		GtkListBoxRow* _tmp14_;
		GtkListBoxRow* _tmp15_;
		gboolean _tmp16_;
		gtk_container_check_resize ((GtkContainer*) self);
		_tmp9_ = self->priv->key_list_box;
		_tmp10_ = selected;
		_tmp11_ = registry_view_get_row_position (self, (const gchar*) _tmp10_);
		_tmp12_ = gtk_list_box_get_row_at_index (_tmp9_, _tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		row = _tmp13_;
		_tmp14_ = row;
		if (_tmp14_ == NULL) {
			g_assert_not_reached ();
		}
		_tmp15_ = row;
		_tmp16_ = grab;
		registry_view_scroll_to_row (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp16_);
		_g_object_unref0 (row);
	} else {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp17_;
		GtkListBoxRow* _tmp18_;
		GtkListBoxRow* _tmp19_;
		GtkListBoxRow* _tmp20_;
		_tmp17_ = self->priv->key_list_box;
		_tmp18_ = gtk_list_box_get_row_at_index (_tmp17_, 0);
		_tmp19_ = _g_object_ref0 (_tmp18_);
		row = _tmp19_;
		_tmp20_ = row;
		if (_tmp20_ != NULL) {
			GtkListBoxRow* _tmp21_;
			gboolean _tmp22_;
			_tmp21_ = row;
			_tmp22_ = grab;
			registry_view_scroll_to_row (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp22_);
		}
		_g_object_unref0 (row);
	}
	_tmp23_ = self->priv->properties_view;
	registry_info_clean (_tmp23_);
}


static gint registry_view_get_row_position (RegistryView* self, const gchar* selected) {
	gint result = 0;
	GListStore* _tmp0_;
	guint position = 0U;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (selected != NULL, 0);
	_tmp0_ = self->priv->key_model;
	_vala_return_val_if_fail (_tmp0_ != NULL, "key_model != null", 0);
	position = (guint) 0;
	while (TRUE) {
		guint _tmp1_;
		GListStore* _tmp2_;
		guint _tmp3_;
		SettingObject* object = NULL;
		GListStore* _tmp4_;
		guint _tmp5_;
		GObject* _tmp6_;
		SettingObject* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		guint _tmp12_;
		_tmp1_ = position;
		_tmp2_ = self->priv->key_model;
		_tmp3_ = g_list_model_get_n_items ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_store_get_type (), GListStore));
		if (!(_tmp1_ < _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->key_model;
		_tmp5_ = position;
		_tmp6_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_store_get_type (), GListStore), _tmp5_);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp7_ = object;
		_tmp8_ = setting_object_get_full_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = selected;
		if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
			guint _tmp11_;
			_tmp11_ = position;
			result = (gint) _tmp11_;
			_g_object_unref0 (object);
			return result;
		}
		_tmp12_ = position;
		position = _tmp12_ + 1;
		_g_object_unref0 (object);
	}
	g_assert_not_reached ();
}


static void registry_view_scroll_to_row (RegistryView* self, GtkListBoxRow* row, gboolean grab) {
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	gboolean _tmp2_;
	GtkAllocation list_allocation = {0};
	GtkAllocation row_allocation = {0};
	GtkStack* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	GtkListBoxRow* _tmp6_;
	GtkAllocation _tmp7_ = {0};
	GtkListBox* _tmp8_;
	GtkAdjustment* _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	GtkAllocation _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->key_list_box;
	_tmp1_ = row;
	gtk_list_box_select_row (_tmp0_, _tmp1_);
	_tmp2_ = grab;
	if (_tmp2_) {
		GtkListBoxRow* _tmp3_;
		_tmp3_ = row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	}
	_tmp4_ = self->priv->stack;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	list_allocation = _tmp5_;
	_tmp6_ = row;
	gtk_widget_get_allocation ((GtkWidget*) _tmp6_, &_tmp7_);
	row_allocation = _tmp7_;
	_tmp8_ = self->priv->key_list_box;
	_tmp9_ = gtk_list_box_get_adjustment (_tmp8_);
	_tmp10_ = row_allocation;
	_tmp11_ = _tmp10_.y;
	_tmp12_ = row_allocation;
	_tmp13_ = _tmp12_.height;
	_tmp14_ = list_allocation;
	_tmp15_ = _tmp14_.height;
	gtk_adjustment_set_value (_tmp9_, (gdouble) (_tmp11_ + ((gint) ((_tmp13_ - _tmp15_) / 2.0))));
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void registry_view_show_properties_view (RegistryView* self, const gchar* path) {
	GtkStackTransitionType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	GtkStack* _tmp10_;
	const gchar* _tmp11_;
	GtkStack* _tmp12_;
	RegistryInfo* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp2_ = path;
	_tmp3_ = self->priv->_current_path;
	_tmp4_ = g_str_has_prefix (_tmp2_, _tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		_tmp5_ = self->priv->_current_path;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = path;
		_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '/', 0);
		_tmp1_ = _tmp7_ == (_tmp9_ + 1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
	} else {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_NONE;
	}
	_tmp10_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp10_, _tmp0_);
	_tmp11_ = path;
	registry_view_update_current_path (self, _tmp11_);
	_tmp12_ = self->priv->stack;
	_tmp13_ = self->priv->properties_view;
	gtk_stack_set_visible_child (_tmp12_, (GtkWidget*) _tmp13_);
}


static void registry_view_update_current_path (RegistryView* self, const gchar* path) {
	ModificationsRevealer* _tmp0_;
	const gchar* _tmp1_;
	DConfWindow* _tmp2_;
	DConfWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->revealer;
	modifications_revealer_path_changed (_tmp0_);
	_tmp1_ = path;
	registry_view_set_current_path (self, _tmp1_);
	_tmp2_ = registry_view_get_dconf_window (self);
	_tmp3_ = _tmp2_;
	dconf_window_update_path_elements (_tmp3_);
	_g_object_unref0 (_tmp3_);
	registry_view_invalidate_popovers (self);
}


static GtkWidget* _registry_view_new_list_box_row_gtk_list_box_create_widget_func (GObject* item, gpointer self) {
	GtkWidget* result;
	result = registry_view_new_list_box_row ((RegistryView*) self, item);
	return result;
}


static void registry_view_dir_selected_cb (RegistryView* self) {
	GtkButton* _tmp0_;
	Directory* dir = NULL;
	Directory* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	GListStore* _tmp6_;
	GtkListBox* _tmp7_;
	GListStore* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = registry_view_get_selected_directory (self);
	dir = _tmp1_;
	_tmp2_ = self->priv->application_settings;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "sort-case-sensitive");
	directory_sort_key_model (dir, _tmp3_);
	_tmp4_ = directory_get_key_model (dir);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->key_model);
	self->priv->key_model = _tmp6_;
	_tmp7_ = self->priv->key_list_box;
	_tmp8_ = self->priv->key_model;
	gtk_list_box_bind_model (_tmp7_, (GListModel*) _tmp8_, _registry_view_new_list_box_row_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (dir);
}


static void _registry_view_dir_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	registry_view_dir_selected_cb ((RegistryView*) self);
}


static Directory* registry_view_get_selected_directory (RegistryView* self) {
	Directory* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dir_tree_selection;
	_tmp2_ = gtk_tree_selection_get_selected (_tmp0_, NULL, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		SettingsModel* _tmp3_;
		GtkTreeIter _tmp4_;
		Directory* _tmp5_;
		_tmp3_ = self->priv->model;
		_tmp4_ = iter;
		_tmp5_ = settings_model_get_directory (_tmp3_, &_tmp4_);
		result = _tmp5_;
		return result;
	} else {
		SettingsModel* _tmp6_;
		Directory* _tmp7_;
		_tmp6_ = self->priv->model;
		_tmp7_ = settings_model_get_root_directory (_tmp6_);
		result = _tmp7_;
		return result;
	}
}


void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected) {
	gchar* full_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* folder_name = NULL;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar** names = NULL;
	const gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint names_length1;
	gint _names_size_;
	gchar* key_name = NULL;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	Key* key = NULL;
	const gchar* _tmp26_;
	Key* _tmp27_;
	Key* _tmp28_;
	gboolean _tmp35_ = FALSE;
	Key* _tmp36_;
	RegistryInfo* _tmp50_;
	Key* _tmp51_;
	const gchar* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_full_name != NULL);
	_tmp0_ = _full_name;
	_tmp1_ = g_strdup (_tmp0_);
	full_name = _tmp1_;
	_tmp2_ = full_name;
	_tmp3_ = g_str_has_suffix (_tmp2_, "/");
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = full_name;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (folder_name);
		folder_name = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = full_name;
		_tmp7_ = dconf_window_stripped_path (_tmp6_);
		_g_free0 (folder_name);
		folder_name = _tmp7_;
	}
	_tmp8_ = folder_name;
	_tmp9_ = registry_view_select_folder (self, _tmp8_);
	if (!_tmp9_) {
		DConfWindow* _tmp10_;
		DConfWindow* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = registry_view_get_dconf_window (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = folder_name;
		_tmp13_ = g_strdup_printf (_ ("Cannot find folder “%s”."), _tmp12_);
		_tmp14_ = _tmp13_;
		dconf_window_show_notification (_tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (_tmp11_);
		registry_view_set_current_path (self, "/");
		registry_view_show_browse_view (self, "/", NULL, TRUE);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp15_ = full_name;
	_tmp16_ = folder_name;
	if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = full_name;
		_tmp18_ = selected;
		registry_view_show_browse_view (self, _tmp17_, _tmp18_, TRUE);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp19_ = full_name;
	_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, "/", 0);
	names = _tmp21_;
	names_length1 = _vala_array_length (_tmp20_);
	_names_size_ = names_length1;
	_tmp22_ = names;
	_tmp22__length1 = names_length1;
	_tmp23_ = names;
	_tmp23__length1 = names_length1;
	_tmp24_ = _tmp22_[_tmp23__length1 - 1];
	_tmp25_ = g_strdup (_tmp24_);
	key_name = _tmp25_;
	_tmp26_ = key_name;
	_tmp27_ = registry_view_get_key_from_name (self, _tmp26_);
	key = _tmp27_;
	_tmp28_ = key;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_;
		DConfWindow* _tmp30_;
		DConfWindow* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp29_ = folder_name;
		registry_view_show_browse_view (self, _tmp29_, NULL, TRUE);
		_tmp30_ = registry_view_get_dconf_window (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = key_name;
		_tmp33_ = g_strdup_printf (_ ("Cannot find key “%s” here."), _tmp32_);
		_tmp34_ = _tmp33_;
		dconf_window_show_notification (_tmp31_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_object_unref0 (_tmp31_);
		_g_object_unref0 (key);
		_g_free0 (key_name);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp36_ = key;
	if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TYPE_KEY, Key), TYPE_DCONF_KEY)) {
		Key* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp37_ = key;
		_tmp38_ = dconf_key_get_is_ghost (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_KEY, Key), TYPE_DCONF_KEY, DConfKey));
		_tmp39_ = _tmp38_;
		_tmp35_ = _tmp39_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		DConfWindow* _tmp45_;
		DConfWindow* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp40_ = folder_name;
		_tmp41_ = folder_name;
		_tmp42_ = key_name;
		_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		registry_view_show_browse_view (self, _tmp40_, _tmp44_, TRUE);
		_g_free0 (_tmp44_);
		_tmp45_ = registry_view_get_dconf_window (self);
		_tmp46_ = _tmp45_;
		_tmp47_ = key_name;
		_tmp48_ = g_strdup_printf (_ ("Key “%s” has been removed."), _tmp47_);
		_tmp49_ = _tmp48_;
		dconf_window_show_notification (_tmp46_, _tmp49_);
		_g_free0 (_tmp49_);
		_g_object_unref0 (_tmp46_);
		_g_object_unref0 (key);
		_g_free0 (key_name);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp50_ = self->priv->properties_view;
	_tmp51_ = key;
	registry_info_populate_properties_list_box (_tmp50_, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_KEY, Key));
	_tmp52_ = full_name;
	registry_view_show_properties_view (self, _tmp52_);
	_g_object_unref0 (key);
	_g_free0 (key_name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (folder_name);
	_g_free0 (full_name);
}


static gboolean registry_view_select_folder (RegistryView* self, const gchar* full_name) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GtkTreeIter iter = {0};
	Directory* dir = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	SettingsModel* _tmp12_;
	GtkTreeIter _tmp13_ = {0};
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (full_name != NULL, FALSE);
	_tmp0_ = full_name;
	if (g_strcmp0 (_tmp0_, "/") == 0) {
		GtkTreeSelection* _tmp1_;
		_tmp1_ = self->priv->dir_tree_selection;
		gtk_tree_selection_unselect_all (_tmp1_);
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->dir_tree_selection;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		SettingsModel* _tmp5_;
		GtkTreeIter _tmp6_;
		Directory* _tmp7_;
		Directory* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = self->priv->model;
		_tmp6_ = iter;
		_tmp7_ = settings_model_get_directory (_tmp5_, &_tmp6_);
		_g_object_unref0 (dir);
		dir = _tmp7_;
		_tmp8_ = dir;
		_tmp9_ = setting_object_get_full_name ((SettingObject*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = full_name;
		if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
			result = TRUE;
			_g_object_unref0 (dir);
			return result;
		}
	}
	_tmp12_ = self->priv->model;
	_tmp14_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp12_, &_tmp13_);
	iter = _tmp13_;
	if (_tmp14_) {
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				SettingsModel* _tmp17_;
				GtkTreeIter _tmp18_;
				Directory* _tmp19_;
				Directory* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				if (!_tmp15_) {
					gboolean _tmp16_;
					_tmp16_ = registry_view_get_next_iter (self, &iter);
					if (!_tmp16_) {
						break;
					}
				}
				_tmp15_ = FALSE;
				_tmp17_ = self->priv->model;
				_tmp18_ = iter;
				_tmp19_ = settings_model_get_directory (_tmp17_, &_tmp18_);
				_g_object_unref0 (dir);
				dir = _tmp19_;
				_tmp20_ = dir;
				_tmp21_ = setting_object_get_full_name ((SettingObject*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = full_name;
				if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
					GtkTreeSelection* _tmp24_;
					GtkTreeIter _tmp25_;
					_tmp24_ = self->priv->dir_tree_selection;
					_tmp25_ = iter;
					gtk_tree_selection_select_iter (_tmp24_, &_tmp25_);
					result = TRUE;
					_g_object_unref0 (dir);
					return result;
				}
			}
		}
	} else {
		g_assert_not_reached ();
	}
	result = FALSE;
	_g_object_unref0 (dir);
	return result;
}


static Key* registry_view_get_key_from_name (RegistryView* self, const gchar* key_name) {
	Key* result = NULL;
	GListStore* _tmp0_;
	guint position = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_name != NULL, NULL);
	_tmp0_ = self->priv->key_model;
	_vala_return_val_if_fail (_tmp0_ != NULL, "key_model != null", NULL);
	position = (guint) 0;
	while (TRUE) {
		guint _tmp1_;
		GListStore* _tmp2_;
		guint _tmp3_;
		SettingObject* object = NULL;
		GListStore* _tmp4_;
		guint _tmp5_;
		GObject* _tmp6_;
		gboolean _tmp7_ = FALSE;
		SettingObject* _tmp8_;
		guint _tmp15_;
		_tmp1_ = position;
		_tmp2_ = self->priv->key_model;
		_tmp3_ = g_list_model_get_n_items ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_store_get_type (), GListStore));
		if (!(_tmp1_ < _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->key_model;
		_tmp5_ = position;
		_tmp6_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_store_get_type (), GListStore), _tmp5_);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp8_ = object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_KEY)) {
			SettingObject* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp9_ = object;
			_tmp10_ = setting_object_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = key_name;
			_tmp7_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			SettingObject* _tmp13_;
			Key* _tmp14_;
			_tmp13_ = object;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_KEY, Key));
			result = _tmp14_;
			_g_object_unref0 (object);
			return result;
		}
		_tmp15_ = position;
		position = _tmp15_ + 1;
		_g_object_unref0 (object);
	}
	result = NULL;
	return result;
}


static DConfWindow* registry_view_get_dconf_window (RegistryView* self) {
	DConfWindow* result = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	DConfWindow* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _dconf_window_get_parent ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _dconf_window_get_parent (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DCONF_WINDOW, DConfWindow);
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		RegistryView* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->setting_object);
		_g_object_unref0 (_data22_->row);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static void ___lambda60_ (Block22Data* _data22_) {
	RegistryView* self;
	SettingObject* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	self = _data22_->self;
	_tmp0_ = _data22_->setting_object;
	_tmp1_ = directory_get_key_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DIRECTORY, Directory));
	_tmp2_ = _tmp1_;
	registry_view_reset_objects (self, _tmp2_, TRUE);
}


static void ____lambda60__clickable_list_box_row_on_delete_call (ClickableListBoxRow* _sender, gpointer self) {
	___lambda60_ (self);
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		RegistryView* self;
		self = _data23_->_data22_->self;
		_g_object_unref0 (_data23_->key_row);
		_g_object_unref0 (_data23_->key);
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}


static void ___lambda79_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	Key* _tmp0_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data23_->key;
	registry_view_set_key_value (self, _tmp0_, NULL);
}


static void ____lambda79__clickable_list_box_row_on_delete_call (ClickableListBoxRow* _sender, gpointer self) {
	___lambda79_ (self);
}


static void ___lambda80_ (Block23Data* _data23_, GVariant* variant) {
	Block22Data* _data22_;
	RegistryView* self;
	Key* _tmp0_;
	GVariant* _tmp1_;
	ClickableListBoxRow* _tmp2_;
	Key* _tmp3_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data23_->key;
	_tmp1_ = variant;
	registry_view_set_key_value (self, _tmp0_, _tmp1_);
	_tmp2_ = _data22_->row;
	_tmp3_ = _data23_->key;
	registry_view_set_delayed_icon (self, _tmp2_, _tmp3_);
}


static void ____lambda80__key_list_box_row_set_key_value (KeyListBoxRow* _sender, GVariant* new_value, gpointer self) {
	___lambda80_ (self, new_value);
}


static void ___lambda81_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	ModificationsRevealer* _tmp0_;
	Key* _tmp1_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = self->priv->revealer;
	_tmp1_ = _data23_->key;
	modifications_revealer_dismiss_change (_tmp0_, _tmp1_);
}


static void ____lambda81__key_list_box_row_change_dismissed (KeyListBoxRow* _sender, gpointer self) {
	___lambda81_ (self);
}


static void ___lambda82_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	ClickableListBoxRow* _tmp0_;
	Key* _tmp1_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data22_->row;
	_tmp1_ = _data23_->key;
	registry_view_set_delayed_icon (self, _tmp0_, _tmp1_);
}


static void ____lambda82__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda82_ (self);
}


static void ___lambda83_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	ClickableListBoxRow* _tmp0_;
	Key* _tmp1_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data22_->row;
	_tmp1_ = _data23_->key;
	registry_view_set_delayed_icon (self, _tmp0_, _tmp1_);
}


static void ____lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda83_ (self);
}


static void ___lambda84_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	KeyListBoxRow* _tmp0_;
	gulong _tmp1_;
	KeyListBoxRow* _tmp2_;
	gulong _tmp3_;
	Key* _tmp4_;
	gulong _tmp5_;
	Key* _tmp6_;
	gulong _tmp7_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data23_->key_row;
	_tmp1_ = _data23_->set_key_value_handler;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data23_->key_row;
	_tmp3_ = _data23_->change_dismissed_handler;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _tmp3_);
	_tmp4_ = _data23_->key;
	_tmp5_ = _data23_->key_planned_change_handler;
	g_signal_handler_disconnect ((GObject*) _tmp4_, _tmp5_);
	_tmp6_ = _data23_->key;
	_tmp7_ = _data23_->key_planned_value_handler;
	g_signal_handler_disconnect ((GObject*) _tmp6_, _tmp7_);
}


static void ____lambda84__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda84_ (self);
}


static void __lambda85_ (Block22Data* _data22_) {
	RegistryView* self;
	SettingObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data22_->self;
	_tmp0_ = _data22_->setting_object;
	_tmp1_ = setting_object_get_full_name (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((PathElement*) self, "request-path", _tmp2_);
}


static void ___lambda85__clickable_list_box_row_on_row_clicked (ClickableListBoxRow* _sender, gpointer self) {
	__lambda85_ (self);
}


static gboolean _registry_view_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = registry_view_on_button_pressed ((RegistryView*) self, _sender, event);
	return result;
}


static void __lambda86_ (Block22Data* _data22_) {
	RegistryView* self;
	ClickableListBoxRow* _tmp0_;
	gulong _tmp1_;
	ClickableListBoxRow* _tmp2_;
	ClickableListBoxRow* _tmp3_;
	self = _data22_->self;
	_tmp0_ = _data22_->row;
	_tmp1_ = _data22_->on_delete_call_handler;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data22_->row;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _data22_->on_row_clicked_handler);
	_tmp3_ = _data22_->row;
	g_signal_handler_disconnect ((GObject*) _tmp3_, _data22_->button_press_event_handler);
}


static void ___lambda86__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda86_ (self);
}


static GtkWidget* registry_view_new_list_box_row (RegistryView* self, GObject* item) {
	GtkWidget* result = NULL;
	Block22Data* _data22_;
	GObject* _tmp0_;
	SettingObject* _tmp1_;
	SettingObject* _tmp2_;
	ClickableListBoxRow* _tmp34_;
	gulong _tmp35_;
	ClickableListBoxRow* _tmp36_;
	gulong _tmp37_;
	ClickableListBoxRow* _tmp38_;
	ClickableListBoxRow* _tmp39_;
	GtkWidget* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SETTING_OBJECT, SettingObject));
	_data22_->setting_object = _tmp1_;
	_tmp2_ = _data22_->setting_object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DIRECTORY)) {
		SettingObject* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		SettingObject* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		FolderListBoxRow* _tmp9_;
		ClickableListBoxRow* _tmp10_;
		gulong _tmp11_;
		_tmp3_ = _data22_->setting_object;
		_tmp4_ = setting_object_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _data22_->setting_object;
		_tmp7_ = setting_object_get_full_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = folder_list_box_row_new (_tmp5_, _tmp8_);
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (_data22_->row);
		_data22_->row = (ClickableListBoxRow*) _tmp9_;
		_tmp10_ = _data22_->row;
		_tmp11_ = g_signal_connect_data (_tmp10_, "on-delete-call", (GCallback) ____lambda60__clickable_list_box_row_on_delete_call, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
		_data22_->on_delete_call_handler = _tmp11_;
	} else {
		Block23Data* _data23_;
		SettingObject* _tmp12_;
		SettingObject* _tmp17_;
		Key* _tmp18_;
		ClickableListBoxRow* _tmp19_;
		KeyListBoxRow* _tmp20_;
		ClickableListBoxRow* _tmp21_;
		gulong _tmp22_;
		KeyListBoxRow* _tmp23_;
		gulong _tmp24_;
		KeyListBoxRow* _tmp25_;
		gulong _tmp26_;
		Key* _tmp27_;
		gulong _tmp28_;
		Key* _tmp29_;
		gulong _tmp30_;
		ClickableListBoxRow* _tmp31_;
		Key* _tmp32_;
		ClickableListBoxRow* _tmp33_;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data22_ = block22_data_ref (_data22_);
		_tmp12_ = _data22_->setting_object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_GSETTINGS_KEY)) {
			SettingObject* _tmp13_;
			KeyListBoxRowEditable* _tmp14_;
			_tmp13_ = _data22_->setting_object;
			_tmp14_ = key_list_box_row_editable_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_GSETTINGS_KEY, GSettingsKey));
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (_data22_->row);
			_data22_->row = (ClickableListBoxRow*) _tmp14_;
		} else {
			SettingObject* _tmp15_;
			KeyListBoxRowEditableNoSchema* _tmp16_;
			_tmp15_ = _data22_->setting_object;
			_tmp16_ = key_list_box_row_editable_no_schema_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DCONF_KEY, DConfKey));
			g_object_ref_sink (_tmp16_);
			_g_object_unref0 (_data22_->row);
			_data22_->row = (ClickableListBoxRow*) _tmp16_;
		}
		_tmp17_ = _data22_->setting_object;
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_KEY, Key));
		_data23_->key = _tmp18_;
		_tmp19_ = _data22_->row;
		_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_KEY_LIST_BOX_ROW, KeyListBoxRow));
		_data23_->key_row = _tmp20_;
		_tmp21_ = _data22_->row;
		_tmp22_ = g_signal_connect_data (_tmp21_, "on-delete-call", (GCallback) ____lambda79__clickable_list_box_row_on_delete_call, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data22_->on_delete_call_handler = _tmp22_;
		_tmp23_ = _data23_->key_row;
		_tmp24_ = g_signal_connect_data (_tmp23_, "set-key-value", (GCallback) ____lambda80__key_list_box_row_set_key_value, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->set_key_value_handler = _tmp24_;
		_tmp25_ = _data23_->key_row;
		_tmp26_ = g_signal_connect_data (_tmp25_, "change-dismissed", (GCallback) ____lambda81__key_list_box_row_change_dismissed, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->change_dismissed_handler = _tmp26_;
		_tmp27_ = _data23_->key;
		_tmp28_ = g_signal_connect_data ((GObject*) _tmp27_, "notify::planned-change", (GCallback) ____lambda82__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->key_planned_change_handler = _tmp28_;
		_tmp29_ = _data23_->key;
		_tmp30_ = g_signal_connect_data ((GObject*) _tmp29_, "notify::planned-value", (GCallback) ____lambda83__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->key_planned_value_handler = _tmp30_;
		_tmp31_ = _data22_->row;
		_tmp32_ = _data23_->key;
		registry_view_set_delayed_icon (self, _tmp31_, _tmp32_);
		_tmp33_ = _data22_->row;
		g_signal_connect_data ((GtkWidget*) _tmp33_, "destroy", (GCallback) ____lambda84__gtk_widget_destroy, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		block23_data_unref (_data23_);
		_data23_ = NULL;
	}
	_tmp34_ = _data22_->row;
	_tmp35_ = g_signal_connect_data (_tmp34_, "on-row-clicked", (GCallback) ___lambda85__clickable_list_box_row_on_row_clicked, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_data22_->on_row_clicked_handler = _tmp35_;
	_tmp36_ = _data22_->row;
	_tmp37_ = g_signal_connect_object ((GtkWidget*) _tmp36_, "button-press-event", (GCallback) _registry_view_on_button_pressed_gtk_widget_button_press_event, self, 0);
	_data22_->button_press_event_handler = _tmp37_;
	_tmp38_ = _data22_->row;
	g_signal_connect_data ((GtkWidget*) _tmp38_, "destroy", (GCallback) ___lambda86__gtk_widget_destroy, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_tmp39_ = _data22_->row;
	_tmp40_ = _g_object_ref0 ((GtkWidget*) _tmp39_);
	result = _tmp40_;
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}


static void registry_view_set_delayed_icon (RegistryView* self, ClickableListBoxRow* row, Key* key) {
	Key* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = key_get_planned_change (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStyleContext* context = NULL;
		ClickableListBoxRow* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkStyleContext* _tmp6_;
		Key* _tmp7_;
		_tmp3_ = row;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		context = _tmp5_;
		_tmp6_ = context;
		gtk_style_context_add_class (_tmp6_, "delayed");
		_tmp7_ = key;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_DCONF_KEY)) {
			Key* _tmp8_;
			GVariant* _tmp9_;
			GVariant* _tmp10_;
			_tmp8_ = key;
			_tmp9_ = key_get_planned_value (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == NULL) {
				GtkStyleContext* _tmp11_;
				_tmp11_ = context;
				gtk_style_context_add_class (_tmp11_, "erase");
			} else {
				GtkStyleContext* _tmp12_;
				_tmp12_ = context;
				gtk_style_context_remove_class (_tmp12_, "erase");
			}
		}
		_g_object_unref0 (context);
	} else {
		ClickableListBoxRow* _tmp13_;
		GtkStyleContext* _tmp14_;
		_tmp13_ = row;
		_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
		gtk_style_context_remove_class (_tmp14_, "delayed");
	}
}


static gboolean registry_view_on_button_pressed (RegistryView* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkListBoxRow* list_box_row = NULL;
	GtkWidget* _tmp0_;
	GtkContainer* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GdkEventButton* _tmp6_;
	guint _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	_tmp1_ = (GtkContainer*) gtk_widget_get_parent (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_row_get_type (), GtkListBoxRow));
	list_box_row = _tmp2_;
	_tmp3_ = self->priv->key_list_box;
	_tmp4_ = list_box_row;
	gtk_list_box_select_row (_tmp3_, _tmp4_);
	_tmp5_ = list_box_row;
	gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	_tmp6_ = event;
	_tmp7_ = _tmp6_->button;
	if (_tmp7_ == ((guint) GDK_BUTTON_SECONDARY)) {
		ClickableListBoxRow* row = NULL;
		GtkWidget* _tmp8_;
		ClickableListBoxRow* _tmp9_;
		gint event_x = 0;
		GdkEventButton* _tmp10_;
		gdouble _tmp11_;
		GdkEventButton* _tmp12_;
		GdkWindow* _tmp13_;
		GtkWidget* _tmp14_;
		GdkWindow* _tmp15_;
		ClickableListBoxRow* _tmp22_;
		gboolean _tmp23_;
		gint _tmp24_;
		GListStore* _tmp25_;
		ClickableListBoxRow* _tmp26_;
		_tmp8_ = widget;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
		row = _tmp9_;
		_tmp10_ = event;
		_tmp11_ = _tmp10_->x;
		event_x = (gint) _tmp11_;
		_tmp12_ = event;
		_tmp13_ = _tmp12_->window;
		_tmp14_ = widget;
		_tmp15_ = gtk_widget_get_window (_tmp14_);
		if (_tmp13_ != _tmp15_) {
			gint widget_x = 0;
			gint unused = 0;
			GdkEventButton* _tmp16_;
			GdkWindow* _tmp17_;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_;
			gint _tmp21_;
			_tmp16_ = event;
			_tmp17_ = _tmp16_->window;
			gdk_window_get_position (_tmp17_, &_tmp18_, &_tmp19_);
			widget_x = _tmp18_;
			unused = _tmp19_;
			_tmp20_ = event_x;
			_tmp21_ = widget_x;
			event_x = _tmp20_ + _tmp21_;
		}
		_tmp22_ = row;
		_tmp23_ = registry_view_get_current_delay_mode (self);
		_tmp24_ = event_x;
		clickable_list_box_row_show_right_click_popover (_tmp22_, _tmp23_, _tmp24_);
		_tmp25_ = self->priv->rows_possibly_with_popover;
		_tmp26_ = row;
		g_list_store_append (_tmp25_, (GObject*) _tmp26_);
		_g_object_unref0 (row);
	}
	result = FALSE;
	_g_object_unref0 (list_box_row);
	return result;
}


static void registry_view_row_activated_cb (RegistryView* self, GtkListBoxRow* list_box_row) {
	GtkButton* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list_box_row != NULL);
	_tmp0_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = list_box_row;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow), "on-row-clicked");
}


static void _registry_view_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	registry_view_row_activated_cb ((RegistryView*) self, row);
}


void registry_view_invalidate_popovers (RegistryView* self) {
	guint position = 0U;
	ClickableListBoxRow* row = NULL;
	GListStore* _tmp0_;
	GObject* _tmp1_;
	GListStore* _tmp8_;
	DConfWindow* _tmp9_;
	DConfWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	position = (guint) 0;
	_tmp0_ = self->priv->rows_possibly_with_popover;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) 0);
	row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow);
	while (TRUE) {
		ClickableListBoxRow* _tmp2_;
		ClickableListBoxRow* _tmp3_;
		guint _tmp4_;
		GListStore* _tmp5_;
		guint _tmp6_;
		GObject* _tmp7_;
		_tmp2_ = row;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = row;
		clickable_list_box_row_destroy_popover (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
		_tmp4_ = position;
		position = _tmp4_ + 1;
		_tmp5_ = self->priv->rows_possibly_with_popover;
		_tmp6_ = position;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp5_, _tmp6_);
		_g_object_unref0 (row);
		row = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow);
	}
	_tmp8_ = self->priv->rows_possibly_with_popover;
	g_list_store_remove_all (_tmp8_);
	_tmp9_ = registry_view_get_dconf_window (self);
	_tmp10_ = _tmp9_;
	dconf_window_update_hamburger_menu (_tmp10_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (row);
}


static void registry_view_reload (RegistryView* self) {
	gboolean _tmp0_;
	GtkListBoxRow* selected_row = NULL;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	gchar* saved_selection = NULL;
	GtkListBoxRow* _tmp4_;
	Directory* _tmp14_;
	Directory* _tmp15_;
	GSettings* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = registry_view_is_not_browsing_view (self);
	_vala_return_if_fail (!_tmp0_, "!is_not_browsing_view ()");
	_tmp1_ = self->priv->key_list_box;
	_tmp2_ = gtk_list_box_get_selected_row (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	selected_row = _tmp3_;
	saved_selection = NULL;
	_tmp4_ = selected_row;
	if (_tmp4_ != NULL) {
		gint position = 0;
		GtkListBoxRow* _tmp5_;
		gint _tmp6_;
		GListStore* _tmp7_;
		gint _tmp8_;
		GObject* _tmp9_;
		SettingObject* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = selected_row;
		_tmp6_ = gtk_list_box_row_get_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_row_get_type (), GtkListBoxRow));
		position = _tmp6_;
		_tmp7_ = self->priv->key_model;
		_tmp8_ = position;
		_tmp9_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_list_store_get_type (), GListStore), (guint) _tmp8_);
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp11_ = setting_object_get_full_name (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (saved_selection);
		saved_selection = _tmp13_;
		_g_object_unref0 (_tmp10_);
	}
	_tmp14_ = registry_view_get_selected_directory (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->application_settings;
	_tmp17_ = g_settings_get_boolean (_tmp16_, "sort-case-sensitive");
	directory_sort_key_model (_tmp15_, _tmp17_);
	_g_object_unref0 (_tmp15_);
	_tmp18_ = self->priv->_current_path;
	_tmp19_ = saved_selection;
	registry_view_show_browse_view (self, _tmp18_, _tmp19_, TRUE);
	_g_free0 (saved_selection);
	_g_object_unref0 (selected_row);
}


static void _registry_view_reload_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	registry_view_reload ((RegistryView*) self);
}


gboolean registry_view_get_current_delay_mode (RegistryView* self) {
	gboolean result = FALSE;
	ModificationsRevealer* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = modifications_revealer_get_current_delay_mode (_tmp0_);
	result = _tmp1_;
	return result;
}


void registry_view_enter_delay_mode (RegistryView* self) {
	ModificationsRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	modifications_revealer_enter_delay_mode (_tmp0_);
	registry_view_invalidate_popovers (self);
}


static void registry_view_set_key_value (RegistryView* self, Key* key, GVariant* new_value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = registry_view_get_current_delay_mode (self);
	if (_tmp0_) {
		ModificationsRevealer* _tmp1_;
		Key* _tmp2_;
		GVariant* _tmp3_;
		_tmp1_ = self->priv->revealer;
		_tmp2_ = key;
		_tmp3_ = new_value;
		modifications_revealer_add_delayed_setting (_tmp1_, _tmp2_, _tmp3_);
	} else {
		GVariant* _tmp4_;
		_tmp4_ = new_value;
		if (_tmp4_ != NULL) {
			Key* _tmp5_;
			GVariant* _tmp6_;
			_tmp5_ = key;
			_tmp6_ = new_value;
			key_set_value (_tmp5_, (GVariant*) _tmp6_);
		} else {
			Key* _tmp7_;
			_tmp7_ = key;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_GSETTINGS_KEY)) {
				Key* _tmp8_;
				_tmp8_ = key;
				gsettings_key_set_to_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_GSETTINGS_KEY, GSettingsKey));
			} else {
				Behaviour _tmp9_;
				_tmp9_ = self->priv->_behaviour;
				if (_tmp9_ != BEHAVIOUR_UNSAFE) {
					ModificationsRevealer* _tmp10_;
					Key* _tmp11_;
					registry_view_enter_delay_mode (self);
					_tmp10_ = self->priv->revealer;
					_tmp11_ = key;
					modifications_revealer_add_delayed_setting (_tmp10_, _tmp11_, NULL);
				} else {
					Key* _tmp12_;
					_tmp12_ = key;
					dconf_key_erase (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DCONF_KEY, DConfKey));
				}
			}
		}
	}
}


void registry_view_reset (RegistryView* self, gboolean recursively) {
	GListStore* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_model;
	_tmp1_ = recursively;
	registry_view_reset_objects (self, _tmp0_, _tmp1_);
}


static void registry_view_reset_objects (RegistryView* self, GListStore* objects, gboolean recursively) {
	GListStore* _tmp0_;
	gboolean _tmp1_;
	ModificationsRevealer* _tmp2_;
	g_return_if_fail (self != NULL);
	registry_view_enter_delay_mode (self);
	_tmp0_ = objects;
	_tmp1_ = recursively;
	registry_view_reset_generic (self, _tmp0_, _tmp1_);
	_tmp2_ = self->priv->revealer;
	modifications_revealer_warn_if_no_planned_changes (_tmp2_);
}


static void registry_view_reset_generic (RegistryView* self, GListStore* objects, gboolean recursively) {
	GListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = objects;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		guint position = 0U;
		position = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GObject* object = NULL;
				GListStore* _tmp3_;
				guint _tmp4_;
				GObject* _tmp5_;
				GObject* _tmp6_;
				SettingObject* setting_object = NULL;
				GObject* _tmp7_;
				SettingObject* _tmp8_;
				SettingObject* _tmp9_;
				SettingObject* _tmp14_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = position;
					position = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = objects;
				_tmp4_ = position;
				_tmp5_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_list_store_get_type (), GListStore), _tmp4_);
				object = _tmp5_;
				_tmp6_ = object;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (object);
					return;
				}
				_tmp7_ = object;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject), TYPE_SETTING_OBJECT, SettingObject));
				setting_object = _tmp8_;
				_tmp9_ = setting_object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_DIRECTORY)) {
					gboolean _tmp10_;
					_tmp10_ = recursively;
					if (_tmp10_) {
						SettingObject* _tmp11_;
						GListStore* _tmp12_;
						GListStore* _tmp13_;
						_tmp11_ = setting_object;
						_tmp12_ = directory_get_key_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DIRECTORY, Directory));
						_tmp13_ = _tmp12_;
						registry_view_reset_generic (self, _tmp13_, TRUE);
					}
					_g_object_unref0 (setting_object);
					_g_object_unref0 (object);
					continue;
				}
				_tmp14_ = setting_object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TYPE_DCONF_KEY)) {
					SettingObject* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp15_ = setting_object;
					_tmp16_ = dconf_key_get_is_ghost (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DCONF_KEY, DConfKey));
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
						ModificationsRevealer* _tmp18_;
						SettingObject* _tmp19_;
						_tmp18_ = self->priv->revealer;
						_tmp19_ = setting_object;
						modifications_revealer_add_delayed_setting (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_KEY, Key), NULL);
					}
				} else {
					SettingObject* _tmp20_;
					gboolean _tmp21_;
					gboolean _tmp22_;
					_tmp20_ = setting_object;
					_tmp21_ = gsettings_key_get_is_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_GSETTINGS_KEY, GSettingsKey));
					_tmp22_ = _tmp21_;
					if (!_tmp22_) {
						ModificationsRevealer* _tmp23_;
						SettingObject* _tmp24_;
						_tmp23_ = self->priv->revealer;
						_tmp24_ = setting_object;
						modifications_revealer_add_delayed_setting (_tmp23_, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_KEY, Key), NULL);
					}
				}
				_g_object_unref0 (setting_object);
				_g_object_unref0 (object);
			}
		}
	}
}


void registry_view_set_search_mode (RegistryView* self, gboolean* mode) {
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	if (_tmp0_ == NULL) {
		GtkSearchBar* _tmp1_;
		GtkSearchBar* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->search_bar;
		_tmp2_ = self->priv->search_bar;
		_tmp3_ = gtk_search_bar_get_search_mode (_tmp2_);
		gtk_search_bar_set_search_mode (_tmp1_, !_tmp3_);
	} else {
		GtkSearchBar* _tmp4_;
		gboolean* _tmp5_;
		_tmp4_ = self->priv->search_bar;
		_tmp5_ = mode;
		gtk_search_bar_set_search_mode (_tmp4_, (gboolean) (*_tmp5_));
	}
}


gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkSearchBar* _tmp1_;
	GdkEventKey* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = registry_view_is_not_browsing_view (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->search_bar;
	_tmp2_ = event;
	_tmp3_ = gtk_search_bar_handle_event (_tmp1_, (GdkEvent*) _tmp2_);
	result = _tmp3_;
	return result;
}


gboolean registry_view_show_row_popover (RegistryView* self) {
	gboolean result = FALSE;
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	ClickableListBoxRow* row = NULL;
	GtkListBoxRow* _tmp2_;
	GtkWidget* _tmp3_;
	ClickableListBoxRow* _tmp4_;
	ClickableListBoxRow* _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_;
	GListStore* _tmp8_;
	ClickableListBoxRow* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = registry_view_get_key_row (self);
	selected_row = _tmp0_;
	_tmp1_ = selected_row;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (selected_row);
		return result;
	}
	_tmp2_ = selected_row;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
	row = _tmp4_;
	_tmp5_ = row;
	_tmp6_ = registry_view_get_current_delay_mode (self);
	_tmp7_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	clickable_list_box_row_show_right_click_popover (_tmp5_, _tmp6_, (gint) (_tmp7_ / 2.0));
	_tmp8_ = self->priv->rows_possibly_with_popover;
	_tmp9_ = row;
	g_list_store_append (_tmp8_, (GObject*) _tmp9_);
	result = TRUE;
	_g_object_unref0 (row);
	_g_object_unref0 (selected_row);
	return result;
}


gchar* registry_view_get_copy_text (RegistryView* self) {
	gchar* result = NULL;
	gboolean _tmp0_;
	GtkListBoxRow* selected_row = NULL;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBoxRow* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = registry_view_is_not_browsing_view (self);
	if (_tmp0_) {
		RegistryInfo* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->properties_view;
		_tmp2_ = registry_info_get_copy_text (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->key_list_box;
	_tmp4_ = gtk_list_box_get_selected_row (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	selected_row = _tmp5_;
	_tmp6_ = selected_row;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_object_unref0 (selected_row);
		return result;
	} else {
		GtkListBoxRow* _tmp7_;
		GtkWidget* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = selected_row;
		_tmp8_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_row_get_type (), GtkListBoxRow));
		_tmp9_ = clickable_list_box_row_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
		result = _tmp9_;
		_g_object_unref0 (selected_row);
		return result;
	}
	_g_object_unref0 (selected_row);
}


void registry_view_toggle_boolean_key (RegistryView* self) {
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkWidget* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = registry_view_get_key_row (self);
	selected_row = _tmp0_;
	_tmp1_ = selected_row;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (selected_row);
		return;
	}
	_tmp2_ = selected_row;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_row_get_type (), GtkListBoxRow));
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_KEY_LIST_BOX_ROW)) {
		_g_object_unref0 (selected_row);
		return;
	}
	_tmp4_ = selected_row;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_row_get_type (), GtkListBoxRow));
	key_list_box_row_toggle_boolean_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_KEY_LIST_BOX_ROW, KeyListBoxRow));
	_g_object_unref0 (selected_row);
}


void registry_view_set_to_default (RegistryView* self) {
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = registry_view_get_key_row (self);
	selected_row = _tmp0_;
	_tmp1_ = selected_row;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (selected_row);
		return;
	}
	_tmp2_ = selected_row;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_row_get_type (), GtkListBoxRow));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow), "on-delete-call");
	_g_object_unref0 (selected_row);
}


void registry_view_discard_row_popover (RegistryView* self) {
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = registry_view_get_key_row (self);
	selected_row = _tmp0_;
	_tmp1_ = selected_row;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (selected_row);
		return;
	}
	_tmp2_ = selected_row;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_row_get_type (), GtkListBoxRow));
	clickable_list_box_row_hide_right_click_popover (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
	_g_object_unref0 (selected_row);
}


static gboolean registry_view_is_not_browsing_view (RegistryView* self) {
	gboolean result = FALSE;
	gchar* visible_child_name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	visible_child_name = _tmp2_;
	_tmp4_ = visible_child_name;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = visible_child_name;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "browse-view") != 0;
	}
	result = _tmp3_;
	_g_free0 (visible_child_name);
	return result;
}


static GtkListBoxRow* registry_view_get_key_row (RegistryView* self) {
	GtkListBoxRow* result = NULL;
	gboolean _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = registry_view_is_not_browsing_view (self);
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->key_list_box;
	_tmp2_ = gtk_list_box_get_selected_row (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_row_get_type (), GtkListBoxRow));
	result = _tmp3_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void registry_view_find_next_cb (RegistryView* self) {
	GtkSearchBar* _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter iter = {0};
	gboolean on_first_directory = FALSE;
	gint position = 0;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkButton* _tmp90_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_bar;
	_tmp1_ = gtk_search_bar_get_search_mode (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	position = 0;
	_tmp2_ = self->priv->dir_tree_selection;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkListBoxRow* selected_row = NULL;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		GtkListBoxRow* _tmp7_;
		GtkListBoxRow* _tmp8_;
		_tmp5_ = self->priv->key_list_box;
		_tmp6_ = gtk_list_box_get_selected_row (_tmp5_);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_row_get_type (), GtkListBoxRow));
		selected_row = _tmp7_;
		_tmp8_ = selected_row;
		if (_tmp8_ != NULL) {
			GtkListBoxRow* _tmp9_;
			gint _tmp10_;
			_tmp9_ = selected_row;
			_tmp10_ = gtk_list_box_row_get_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_box_row_get_type (), GtkListBoxRow));
			position = _tmp10_ + 1;
		}
		on_first_directory = TRUE;
		_g_object_unref0 (selected_row);
	} else {
		SettingsModel* _tmp11_;
		GtkTreeIter _tmp12_ = {0};
		gboolean _tmp13_;
		_tmp11_ = self->priv->model;
		_tmp13_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp11_, &_tmp12_);
		iter = _tmp12_;
		if (_tmp13_) {
			on_first_directory = FALSE;
		} else {
			return;
		}
	}
	{
		gboolean _tmp14_ = FALSE;
		_tmp14_ = TRUE;
		while (TRUE) {
			Directory* dir = NULL;
			SettingsModel* _tmp16_;
			GtkTreeIter _tmp17_;
			Directory* _tmp18_;
			gboolean _tmp19_;
			Directory* _tmp32_;
			GSettings* _tmp33_;
			gboolean _tmp34_;
			GListStore* key_model = NULL;
			Directory* _tmp35_;
			GListStore* _tmp36_;
			GListStore* _tmp37_;
			GListStore* _tmp38_;
			if (!_tmp14_) {
				gboolean _tmp15_;
				_tmp15_ = registry_view_get_next_iter (self, &iter);
				if (!_tmp15_) {
					break;
				}
			}
			_tmp14_ = FALSE;
			_tmp16_ = self->priv->model;
			_tmp17_ = iter;
			_tmp18_ = settings_model_get_directory (_tmp16_, &_tmp17_);
			dir = _tmp18_;
			_tmp19_ = on_first_directory;
			if (!_tmp19_) {
				Directory* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				GtkSearchEntry* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gint _tmp26_;
				_tmp20_ = dir;
				_tmp21_ = setting_object_get_name ((SettingObject*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->search_entry;
				_tmp24_ = gtk_entry_get_text ((GtkEntry*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_index_of (_tmp22_, _tmp25_, 0);
				if (_tmp26_ >= 0) {
					GtkTreeSelection* _tmp27_;
					GtkTreeIter _tmp28_;
					Directory* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp27_ = self->priv->dir_tree_selection;
					_tmp28_ = iter;
					gtk_tree_selection_select_iter (_tmp27_, &_tmp28_);
					_tmp29_ = dir;
					_tmp30_ = setting_object_get_full_name ((SettingObject*) _tmp29_);
					_tmp31_ = _tmp30_;
					registry_view_show_browse_view (self, _tmp31_, NULL, FALSE);
					_g_object_unref0 (dir);
					return;
				}
			} else {
				on_first_directory = FALSE;
			}
			_tmp32_ = dir;
			_tmp33_ = self->priv->application_settings;
			_tmp34_ = g_settings_get_boolean (_tmp33_, "sort-case-sensitive");
			directory_sort_key_model (_tmp32_, _tmp34_);
			_tmp35_ = dir;
			_tmp36_ = directory_get_key_model (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			key_model = _tmp38_;
			while (TRUE) {
				gint _tmp39_;
				GListStore* _tmp40_;
				guint _tmp41_;
				SettingObject* object = NULL;
				GListStore* _tmp42_;
				gint _tmp43_;
				GObject* _tmp44_;
				SettingObject* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				GtkSearchEntry* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				gint _tmp51_;
				gint _tmp89_;
				_tmp39_ = position;
				_tmp40_ = key_model;
				_tmp41_ = g_list_model_get_n_items ((GListModel*) _tmp40_);
				if (!(((guint) _tmp39_) < _tmp41_)) {
					break;
				}
				_tmp42_ = key_model;
				_tmp43_ = position;
				_tmp44_ = g_list_model_get_object ((GListModel*) _tmp42_, (guint) _tmp43_);
				object = G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_SETTING_OBJECT, SettingObject);
				_tmp45_ = object;
				_tmp46_ = setting_object_get_name (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = self->priv->search_entry;
				_tmp49_ = gtk_entry_get_text ((GtkEntry*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = string_index_of (_tmp47_, _tmp50_, 0);
				if (_tmp51_ >= 0) {
					GtkTreeSelection* _tmp52_;
					GtkTreeIter _tmp53_;
					GtkListBox* _tmp54_;
					GtkListBox* _tmp55_;
					gint _tmp56_;
					GtkListBoxRow* _tmp57_;
					Directory* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					SettingObject* _tmp61_;
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					_tmp52_ = self->priv->dir_tree_selection;
					_tmp53_ = iter;
					gtk_tree_selection_select_iter (_tmp52_, &_tmp53_);
					_tmp54_ = self->priv->key_list_box;
					_tmp55_ = self->priv->key_list_box;
					_tmp56_ = position;
					_tmp57_ = gtk_list_box_get_row_at_index (_tmp55_, _tmp56_);
					gtk_list_box_select_row (_tmp54_, _tmp57_);
					_tmp58_ = dir;
					_tmp59_ = setting_object_get_full_name ((SettingObject*) _tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = object;
					_tmp62_ = setting_object_get_full_name (_tmp61_);
					_tmp63_ = _tmp62_;
					registry_view_show_browse_view (self, _tmp60_, _tmp63_, FALSE);
					_g_object_unref0 (object);
					_g_object_unref0 (key_model);
					_g_object_unref0 (dir);
					return;
				} else {
					SettingObject* _tmp64_;
					_tmp64_ = object;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, TYPE_KEY)) {
						Key* key = NULL;
						SettingObject* _tmp65_;
						Key* _tmp66_;
						gboolean _tmp67_ = FALSE;
						gboolean _tmp68_ = FALSE;
						Key* _tmp69_;
						_tmp65_ = object;
						_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, TYPE_KEY, Key));
						key = _tmp66_;
						_tmp69_ = key;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, TYPE_GSETTINGS_KEY)) {
							_tmp68_ = TRUE;
						} else {
							Key* _tmp70_;
							gboolean _tmp71_;
							gboolean _tmp72_;
							_tmp70_ = key;
							_tmp71_ = dconf_key_get_is_ghost (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_DCONF_KEY, DConfKey));
							_tmp72_ = _tmp71_;
							_tmp68_ = !_tmp72_;
						}
						if (_tmp68_) {
							Key* _tmp73_;
							GtkSearchEntry* _tmp74_;
							const gchar* _tmp75_;
							const gchar* _tmp76_;
							gboolean _tmp77_;
							_tmp73_ = key;
							_tmp74_ = self->priv->search_entry;
							_tmp75_ = gtk_entry_get_text ((GtkEntry*) _tmp74_);
							_tmp76_ = _tmp75_;
							_tmp77_ = registry_view_key_matches (self, _tmp73_, _tmp76_);
							_tmp67_ = _tmp77_;
						} else {
							_tmp67_ = FALSE;
						}
						if (_tmp67_) {
							RegistryInfo* _tmp78_;
							Key* _tmp79_;
							GtkTreeSelection* _tmp80_;
							GtkTreeIter _tmp81_;
							GtkListBox* _tmp82_;
							GtkListBox* _tmp83_;
							gint _tmp84_;
							GtkListBoxRow* _tmp85_;
							SettingObject* _tmp86_;
							const gchar* _tmp87_;
							const gchar* _tmp88_;
							_tmp78_ = self->priv->properties_view;
							_tmp79_ = key;
							registry_info_populate_properties_list_box (_tmp78_, _tmp79_);
							_tmp80_ = self->priv->dir_tree_selection;
							_tmp81_ = iter;
							gtk_tree_selection_select_iter (_tmp80_, &_tmp81_);
							_tmp82_ = self->priv->key_list_box;
							_tmp83_ = self->priv->key_list_box;
							_tmp84_ = position;
							_tmp85_ = gtk_list_box_get_row_at_index (_tmp83_, _tmp84_);
							gtk_list_box_select_row (_tmp82_, _tmp85_);
							_tmp86_ = object;
							_tmp87_ = setting_object_get_full_name (_tmp86_);
							_tmp88_ = _tmp87_;
							registry_view_show_properties_view (self, _tmp88_);
							_g_object_unref0 (key);
							_g_object_unref0 (object);
							_g_object_unref0 (key_model);
							_g_object_unref0 (dir);
							return;
						}
						_g_object_unref0 (key);
					}
				}
				_tmp89_ = position;
				position = _tmp89_ + 1;
				_g_object_unref0 (object);
			}
			position = 0;
			_g_object_unref0 (key_model);
			_g_object_unref0 (dir);
		}
	}
	_tmp90_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp90_, FALSE);
}


static void _registry_view_find_next_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	registry_view_find_next_cb ((RegistryView*) self);
}


static gboolean registry_view_key_matches (RegistryView* self, Key* key, const gchar* text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Key* _tmp1_;
	gboolean _tmp5_ = FALSE;
	Key* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	const GVariantType* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp1_ = key;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_GSETTINGS_KEY)) {
		Key* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = key;
		_tmp3_ = text;
		_tmp4_ = gsettings_key_search_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_GSETTINGS_KEY, GSettingsKey), _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp6_ = key;
	_tmp7_ = key_get_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = G_VARIANT_TYPE_STRING;
	_tmp11_ = g_variant_is_of_type (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_variant_unref0 (_tmp9_);
	if (_tmp12_) {
		Key* _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		_tmp13_ = key;
		_tmp14_ = key_get_value (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = g_variant_get_string (_tmp16_, NULL);
		_tmp18_ = text;
		_tmp19_ = string_index_of (_tmp17_, _tmp18_, 0);
		_tmp5_ = _tmp19_ >= 0;
		_g_variant_unref0 (_tmp16_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean registry_view_get_next_iter (RegistryView* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	SettingsModel* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->model;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp0_, &_tmp1_);
	if (_tmp2_) {
		SettingsModel* _tmp3_;
		GtkTreeIter _tmp4_;
		GtkTreeIter _tmp5_ = {0};
		_tmp3_ = self->priv->model;
		_tmp4_ = *iter;
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp3_, &_tmp5_, &_tmp4_, 0);
		*iter = _tmp5_;
		result = TRUE;
		return result;
	}
	while (TRUE) {
		SettingsModel* _tmp6_;
		gboolean _tmp7_;
		SettingsModel* _tmp8_;
		GtkTreeIter _tmp9_;
		GtkTreeIter _tmp10_ = {0};
		gboolean _tmp11_;
		_tmp6_ = self->priv->model;
		_tmp7_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp6_, iter);
		if (!(!_tmp7_)) {
			break;
		}
		_tmp8_ = self->priv->model;
		_tmp9_ = *iter;
		_tmp11_ = gtk_tree_model_iter_parent ((GtkTreeModel*) _tmp8_, &_tmp10_, &_tmp9_);
		*iter = _tmp10_;
		if (!_tmp11_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


RegistryView* registry_view_construct (GType object_type) {
	RegistryView * self = NULL;
	self = (RegistryView*) g_object_new (object_type, NULL);
	return self;
}


RegistryView* registry_view_new (void) {
	return registry_view_construct (TYPE_REGISTRY_VIEW);
}


const gchar* registry_view_get_current_path (RegistryView* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_path;
	result = _tmp0_;
	return result;
}


static void registry_view_set_current_path (RegistryView* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, registry_view_get_current_path (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_current_path);
		self->priv->_current_path = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, registry_view_properties[REGISTRY_VIEW_CURRENT_PATH_PROPERTY]);
	}
}


gboolean registry_view_get_show_search_bar (RegistryView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_search_bar;
	result = _tmp0_;
	return result;
}


void registry_view_set_show_search_bar (RegistryView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (registry_view_get_show_search_bar (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_show_search_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, registry_view_properties[REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY]);
	}
}


Behaviour registry_view_get_behaviour (RegistryView* self) {
	Behaviour result;
	Behaviour _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_behaviour;
	result = _tmp0_;
	return result;
}


void registry_view_set_behaviour (RegistryView* self, Behaviour value) {
	g_return_if_fail (self != NULL);
	if (registry_view_get_behaviour (self) != value) {
		Behaviour _tmp0_;
		_tmp0_ = value;
		self->priv->_behaviour = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, registry_view_properties[REGISTRY_VIEW_BEHAVIOUR_PROPERTY]);
	}
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		RegistryView* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->buffer);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static void _registry_view_invalidate_popovers_modifications_revealer_reload (ModificationsRevealer* _sender, gpointer self) {
	registry_view_invalidate_popovers ((RegistryView*) self);
}


static void _registry_view___lambda87_ (RegistryView* self) {
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
}


static void __registry_view___lambda87__gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self) {
	_registry_view___lambda87_ ((RegistryView*) self);
}


static void _registry_view___lambda88_ (Block24Data* _data24_) {
	RegistryView* self;
	ModificationsRevealer* _tmp0_;
	gulong _tmp1_;
	GtkEntryBuffer* _tmp2_;
	gulong _tmp3_;
	self = _data24_->self;
	_tmp0_ = self->priv->revealer;
	_tmp1_ = _data24_->revealer_reload_handler;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data24_->buffer;
	_tmp3_ = _data24_->search_entry_buffer_deleted_text_handler;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _tmp3_);
	GTK_WIDGET_CLASS (registry_view_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
}


static void __registry_view___lambda88__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_registry_view___lambda88_ (self);
}


static GObject * registry_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RegistryView * self;
	Block24Data* _data24_;
	ModificationsRevealer* _tmp0_;
	gulong _tmp1_;
	GtkSearchEntry* _tmp2_;
	GtkEntryBuffer* _tmp3_;
	GtkEntryBuffer* _tmp4_;
	GtkEntryBuffer* _tmp5_;
	gulong _tmp6_;
	GtkSearchBar* _tmp7_;
	GtkSearchEntry* _tmp8_;
	GtkSearchBar* _tmp9_;
	ModificationsRevealer* _tmp10_;
	parent_class = G_OBJECT_CLASS (registry_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_VIEW, RegistryView);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = g_signal_connect_object (_tmp0_, "reload", (GCallback) _registry_view_invalidate_popovers_modifications_revealer_reload, self, 0);
	_data24_->revealer_reload_handler = _tmp1_;
	_tmp2_ = self->priv->search_entry;
	_tmp3_ = gtk_entry_get_buffer ((GtkEntry*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data24_->buffer = _tmp4_;
	_tmp5_ = _data24_->buffer;
	_tmp6_ = g_signal_connect_object (_tmp5_, "deleted-text", (GCallback) __registry_view___lambda87__gtk_entry_buffer_deleted_text, self, 0);
	_data24_->search_entry_buffer_deleted_text_handler = _tmp6_;
	_tmp7_ = self->priv->search_bar;
	_tmp8_ = self->priv->search_entry;
	gtk_search_bar_connect_entry (_tmp7_, (GtkEntry*) _tmp8_);
	_tmp9_ = self->priv->search_bar;
	g_object_bind_property_with_closures ((GObject*) self, "show-search-bar", (GObject*) _tmp9_, "search-mode-enabled", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->revealer;
	g_object_bind_property_with_closures ((GObject*) self, "behaviour", (GObject*) _tmp10_, "behaviour", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __registry_view___lambda88__gtk_widget_destroy, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	block24_data_unref (_data24_);
	_data24_ = NULL;
	return obj;
}


static void registry_view_class_init (RegistryViewClass * klass) {
	gint RegistryView_private_offset;
	registry_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RegistryViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_registry_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_registry_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = registry_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = registry_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_VIEW_CURRENT_PATH_PROPERTY, registry_view_properties[REGISTRY_VIEW_CURRENT_PATH_PROPERTY] = g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY, registry_view_properties[REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY] = g_param_spec_boolean ("show-search-bar", "show-search-bar", "show-search-bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_VIEW_BEHAVIOUR_PROPERTY, registry_view_properties[REGISTRY_VIEW_BEHAVIOUR_PROPERTY] = g_param_spec_enum ("behaviour", "behaviour", "behaviour", TYPE_BEHAVIOUR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	RegistryView_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/registry-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "need_reload_warning_revealer", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, need_reload_warning_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_tree_view", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, dir_tree_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_tree_selection", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, dir_tree_selection));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "properties_view", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, properties_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "key_list_box", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, key_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_next_button", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, search_next_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "dir_selected_cb", G_CALLBACK(_registry_view_dir_selected_cb_gtk_tree_selection_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "row_activated_cb", G_CALLBACK(_registry_view_row_activated_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reload", G_CALLBACK(_registry_view_reload_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "find_next_cb", G_CALLBACK(_registry_view_find_next_cb_gtk_button_clicked));
}


static void registry_view_path_element_interface_init (PathElementIface * iface) {
	registry_view_path_element_parent_iface = g_type_interface_peek_parent (iface);
}


static void registry_view_instance_init (RegistryView * self) {
	GSettings* _tmp0_;
	SettingsModel* _tmp1_;
	GListStore* _tmp2_;
	self->priv = REGISTRY_VIEW_GET_PRIVATE (self);
	_tmp0_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
	self->priv->application_settings = _tmp0_;
	_tmp1_ = settings_model_new ();
	self->priv->model = _tmp1_;
	self->priv->key_model = NULL;
	_tmp2_ = g_list_store_new (TYPE_CLICKABLE_LIST_BOX_ROW);
	self->priv->rows_possibly_with_popover = _tmp2_;
	g_type_ensure (TYPE_REGISTRY_INFO);
	g_type_ensure (TYPE_MODIFICATIONS_REVEALER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void registry_view_finalize (GObject * obj) {
	RegistryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_VIEW, RegistryView);
	_g_free0 (self->priv->_current_path);
	_g_object_unref0 (self->priv->application_settings);
	_g_object_unref0 (self->priv->need_reload_warning_revealer);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->priv->dir_tree_view);
	_g_object_unref0 (self->priv->dir_tree_selection);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->properties_view);
	_g_object_unref0 (self->priv->key_list_box);
	_g_object_unref0 (self->priv->key_model);
	_g_object_unref0 (self->priv->rows_possibly_with_popover);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->search_bar);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->search_next_button);
	G_OBJECT_CLASS (registry_view_parent_class)->finalize (obj);
}


GType registry_view_get_type (void) {
	static volatile gsize registry_view_type_id__volatile = 0;
	if (g_once_init_enter (&registry_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RegistryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) registry_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RegistryView), 0, (GInstanceInitFunc) registry_view_instance_init, NULL };
		static const GInterfaceInfo path_element_info = { (GInterfaceInitFunc) registry_view_path_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType registry_view_type_id;
		registry_view_type_id = g_type_register_static (gtk_grid_get_type (), "RegistryView", &g_define_type_info, 0);
		g_type_add_interface_static (registry_view_type_id, TYPE_PATH_ELEMENT, &path_element_info);
		g_once_init_leave (&registry_view_type_id__volatile, registry_view_type_id);
	}
	return registry_view_type_id__volatile;
}


static void _vala_registry_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RegistryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REGISTRY_VIEW, RegistryView);
	switch (property_id) {
		case REGISTRY_VIEW_CURRENT_PATH_PROPERTY:
		g_value_set_string (value, registry_view_get_current_path (self));
		break;
		case REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY:
		g_value_set_boolean (value, registry_view_get_show_search_bar (self));
		break;
		case REGISTRY_VIEW_BEHAVIOUR_PROPERTY:
		g_value_set_enum (value, registry_view_get_behaviour (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_registry_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RegistryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REGISTRY_VIEW, RegistryView);
	switch (property_id) {
		case REGISTRY_VIEW_CURRENT_PATH_PROPERTY:
		registry_view_set_current_path (self, g_value_get_string (value));
		break;
		case REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY:
		registry_view_set_show_search_bar (self, g_value_get_boolean (value));
		break;
		case REGISTRY_VIEW_BEHAVIOUR_PROPERTY:
		registry_view_set_behaviour (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



