/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Index;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EnglishTreebankParserParams
extends AbstractTreebankParserParams {
    private HeadFinder headFinder;
    private EnglishTrain englishTrain = new EnglishTrain();
    private EnglishTest englishTest = new EnglishTest();
    private static final String[] sisterSplit1 = new String[]{"ADJP=l=VBD", "ADJP=l=VBP", "NP=r=RBR", "PRN=r=.", "ADVP=l=PP", "PP=l=JJ", "PP=r=NP", "SBAR=l=VB", "PP=l=VBG", "ADJP=r=,", "ADVP=r=.", "ADJP=l=VB", "FRAG=l=FRAG", "FRAG=r=:", "PP=r=,", "ADJP=l=,", "FRAG=r=FRAG", "FRAG=l=:", "PRN=r=VP", "PP=l=RB", "S=l=ADJP", "SBAR=l=VBN", "NP=r=NX", "SBAR=l=VBZ", "SBAR=l=ADVP", "QP=r=JJ", "SBAR=l=PP", "SBAR=l=ADJP", "NP=r=VBG", "VP=r=:", "VP=l=ADJP", "SBAR=l=VBP", "ADVP=r=NP", "PP=l=VB", "VP=r=PP", "ADJP=r=SBAR", "NP=r=JJR", "SBAR=l=NN", "S=l=RB", "S=l=NNS", "S=r=SBAR", "S=l=WHPP", "VP=l=:", "ADVP=l=NP", "ADVP=r=PP", "ADJP=l=JJ", "NP=r=VBN", "NP=l=PRN", "VP=r=S", "NP=r=NNPS", "NX=r=NX", "ADJP=l=PRP$", "SBAR=l=CC", "SBAR=l=S", "S=l=PRT", "ADVP=l=VB", "ADVP=r=JJ", "NP=l=DT"};
    private static final String[] sisterSplit2 = new String[]{"S=r=PP", "NP=r=JJS", "ADJP=r=NNP", "NP=l=PRT", "ADJP=r=PP", "ADJP=l=VBZ", "PP=r=VP", "NP=r=CD", "ADVP=l=IN", "ADVP=l=,", "ADJP=r=JJ", "ADVP=l=VBD", "PP=r=.", "S=l=ADVP", "S=l=DT", "PP=l=NP", "VP=l=PRN", "NP=r=IN", "NP=r=``"};
    private static final String[] sisterSplit3 = new String[]{"PP=l=VBD", "ADJP=r=NNS", "S=l=:", "NP=l=ADVP", "NP=r=PRN", "NP=r=-RRB-", "NP=l=-LRB-", "NP=l=JJ", "SBAR=r=.", "S=r=:", "ADVP=r=VP", "NP=l=RB", "NP=r=RB", "S=l=VBP", "SBAR=r=,", "VP=r=,", "PP=r=PP", "NP=r=S", "ADJP=l=NP", "VP=l=VBG", "PP=l=PP"};
    private static final String[] sisterSplit4 = new String[]{"VP=l=NP", "NP=r=NN", "NP=r=VP", "VP=r=.", "NP=r=PP", "VP=l=TO", "VP=l=MD", "NP=r=,", "NP=r=NP", "NP=r=.", "NP=l=IN", "NP=l=NP", "VP=l=,", "VP=l=S", "NP=l=,", "VP=l=VBZ", "S=r=.", "NP=r=NNS", "S=l=IN", "NP=r=JJ", "NP=r=NNP", "VP=l=VBD", "S=l=WHNP", "VP=r=NP", "VP=l=''", "VP=l=VBP", "NP=l=:", "S=r=,", "VP=l=``", "VP=l=VB", "NP=l=S", "NP=l=VP", "NP=l=VB", "NP=l=VBD", "NP=r=SBAR", "NP=r=:", "VP=l=PP", "NP=l=VBZ", "NP=l=CC", "NP=l=''", "S=r=NP", "S=r=S", "S=l=VBN", "NP=l=``", "ADJP=r=NN", "S=r=VP", "NP=r=CC", "VP=l=RB", "S=l=S", "S=l=NP", "NP=l=TO", "S=l=,", "S=l=VBD", "S=r=''", "S=l=``", "S=r=CC", "PP=l=,", "S=l=CC", "VP=l=CC", "ADJP=l=DT", "NP=l=VBG", "VP=r=''", "SBAR=l=NP", "VP=l=VP", "NP=l=PP", "S=l=VB", "SBAR=l=VBD", "VP=l=ADVP", "VP=l=VBN", "NP=r=''", "VP=l=SBAR", "SBAR=l=,", "S=l=WHADVP", "VP=r=VP", "NP=r=ADVP", "QP=r=NNS", "NP=l=VBP", "S=l=VBZ", "NP=l=VBN", "S=l=PP", "VP=r=CC", "NP=l=SBAR", "SBAR=r=NP", "S=l=VBG", "SBAR=r=VP", "NP=r=ADJP", "S=l=JJ", "S=l=NN", "QP=r=NN"};
    private static final TreeFactory categoryWordTagTreeFactory = new LabeledScoredTreeFactory(new CategoryWordTagFactory());
    private static final long serialVersionUID = 4153878351331522581L;

    public EnglishTreebankParserParams() {
        super(new PennTreebankLanguagePack());
        this.headFinder = new ModCollinsHeadFinder(this.tlp);
    }

    @Override
    public HeadFinder headFinder() {
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new SemanticHeadFinder(!this.englishTest.makeCopulaHead);
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory());
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory());
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new TreeReaderFactory(){

            @Override
            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory(), new NPTmpRetainingTreeNormalizer(((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitTMP, ((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitSGapped == 5, ((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.leaveItAll, ((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitNPADV >= 1, EnglishTreebankParserParams.this.headFinder()));
            }
        };
    }

    @Override
    public MemoryTreebank testMemoryTreebank() {
        return new MemoryTreebank(new TreeReaderFactory(){

            @Override
            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory(), new BobChrisTreeNormalizer(EnglishTreebankParserParams.this.tlp));
            }
        });
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.tlp, true, this.englishTrain.splitBaseNP == 2);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.tlp, true, this.englishTrain.splitBaseNP == 2);
    }

    @Override
    public TreebankLanguagePack treebankLanguagePack() {
        return this.tlp;
    }

    @Override
    public PrintWriter pw(OutputStream o) {
        return new PrintWriter(o, true);
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.EnglishUnknownWordModelTrainer";
        }
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public String[] sisterSplitters() {
        switch (this.englishTrain.sisterSplitLevel) {
            case 1: {
                return sisterSplit1;
            }
            case 2: {
                return sisterSplit2;
            }
            case 3: {
                return sisterSplit3;
            }
            case 4: {
                return sisterSplit4;
            }
        }
        return new String[0];
    }

    @Override
    public TreeTransformer subcategoryStripper() {
        return new EnglishSubcategoryStripper();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Tree transformTree(Tree t, Tree root) {
        String cat;
        String tag;
        String word;
        block423: {
            Tree[] kids;
            String baseCat;
            String parentStr;
            block425: {
                String cat2;
                int i;
                int seenS;
                boolean sawSBeforePredCat;
                boolean seenPredCat;
                int seenNP;
                block430: {
                    boolean seenS2;
                    boolean seenCC;
                    boolean seenPredCat2;
                    block429: {
                        int seenNP2;
                        boolean seenPredCat3;
                        block427: {
                            block428: {
                                block426: {
                                    block424: {
                                        String baseTag;
                                        String baseParentStr;
                                        block405: {
                                            boolean split;
                                            block408: {
                                                Tree parent;
                                                block416: {
                                                    boolean annotateHave;
                                                    Tree[] sisters;
                                                    block414: {
                                                        block412: {
                                                            block422: {
                                                                block421: {
                                                                    block420: {
                                                                        block419: {
                                                                            block418: {
                                                                                block417: {
                                                                                    block415: {
                                                                                        block413: {
                                                                                            int i2;
                                                                                            block409: {
                                                                                                block411: {
                                                                                                    block410: {
                                                                                                        char ch;
                                                                                                        boolean foundJJ;
                                                                                                        Tree[] kids2;
                                                                                                        block400: {
                                                                                                            block401: {
                                                                                                                block407: {
                                                                                                                    block406: {
                                                                                                                        block250: {
                                                                                                                            block403: {
                                                                                                                                block404: {
                                                                                                                                    block402: {
                                                                                                                                        String baseGrandParentStr;
                                                                                                                                        block251: {
                                                                                                                                            block388: {
                                                                                                                                                block399: {
                                                                                                                                                    block398: {
                                                                                                                                                        String grandParentStr;
                                                                                                                                                        block397: {
                                                                                                                                                            block393: {
                                                                                                                                                                block396: {
                                                                                                                                                                    block395: {
                                                                                                                                                                        block394: {
                                                                                                                                                                            block390: {
                                                                                                                                                                                block392: {
                                                                                                                                                                                    block391: {
                                                                                                                                                                                        block389: {
                                                                                                                                                                                            block387: {
                                                                                                                                                                                                block252: {
                                                                                                                                                                                                    block256: {
                                                                                                                                                                                                        block386: {
                                                                                                                                                                                                            block385: {
                                                                                                                                                                                                                block384: {
                                                                                                                                                                                                                    block383: {
                                                                                                                                                                                                                        block379: {
                                                                                                                                                                                                                            block382: {
                                                                                                                                                                                                                                block381: {
                                                                                                                                                                                                                                    block380: {
                                                                                                                                                                                                                                        block378: {
                                                                                                                                                                                                                                            block377: {
                                                                                                                                                                                                                                                block376: {
                                                                                                                                                                                                                                                    block375: {
                                                                                                                                                                                                                                                        block374: {
                                                                                                                                                                                                                                                            block372: {
                                                                                                                                                                                                                                                                block373: {
                                                                                                                                                                                                                                                                    block371: {
                                                                                                                                                                                                                                                                        block364: {
                                                                                                                                                                                                                                                                            block367: {
                                                                                                                                                                                                                                                                                block370: {
                                                                                                                                                                                                                                                                                    block369: {
                                                                                                                                                                                                                                                                                        block368: {
                                                                                                                                                                                                                                                                                            block366: {
                                                                                                                                                                                                                                                                                                block365: {
                                                                                                                                                                                                                                                                                                    block363: {
                                                                                                                                                                                                                                                                                                        block282: {
                                                                                                                                                                                                                                                                                                            block362: {
                                                                                                                                                                                                                                                                                                                block361: {
                                                                                                                                                                                                                                                                                                                    block360: {
                                                                                                                                                                                                                                                                                                                        block359: {
                                                                                                                                                                                                                                                                                                                            block358: {
                                                                                                                                                                                                                                                                                                                                block336: {
                                                                                                                                                                                                                                                                                                                                    block357: {
                                                                                                                                                                                                                                                                                                                                        block356: {
                                                                                                                                                                                                                                                                                                                                            block355: {
                                                                                                                                                                                                                                                                                                                                                block354: {
                                                                                                                                                                                                                                                                                                                                                    block353: {
                                                                                                                                                                                                                                                                                                                                                        block352: {
                                                                                                                                                                                                                                                                                                                                                            block351: {
                                                                                                                                                                                                                                                                                                                                                                block350: {
                                                                                                                                                                                                                                                                                                                                                                    block349: {
                                                                                                                                                                                                                                                                                                                                                                        block348: {
                                                                                                                                                                                                                                                                                                                                                                            block347: {
                                                                                                                                                                                                                                                                                                                                                                                block346: {
                                                                                                                                                                                                                                                                                                                                                                                    block345: {
                                                                                                                                                                                                                                                                                                                                                                                        block344: {
                                                                                                                                                                                                                                                                                                                                                                                            block343: {
                                                                                                                                                                                                                                                                                                                                                                                                block342: {
                                                                                                                                                                                                                                                                                                                                                                                                    block341: {
                                                                                                                                                                                                                                                                                                                                                                                                        block340: {
                                                                                                                                                                                                                                                                                                                                                                                                            block339: {
                                                                                                                                                                                                                                                                                                                                                                                                                block338: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block337: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block287: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block335: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block334: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block333: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block332: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block331: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block330: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block329: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block328: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block327: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block326: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block325: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block324: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block323: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block322: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block321: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block320: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block319: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block318: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block317: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block316: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block315: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block314: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block313: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block312: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block311: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block310: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block309: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block308: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block307: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block306: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block305: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block304: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block303: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block302: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block301: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block300: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block299: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block298: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block297: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block296: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block295: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block294: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block293: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block292: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block291: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block290: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block289: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block288: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block284: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block286: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block285: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block283: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block280: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block281: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block279: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block278: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block277: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block253: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block276: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block271: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block275: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block274: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block273: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block272: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block270: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block269: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block268: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block267: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block265: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block266: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block262: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block264: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block263: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block261: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block257: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block260: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block259: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block258: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block254: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block255: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (t == null || t.isLeaf()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return t;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (root == null || t.equals(root)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parent = null;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parentStr = "";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parent = t.parent(root);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                parentStr = parent.label().value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (parent == null || parent.equals(root)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                grandParentStr = "";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Tree grandParent = parent.parent(root);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                grandParentStr = grandParent.label().value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseParentStr = this.tlp.basicCategory(parentStr);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseGrandParentStr = this.tlp.basicCategory(grandParentStr);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            CoreLabel lab = (CoreLabel)t.label();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            word = lab.word();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            tag = lab.tag();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseTag = this.tlp.basicCategory(tag);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = lab.value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            baseCat = this.tlp.basicCategory(cat);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!t.isPreTerminal()) break block251;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!this.englishTrain.correctTags) break block252;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("NP")) break block253;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("IN")) break block254;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equalsIgnoreCase("a") && !word.equalsIgnoreCase("that")) break block255;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("so") || word.equalsIgnoreCase("about")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("fiscal") || word.equalsIgnoreCase("next")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("RB")) break block257;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("McNally")) break block258;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("multifamily")) break block259;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("MORE")) break block260;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("hand")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("fist")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("RP")) break block261;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("Howard")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (word.equals("whole")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("JJ")) break block262;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("U.S.")) break block263;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("ours")) break block264;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "PRP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("mine")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("Sept.")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("NN")) break block265;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("Chapman") && !word.equals("Jan.") && !word.equals("Sept.") && !word.equals("Oct.") && !word.equals("Nov.") && !word.equals("Dec.")) break block266;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("members") || word.equals("bureaus") || word.equals("days") || word.equals("outfits") || word.equals("institutes") || word.equals("innings") || word.equals("write-offs") || word.equals("wines") || word.equals("trade-offs") || word.equals("tie-ins") || word.equals("thrips") || word.equals("1980s") || word.equals("1920s")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (word.equals("this")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals(":")) break block267;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("'")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "''");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("NNS")) break block268;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("start-up") || word.equals("ground-handling") || word.equals("word-processing") || word.equals("T-shirt") || word.equals("co-pilot")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("Sens.") || word.equals("Aichi")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("VBZ")) break block269;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("'s")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "POS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (!word.equals("kills")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("VBG")) break block270;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("preferred")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("VB")) break block271;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("The")) break block272;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("allowed")) break block273;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("short") && !word.equals("key") && !word.equals("many") && !word.equals("last") && !word.equals("further")) break block274;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("lower")) break block275;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Nov.") || word.equals("Jan.") || word.equals("Dec.") || word.equals("Tandy") || word.equals("Release") || word.equals("Orkem")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (word.equals("watch") || word.equals("review") || word.equals("risk") || word.equals("realestate") || word.equals("love") || word.equals("experience") || word.equals("control") || word.equals("Transport") || word.equals("mind") || word.equals("term") || word.equals("program") || word.equals("gender") || word.equals("audit") || word.equals("blame") || word.equals("stock") || word.equals("run") || word.equals("group") || word.equals("affect") || word.equals("rent") || word.equals("show") || word.equals("accord") || word.equals("change") || word.equals("finish") || word.equals("work") || word.equals("schedule") || word.equals("influence") || word.equals("school") || word.equals("freight") || word.equals("growth") || word.equals("travel") || word.equals("call") || word.equals("autograph") || word.equals("demand") || word.equals("abuse") || word.equals("return") || word.equals("defeat") || word.equals("pressure") || word.equals("bank") || word.equals("notice") || word.equals("tax") || word.equals("ooze") || word.equals("network") || word.equals("concern") || word.equals("pit") || word.equals("contract") || word.equals("cash")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("NNP")) break block276;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (word.equals("Officials")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (word.equals("Currently")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("PRP")) break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("her") && parent.numChildren() > 1) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "PRP$");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (word.equals("US")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseParentStr.equals("WHNP")) break block277;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (baseCat.equals("VBP") && word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "WDT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("UCP")) break block278;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("multifamily")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseParentStr.equals("PRT")) break block279;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (baseCat.equals("RBR") && word.equals("in")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (baseCat.equals("NNP") && word.equals("up")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("PP")) break block280;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (parentStr.equals("PP-TMP") && baseCat.equals("RP")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("in") || !baseCat.equals("RP") && !baseCat.equals("NN")) break block281;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (baseCat.equals("RB")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("for") || word.equals("After")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (word.equals("if") && baseCat.equals("JJ")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("VP")) break block282;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("NNS")) break block283;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("IN")) break block284;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("complicated")) break block285;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("post")) break block286;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (word.equals("like")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (word.equals("off")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("NN")) break block287;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.endsWith("ing")) break block288;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("bid")) break block289;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("are")) break block290;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("lure")) break block291;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("cost")) break block292;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("agreed")) break block293;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("restructure")) break block294;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("rule")) break block295;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("fret")) break block296;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("retort")) break block297;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("draft")) break block298;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("will")) break block299;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "MD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("yield")) break block300;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("lure")) break block301;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("feel")) break block302;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("institutes")) break block303;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("share")) break block304;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("trade")) break block305;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("beat")) break block306;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("effect")) break block307;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("speed")) break block308;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("work")) break block309;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("act")) break block310;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("drop")) break block311;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("stand")) break block312;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("push")) break block313;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("service")) break block314;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("set")) break block315;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("appeal")) break block316;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("mold")) break block317;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("mean")) break block318;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("reconfirm")) break block319;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("land")) break block320;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("point")) break block321;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("rise")) break block322;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("pressured")) break block323;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("smell")) break block324;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("pay")) break block325;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("hum")) break block326;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("shape")) break block327;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("benefit")) break block328;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("abducted")) break block329;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("look")) break block330;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("fare")) break block331;
                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("change")) break block332;
                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("farm")) break block333;
                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("increase")) break block334;
                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("stem")) break block335;
                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("rebounded")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (word.equals("face")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("NNP")) break block336;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("GRAB")) break block337;
                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("mature")) break block338;
                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("Face")) break block339;
                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("are")) break block340;
                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("Urging")) break block341;
                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("Finding")) break block342;
                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("say")) break block343;
                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("Added")) break block344;
                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("Adds")) break block345;
                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("BRACED")) break block346;
                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("REQUIRED")) break block347;
                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("SIZING")) break block348;
                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("REVIEW")) break block349;
                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("code-named")) break block350;
                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("Printed")) break block351;
                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("Rated")) break block352;
                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("FALTERS")) break block353;
                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("Got")) break block354;
                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (!word.equals("JUMPING")) break block355;
                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (!word.equals("Branching")) break block356;
                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (!word.equals("Excluding")) break block357;
                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (word.equals("Adds")) {
                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                                    } else if (word.equals("OKing")) {
                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("POS")) break block358;
                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("VBD")) break block359;
                                                                                                                                                                                                                                                                                                                            if (word.equals("heaves")) {
                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("VB")) break block360;
                                                                                                                                                                                                                                                                                                                        if (word.equals("allowed") || word.equals("increased")) {
                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("VBN")) break block361;
                                                                                                                                                                                                                                                                                                                    if (word.equals("has")) {
                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                                    } else if (word.equals("grew") || word.equals("fell")) {
                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (!baseCat.equals("JJ")) break block362;
                                                                                                                                                                                                                                                                                                                if (word.equals("own")) {
                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("being")) {
                                                                                                                                                                                                                                                                                                                if (!cat.equals("VBG")) {
                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                                            } else if (word.equalsIgnoreCase("all")) {
                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (!baseParentStr.equals("S")) break block363;
                                                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("all")) {
                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("ADJP")) break block364;
                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("UH")) break block365;
                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (!baseCat.equals("JJ")) break block366;
                                                                                                                                                                                                                                                                                                if (word.equalsIgnoreCase("more")) {
                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (!baseCat.equals("RB")) break block367;
                                                                                                                                                                                                                                                                                            if (!word.equalsIgnoreCase("free")) break block368;
                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (!word.equalsIgnoreCase("clear")) break block369;
                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (!word.equalsIgnoreCase("tight")) break block370;
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (word.equalsIgnoreCase("sure")) {
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                                } else if (word.equalsIgnoreCase("particular")) {
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (!baseCat.equals("VB")) break block256;
                                                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("stock")) {
                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                                            } else if (word.equalsIgnoreCase("secure")) {
                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (!baseParentStr.equals("QP")) break block371;
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("about")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                                        } else if (baseCat.equals("JJ") && word.equalsIgnoreCase("more")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("ADVP")) break block372;
                                                                                                                                                                                                                                                                    if (!baseCat.equals("EX")) break block373;
                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (baseCat.equals("NN") && word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                                } else if (baseCat.equals("NNP") && (word.endsWith("ly") || word.equals("Overall"))) {
                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (!baseParentStr.equals("SBAR")) break block374;
                                                                                                                                                                                                                                                            if ((word.equalsIgnoreCase("that") || word.equalsIgnoreCase("because") || word.equalsIgnoreCase("while")) && !baseCat.equals("IN")) {
                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                                            } else if ((word.equals("Though") || word.equals("Whether")) && baseCat.equals("NNP")) {
                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (!baseParentStr.equals("SBARQ")) break block375;
                                                                                                                                                                                                                                                        if (baseCat.equals("S") && word.equalsIgnoreCase("had")) {
                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "SQ");
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (!baseCat.equals("JJS")) break block376;
                                                                                                                                                                                                                                                    if (word.equalsIgnoreCase("less")) {
                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (!baseCat.equals("JJ")) break block377;
                                                                                                                                                                                                                                                if (word.equalsIgnoreCase("%")) {
                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                } else if (word.equalsIgnoreCase("to")) {
                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "TO");
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (!baseCat.equals("VB")) break block378;
                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("even")) {
                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (!baseCat.equals(",")) break block379;
                                                                                                                                                                                                                                        if (!word.equals("2")) break block380;
                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "CD");
                                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!word.equals("an")) break block381;
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (!word.equals("Wa")) break block382;
                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (word.equals("section")) {
                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                                            } else if (word.equals("underwriters")) {
                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (!baseCat.equals("CD")) break block383;
                                                                                                                                                                                                                        if (word.equals("high-risk")) {
                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        break block256;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (!baseCat.equals("RB")) break block384;
                                                                                                                                                                                                                    if (word.equals("for")) {
                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!baseCat.equals("RP")) break block385;
                                                                                                                                                                                                                if (word.equals("for")) {
                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                }
                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (!baseCat.equals("NN")) break block386;
                                                                                                                                                                                                            if (word.length() == 2 && word.charAt(1) == '.' && Character.isUpperCase(word.charAt(0))) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                break block256;
                                                                                                                                                                                                            } else if (word.equals("Lorillard")) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                            }
                                                                                                                                                                                                            break block256;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (word.equals("for") || word.equals("at")) {
                                                                                                                                                                                                            if (!baseCat.equals("IN")) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                            }
                                                                                                                                                                                                        } else if (word.equalsIgnoreCase("and") && !baseCat.equals("CC")) {
                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "CC");
                                                                                                                                                                                                        } else if (word.equals("ago") && !baseCat.equals("RB")) {
                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                    baseCat = this.tlp.basicCategory(cat);
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.englishTrain.makePPTOintoIN > 0 && baseCat.equals("TO") && !baseParentStr.equals("VP") && !baseParentStr.equals("CONJP") && !baseParentStr.startsWith("S")) {
                                                                                                                                                                                                    cat = this.englishTrain.makePPTOintoIN == 1 ? this.changeBaseCat(cat, "IN") : cat + "-IN";
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.englishTrain.splitIN == 5 && baseCat.equals("TO") && grandParentStr.charAt(0) == 'N' && (parentStr.charAt(0) == 'P' || parentStr.charAt(0) == 'A')) {
                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN") + "-N";
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.englishTrain.splitIN != 1 || !baseCat.equals("IN") || parentStr.charAt(0) != 'S') break block387;
                                                                                                                                                                                                cat = cat + "^S";
                                                                                                                                                                                                break block388;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (this.englishTrain.splitIN != 2 || !baseCat.equals("IN")) break block389;
                                                                                                                                                                                            if (parentStr.charAt(0) == 'S') {
                                                                                                                                                                                                cat = cat + "^S";
                                                                                                                                                                                                break block388;
                                                                                                                                                                                            } else if (grandParentStr.charAt(0) == 'N') {
                                                                                                                                                                                                cat = cat + "^N";
                                                                                                                                                                                            }
                                                                                                                                                                                            break block388;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (this.englishTrain.splitIN != 3 || !baseCat.equals("IN")) break block390;
                                                                                                                                                                                        if (grandParentStr.charAt(0) != 'N' || parentStr.charAt(0) != 'P' && parentStr.charAt(0) != 'A') break block391;
                                                                                                                                                                                        cat = cat + "-N";
                                                                                                                                                                                        break block388;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block392;
                                                                                                                                                                                    cat = cat + "-Q";
                                                                                                                                                                                    break block388;
                                                                                                                                                                                }
                                                                                                                                                                                if (grandParentStr.equals("S")) {
                                                                                                                                                                                    cat = baseParentStr.equals("SBAR") ? cat + "-SCC" : cat + "-SC";
                                                                                                                                                                                    break block388;
                                                                                                                                                                                } else if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP")) {
                                                                                                                                                                                    cat = cat + "-T";
                                                                                                                                                                                }
                                                                                                                                                                                break block388;
                                                                                                                                                                            }
                                                                                                                                                                            if (this.englishTrain.splitIN < 4 || this.englishTrain.splitIN > 5 || !baseCat.equals("IN")) break block393;
                                                                                                                                                                            if (grandParentStr.charAt(0) != 'N' || parentStr.charAt(0) != 'P' && parentStr.charAt(0) != 'A') break block394;
                                                                                                                                                                            cat = cat + "-N";
                                                                                                                                                                            break block388;
                                                                                                                                                                        }
                                                                                                                                                                        if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block395;
                                                                                                                                                                        cat = cat + "-Q";
                                                                                                                                                                        break block388;
                                                                                                                                                                    }
                                                                                                                                                                    if (baseGrandParentStr.charAt(0) != 'S' || baseGrandParentStr.equals("SBAR")) break block396;
                                                                                                                                                                    if (baseParentStr.equals("SBAR")) {
                                                                                                                                                                        cat = cat + "-SCC";
                                                                                                                                                                        break block388;
                                                                                                                                                                    } else if (!baseParentStr.equals("NP") && !baseParentStr.equals("ADJP")) {
                                                                                                                                                                        cat = cat + "-SC";
                                                                                                                                                                    }
                                                                                                                                                                    break block388;
                                                                                                                                                                }
                                                                                                                                                                if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP") || baseParentStr.equals("WHADVP")) {
                                                                                                                                                                    cat = cat + "-T";
                                                                                                                                                                }
                                                                                                                                                                break block388;
                                                                                                                                                            }
                                                                                                                                                            if (this.englishTrain.splitIN != 6 || !baseCat.equals("IN")) break block388;
                                                                                                                                                            if (grandParentStr.charAt(0) != 'V' && grandParentStr.charAt(0) != 'A') break block397;
                                                                                                                                                            cat = cat + "-V";
                                                                                                                                                            break block388;
                                                                                                                                                        }
                                                                                                                                                        if (grandParentStr.charAt(0) == 'N' && (parentStr.charAt(0) == 'P' || parentStr.charAt(0) == 'A')) break block388;
                                                                                                                                                        if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block398;
                                                                                                                                                        cat = cat + "-Q";
                                                                                                                                                        break block388;
                                                                                                                                                    }
                                                                                                                                                    if (baseGrandParentStr.charAt(0) != 'S' || baseGrandParentStr.equals("SBAR")) break block399;
                                                                                                                                                    if (baseParentStr.equals("SBAR")) {
                                                                                                                                                        cat = cat + "-SCC";
                                                                                                                                                        break block388;
                                                                                                                                                    } else if (!baseParentStr.equals("NP") && !baseParentStr.equals("ADJP")) {
                                                                                                                                                        cat = cat + "-SC";
                                                                                                                                                    }
                                                                                                                                                    break block388;
                                                                                                                                                }
                                                                                                                                                if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP") || baseParentStr.equals("WHADVP")) {
                                                                                                                                                    cat = cat + "-T";
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitPercent && word.equals("%")) {
                                                                                                                                                cat = cat + "-%";
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitNNP > 0 && baseCat.startsWith("NNP")) {
                                                                                                                                                if (this.englishTrain.splitNNP == 1) {
                                                                                                                                                    if (baseCat.equals("NNP")) {
                                                                                                                                                        cat = parent.numChildren() == 1 ? cat + "-S" : (parent.firstChild().equals(t) ? cat + "-L" : (parent.lastChild().equals(t) ? cat + "-R" : cat + "-I"));
                                                                                                                                                    }
                                                                                                                                                } else if (this.englishTrain.splitNNP == 2) {
                                                                                                                                                    if (word.matches("[A-Z]\\.?")) {
                                                                                                                                                        cat = cat + "-I";
                                                                                                                                                    } else if (EnglishTreebankParserParams.firstOfSeveralNNP(parent, t)) {
                                                                                                                                                        cat = cat + "-B";
                                                                                                                                                    } else if (EnglishTreebankParserParams.lastOfSeveralNNP(parent, t)) {
                                                                                                                                                        cat = cat + "-E";
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitQuotes && (word.equals("'") || word.equals("`"))) {
                                                                                                                                                cat = cat + "-SG";
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitSFP && baseTag.equals(".")) {
                                                                                                                                                if (word.equals("?")) {
                                                                                                                                                    cat = cat + "-QUES";
                                                                                                                                                } else if (word.equals("!")) {
                                                                                                                                                    cat = cat + "-EXCL";
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.tagRBGPA && baseCat.equals("RB")) {
                                                                                                                                                cat = cat + "^" + baseGrandParentStr;
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.joinPound && baseCat.equals("#")) {
                                                                                                                                                cat = this.changeBaseCat(cat, "$");
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.joinNounTags) {
                                                                                                                                                if (baseCat.equals("NNP")) {
                                                                                                                                                    cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                } else if (baseCat.equals("NNPS")) {
                                                                                                                                                    cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.joinJJ && cat.startsWith("JJ")) {
                                                                                                                                                cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitPPJJ && cat.startsWith("JJ") && parentStr.startsWith("PP")) {
                                                                                                                                                cat = cat + "^S";
                                                                                                                                            }
                                                                                                                                            if (!this.englishTrain.splitTRJJ || !cat.startsWith("JJ") || !parentStr.startsWith("PP") && !parentStr.startsWith("ADJP") || this.headFinder().determineHead(parent) != t) break block400;
                                                                                                                                            kids2 = parent.children();
                                                                                                                                            foundJJ = false;
                                                                                                                                            for (i2 = 0; i2 < kids2.length && !foundJJ; ++i2) {
                                                                                                                                                if (!kids2[i2].label().value().startsWith("JJ")) continue;
                                                                                                                                                foundJJ = true;
                                                                                                                                            }
                                                                                                                                            break block401;
                                                                                                                                        }
                                                                                                                                        kids = t.children();
                                                                                                                                        if (!baseCat.equals("VP")) break block250;
                                                                                                                                        if (this.englishTrain.gpaRootVP && this.tlp.isStartSymbol(baseGrandParentStr)) {
                                                                                                                                            cat = cat + "~ROOT";
                                                                                                                                        }
                                                                                                                                        if (!this.englishTrain.splitVPNPAgr) break block402;
                                                                                                                                        if (baseTag.equals("VBD") || baseTag.equals("MD")) {
                                                                                                                                            cat = cat + "-VBF";
                                                                                                                                            break block250;
                                                                                                                                        } else if (baseTag.equals("VBZ") || baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBP") || baseTag.equals("VBN") || baseTag.equals("VB")) {
                                                                                                                                            cat = cat + "-" + baseTag;
                                                                                                                                            break block250;
                                                                                                                                        } else {
                                                                                                                                            System.err.println("XXXX Head of " + t + " is " + word + "/" + baseTag);
                                                                                                                                        }
                                                                                                                                        break block250;
                                                                                                                                    }
                                                                                                                                    if (this.englishTrain.splitVP != 3 && this.englishTrain.splitVP != 4) break block403;
                                                                                                                                    if (!baseTag.equals("VBZ") && !baseTag.equals("VBD") && !baseTag.equals("VBP") && !baseTag.equals("MD")) break block404;
                                                                                                                                    cat = cat + "-VBF";
                                                                                                                                    break block250;
                                                                                                                                }
                                                                                                                                if (baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBN") || baseTag.equals("VB")) {
                                                                                                                                    cat = cat + "-" + baseTag;
                                                                                                                                    break block250;
                                                                                                                                } else if (this.englishTrain.splitVP == 4) {
                                                                                                                                    String dTag = EnglishTreebankParserParams.deduceTag(word);
                                                                                                                                    cat = cat + "-" + dTag;
                                                                                                                                }
                                                                                                                                break block250;
                                                                                                                            }
                                                                                                                            if (this.englishTrain.splitVP == 2) {
                                                                                                                                cat = baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD") ? cat + "-VBF" : cat + "-" + baseTag;
                                                                                                                            } else if (this.englishTrain.splitVP == 1) {
                                                                                                                                cat = cat + "-" + baseTag;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.englishTrain.dominatesV > 0) {
                                                                                                                            if (this.englishTrain.dominatesV == 2) {
                                                                                                                                if (EnglishTreebankParserParams.hasClausalV(t)) {
                                                                                                                                    cat = cat + "-v";
                                                                                                                                }
                                                                                                                            } else if (this.englishTrain.dominatesV == 3) {
                                                                                                                                if (!(!EnglishTreebankParserParams.hasV(t.preTerminalYield()) || baseCat.equals("WHPP") || baseCat.equals("RRC") || baseCat.equals("QP") || baseCat.equals("PRT"))) {
                                                                                                                                    cat = cat + "-v";
                                                                                                                                }
                                                                                                                            } else if (EnglishTreebankParserParams.hasV(t.preTerminalYield())) {
                                                                                                                                cat = cat + "-v";
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.englishTrain.dominatesI && EnglishTreebankParserParams.hasI(t.preTerminalYield())) {
                                                                                                                            cat = cat + "-i";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.dominatesC && EnglishTreebankParserParams.hasC(t.preTerminalYield())) {
                                                                                                                            cat = cat + "-c";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitNPpercent > 0 && word.equals("%") && (baseCat.equals("NP") || this.englishTrain.splitNPpercent > 1 && baseCat.equals("ADJP") || this.englishTrain.splitNPpercent > 2 && baseCat.equals("QP") || this.englishTrain.splitNPpercent > 3)) {
                                                                                                                            cat = cat + "-%";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitNPPRP && baseTag.equals("PRP")) {
                                                                                                                            cat = cat + "-PRON";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitSbar > 0 && baseCat.equals("SBAR")) {
                                                                                                                            boolean foundIn = false;
                                                                                                                            boolean foundOrder = false;
                                                                                                                            boolean infinitive = baseTag.equals("TO");
                                                                                                                            for (int i3 = 0; i3 < kids.length; ++i3) {
                                                                                                                                if (kids[i3].isPreTerminal() && kids[i3].children()[0].value().equalsIgnoreCase("in")) {
                                                                                                                                    foundIn = true;
                                                                                                                                }
                                                                                                                                if (!kids[i3].isPreTerminal() || !kids[i3].children()[0].value().equalsIgnoreCase("order")) continue;
                                                                                                                                foundOrder = true;
                                                                                                                            }
                                                                                                                            if (this.englishTrain.splitSbar > 1 && infinitive) {
                                                                                                                                cat = cat + "-INF";
                                                                                                                            }
                                                                                                                            if ((this.englishTrain.splitSbar == 1 || this.englishTrain.splitSbar == 3) && foundIn && foundOrder) {
                                                                                                                                cat = cat + "-PURP";
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitNPNNP <= 0) break block405;
                                                                                                                        if (this.englishTrain.splitNPNNP != 1 || !baseCat.equals("NP") || !baseTag.equals("NNP")) break block406;
                                                                                                                        cat = cat + "-NNP";
                                                                                                                        break block405;
                                                                                                                    }
                                                                                                                    if (this.englishTrain.splitNPNNP != 2 || !baseCat.equals("NP") || !baseTag.startsWith("NNP")) break block407;
                                                                                                                    cat = cat + "-NNP";
                                                                                                                    break block405;
                                                                                                                }
                                                                                                                if (this.englishTrain.splitNPNNP != 3 || !baseCat.equals("NP")) break block405;
                                                                                                                split = false;
                                                                                                                break block408;
                                                                                                            }
                                                                                                            for (int j = i2; j < kids2.length; ++j) {
                                                                                                                if (!kids2[j].label().value().startsWith("NP")) continue;
                                                                                                                cat = cat + "^T";
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (this.englishTrain.splitJJCOMP && cat.startsWith("JJ") && (parentStr.startsWith("PP") || parentStr.startsWith("ADJP")) && this.headFinder().determineHead(parent) == t) {
                                                                                                            kids2 = parent.children();
                                                                                                            foundJJ = false;
                                                                                                            for (i2 = 0; i2 < kids2.length && !foundJJ && !kids2[i2].label().value().startsWith("JJ"); ++i2) {
                                                                                                            }
                                                                                                            if (i2 < kids2.length - 1) {
                                                                                                                cat = cat + "^CMPL";
                                                                                                            }
                                                                                                        }
                                                                                                        if (this.englishTrain.splitMoreLess && ((ch = cat.charAt(0)) == 'R' || ch == 'J' || ch == 'C') && (word.equalsIgnoreCase("more") || word.equalsIgnoreCase("most") || word.equalsIgnoreCase("less") || word.equalsIgnoreCase("least"))) {
                                                                                                            cat = cat + "-ML";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryDT && cat.startsWith("DT") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryRB && cat.startsWith("RB") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.markReflexivePRP && cat.startsWith("PRP") && (word.equalsIgnoreCase("itself") || word.equalsIgnoreCase("themselves") || word.equalsIgnoreCase("himself") || word.equalsIgnoreCase("herself") || word.equalsIgnoreCase("ourselves") || word.equalsIgnoreCase("yourself") || word.equalsIgnoreCase("yourselves") || word.equalsIgnoreCase("myself") || word.equalsIgnoreCase("thyself"))) {
                                                                                                            cat = cat + "-SE";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryPRP && cat.startsWith("PRP") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryIN && cat.startsWith("IN") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.splitCC <= 0 || !baseCat.equals("CC")) break block409;
                                                                                                        if (this.englishTrain.splitCC != 1 || !word.equals("and") && !word.equals("or")) break block410;
                                                                                                        cat = cat + "-C";
                                                                                                        break block409;
                                                                                                    }
                                                                                                    if (this.englishTrain.splitCC != 2) break block411;
                                                                                                    if (word.equalsIgnoreCase("but")) {
                                                                                                        cat = cat + "-B";
                                                                                                        break block409;
                                                                                                    } else if (word.equals("&")) {
                                                                                                        cat = cat + "-A";
                                                                                                    }
                                                                                                    break block409;
                                                                                                }
                                                                                                if (this.englishTrain.splitCC == 3 && word.equalsIgnoreCase("and")) {
                                                                                                    cat = cat + "-A";
                                                                                                }
                                                                                            }
                                                                                            if (this.englishTrain.splitNOT && baseCat.equals("RB") && (word.equalsIgnoreCase("n't") || word.equalsIgnoreCase("not") || word.equalsIgnoreCase("nt"))) {
                                                                                                cat = cat + "-N";
                                                                                            } else if (this.englishTrain.splitRB && baseCat.equals("RB") && (baseParentStr.equals("NP") || baseParentStr.equals("QP") || baseParentStr.equals("ADJP"))) {
                                                                                                cat = cat + "^M";
                                                                                            }
                                                                                            if (this.englishTrain.splitAux <= 1 || !baseCat.equals("VBZ") && !baseCat.equals("VBP") && !baseCat.equals("VBD") && !baseCat.equals("VBN") && !baseCat.equals("VBG") && !baseCat.equals("VB")) break block412;
                                                                                            if (!word.equalsIgnoreCase("'s") && !word.equalsIgnoreCase("s")) break block413;
                                                                                            sisters = parent.children();
                                                                                            boolean foundMe = false;
                                                                                            for (i2 = 0; i2 < sisters.length && !foundMe; ++i2) {
                                                                                                if (!sisters[i2].label().value().startsWith("VBZ")) continue;
                                                                                                foundMe = true;
                                                                                            }
                                                                                            annotateHave = false;
                                                                                            break block414;
                                                                                        }
                                                                                        if (!word.equalsIgnoreCase("am") && !word.equalsIgnoreCase("is") && !word.equalsIgnoreCase("are") && !word.equalsIgnoreCase("was") && !word.equalsIgnoreCase("were") && !word.equalsIgnoreCase("'m") && !word.equalsIgnoreCase("'re") && !word.equalsIgnoreCase("be") && !word.equalsIgnoreCase("being") && !word.equalsIgnoreCase("been") && !word.equalsIgnoreCase("ai")) break block415;
                                                                                        cat = cat + "-BE";
                                                                                        break block416;
                                                                                    }
                                                                                    if (!word.equalsIgnoreCase("have") && !word.equalsIgnoreCase("'ve") && !word.equalsIgnoreCase("having") && !word.equalsIgnoreCase("has") && !word.equalsIgnoreCase("had") && !word.equalsIgnoreCase("'d")) break block417;
                                                                                    cat = cat + "-HV";
                                                                                    break block416;
                                                                                }
                                                                                if (this.englishTrain.splitAux < 3 || !word.equalsIgnoreCase("do") && !word.equalsIgnoreCase("did") && !word.equalsIgnoreCase("does") && !word.equalsIgnoreCase("done") && !word.equalsIgnoreCase("doing")) break block418;
                                                                                cat = cat + "-DO";
                                                                                break block416;
                                                                            }
                                                                            if (this.englishTrain.splitAux < 4 || !word.equalsIgnoreCase("help") && !word.equalsIgnoreCase("helps") && !word.equalsIgnoreCase("helped") && !word.equalsIgnoreCase("helping")) break block419;
                                                                            cat = cat + "-DO";
                                                                            break block416;
                                                                        }
                                                                        if (this.englishTrain.splitAux < 5 || !word.equalsIgnoreCase("let") && !word.equalsIgnoreCase("lets") && !word.equalsIgnoreCase("letting")) break block420;
                                                                        cat = cat + "-DO";
                                                                        break block416;
                                                                    }
                                                                    if (this.englishTrain.splitAux < 6 || !word.equalsIgnoreCase("make") && !word.equalsIgnoreCase("makes") && !word.equalsIgnoreCase("making") && !word.equalsIgnoreCase("made")) break block421;
                                                                    cat = cat + "-DO";
                                                                    break block416;
                                                                }
                                                                if (this.englishTrain.splitAux < 7 || !word.equalsIgnoreCase("watch") && !word.equalsIgnoreCase("watches") && !word.equalsIgnoreCase("watching") && !word.equalsIgnoreCase("watched") && !word.equalsIgnoreCase("see") && !word.equalsIgnoreCase("sees") && !word.equalsIgnoreCase("seeing") && !word.equalsIgnoreCase("saw") && !word.equalsIgnoreCase("seen")) break block422;
                                                                cat = cat + "-DO";
                                                                break block416;
                                                            }
                                                            if (this.englishTrain.splitAux >= 8 && (word.equalsIgnoreCase("go") || word.equalsIgnoreCase("come"))) {
                                                                cat = cat + "-DO";
                                                                break block416;
                                                            } else if (this.englishTrain.splitAux >= 9 && (word.equalsIgnoreCase("get") || word.equalsIgnoreCase("gets") || word.equalsIgnoreCase("getting") || word.equalsIgnoreCase("got") || word.equalsIgnoreCase("gotten"))) {
                                                                cat = cat + "-BE";
                                                            }
                                                            break block416;
                                                        }
                                                        if (this.englishTrain.splitAux > 0 && (baseCat.equals("VBZ") || baseCat.equals("VBP") || baseCat.equals("VBD") || baseCat.equals("VBN") || baseCat.equals("VBG") || baseCat.equals("VB"))) {
                                                            if (word.equalsIgnoreCase("is") || word.equalsIgnoreCase("am") || word.equalsIgnoreCase("are") || word.equalsIgnoreCase("was") || word.equalsIgnoreCase("were") || word.equalsIgnoreCase("'m") || word.equalsIgnoreCase("'re") || word.equalsIgnoreCase("'s") || word.equalsIgnoreCase("being") || word.equalsIgnoreCase("be") || word.equalsIgnoreCase("been")) {
                                                                cat = cat + "-BE";
                                                            }
                                                            if (word.equalsIgnoreCase("have") || word.equalsIgnoreCase("'ve") || word.equalsIgnoreCase("having") || word.equalsIgnoreCase("has") || word.equalsIgnoreCase("had") || word.equalsIgnoreCase("'d")) {
                                                                cat = cat + "-HV";
                                                            }
                                                        }
                                                        break block416;
                                                    }
                                                    for (int j = i2; j < sisters.length; ++j) {
                                                        if (!sisters[j].label().value().startsWith("VP")) continue;
                                                        Tree[] kids3 = sisters[j].children();
                                                        for (int k = 0; k < kids3.length; ++k) {
                                                            if (!kids3[k].label().value().startsWith("VBN") && !kids3[k].label().value().startsWith("VBD")) continue;
                                                            annotateHave = true;
                                                        }
                                                    }
                                                    cat = annotateHave ? cat + "-HV" : cat + "-BE";
                                                }
                                                if (this.englishTrain.markDitransV > 0 && cat.startsWith("VB")) {
                                                    cat = cat + this.ditrans(parent);
                                                } else if (this.englishTrain.vpSubCat && cat.startsWith("VB")) {
                                                    cat = cat + EnglishTreebankParserParams.subCatify(parent);
                                                }
                                                tag = cat;
                                                break block423;
                                            }
                                            for (int i4 = 0; i4 < kids.length; ++i4) {
                                                if (!kids[i4].value().startsWith("NNP")) continue;
                                                split = true;
                                                break;
                                            }
                                            if (split) {
                                                cat = cat + "-NNP";
                                            }
                                        }
                                        if (this.englishTrain.splitVPNPAgr && baseCat.equals("NP") && baseParentStr.startsWith("S")) {
                                            if (baseTag.equals("NNPS") || baseTag.equals("NNS")) {
                                                cat = cat + "-PL";
                                            } else if (word.equalsIgnoreCase("many") || word.equalsIgnoreCase("more") || word.equalsIgnoreCase("most") || word.equalsIgnoreCase("plenty")) {
                                                cat = cat + "-PL";
                                            } else if (!(baseTag.equals("NN") || baseTag.equals("NNP") || baseTag.equals("POS") || baseTag.equals("CD") || baseTag.equals("PRP$") || baseTag.equals("JJ") || baseTag.equals("EX") || baseTag.equals("$") || baseTag.equals("RB") || baseTag.equals("FW") || baseTag.equals("VBG") || baseTag.equals("JJS") || baseTag.equals("JJR"))) {
                                                if (baseTag.equals("PRP")) {
                                                    if (word.equalsIgnoreCase("they") || word.equalsIgnoreCase("them") || word.equalsIgnoreCase("we") || word.equalsIgnoreCase("us")) {
                                                        cat = cat + "-PL";
                                                    }
                                                } else if (baseTag.equals("DT") || baseTag.equals("WDT")) {
                                                    if (word.equalsIgnoreCase("these") || word.equalsIgnoreCase("those") || word.equalsIgnoreCase("several")) {
                                                        cat = cat + "-PL";
                                                    }
                                                } else {
                                                    System.err.println("XXXX Head of " + t + " is " + word + "/" + baseTag);
                                                }
                                            }
                                        }
                                        if (this.englishTrain.splitSTag > 0 && (baseCat.equals("S") || this.englishTrain.splitSTag <= 3 && (baseCat.equals("SINV") || baseCat.equals("SQ")))) {
                                            if (this.englishTrain.splitSTag == 1) {
                                                cat = cat + "-" + baseTag;
                                            } else if (baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD")) {
                                                cat = cat + "-VBF";
                                            } else if ((this.englishTrain.splitSTag == 3 || this.englishTrain.splitSTag == 5) && (baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBN") || baseTag.equals("VB"))) {
                                                cat = cat + "-VBNF";
                                            }
                                        }
                                        if (this.englishTrain.markContainedVP && this.containsVP(t)) {
                                            cat = cat + "-vp";
                                        }
                                        if (this.englishTrain.markCC > 0) {
                                            for (int i5 = 1; i5 < kids.length - 1; ++i5) {
                                                String cat22 = kids[i5].label().value();
                                                if (cat22.startsWith("CC")) {
                                                    String word2 = kids[i5].children()[0].value();
                                                    if (word2.equals("either") || word2.equals("both") || word2.equals("neither")) continue;
                                                    cat = cat + "-CC";
                                                    break;
                                                }
                                                if (this.englishTrain.markCC <= 1 || !cat22.startsWith("CONJP")) continue;
                                                cat = cat + "-CC";
                                                break;
                                            }
                                        }
                                        if (this.englishTrain.splitSGapped != 1 || !baseCat.equals("S") || kids[0].label().value().startsWith("NP")) break block424;
                                        cat = cat + "-G";
                                        break block425;
                                    }
                                    if (this.englishTrain.splitSGapped != 2 || !baseCat.equals("S")) break block426;
                                    seenPredCat3 = false;
                                    seenNP2 = 0;
                                    break block427;
                                }
                                if (this.englishTrain.splitSGapped != 3 || !baseCat.equals("S")) break block428;
                                seenPredCat2 = false;
                                seenCC = false;
                                seenS2 = false;
                                seenNP = 0;
                                break block429;
                            }
                            if (this.englishTrain.splitSGapped != 4 || !baseCat.equals("S")) break block425;
                            seenPredCat = false;
                            sawSBeforePredCat = false;
                            seenS = 0;
                            seenNP = 0;
                            break block430;
                        }
                        for (int i6 = 0; i6 < kids.length; ++i6) {
                            String cat23 = kids[i6].label().value();
                            if (cat23.startsWith("NP")) {
                                ++seenNP2;
                                continue;
                            }
                            if (!cat23.startsWith("VP") && !cat23.startsWith("ADJP") && !cat23.startsWith("PP") && !cat23.startsWith("UCP")) continue;
                            seenPredCat3 = true;
                        }
                        if (seenNP2 == 0 || seenNP2 == 1 && !seenPredCat3) {
                            cat = cat + "-G";
                        }
                        break block425;
                    }
                    for (i = 0; i < kids.length; ++i) {
                        cat2 = kids[i].label().value();
                        if (cat2.startsWith("NP")) {
                            ++seenNP;
                            continue;
                        }
                        if (cat2.startsWith("VP") || cat2.startsWith("ADJP") || cat2.startsWith("PP") || cat2.startsWith("UCP")) {
                            seenPredCat2 = true;
                            continue;
                        }
                        if (cat2.startsWith("CC")) {
                            seenCC = true;
                            continue;
                        }
                        if (!cat2.startsWith("S")) continue;
                        seenS2 = true;
                    }
                    if (!(seenCC && seenS2 || seenNP != 0 && (seenNP != 1 || seenPredCat2))) {
                        cat = cat + "-G";
                    }
                    break block425;
                }
                for (i = 0; i < kids.length; ++i) {
                    cat2 = kids[i].label().value();
                    if (cat2.startsWith("NP")) {
                        ++seenNP;
                        continue;
                    }
                    if (cat2.startsWith("VP") || cat2.startsWith("ADJP") || cat2.startsWith("PP") || cat2.startsWith("UCP")) {
                        seenPredCat = true;
                        continue;
                    }
                    if (!cat2.startsWith("S")) continue;
                    ++seenS;
                    if (seenPredCat) continue;
                    sawSBeforePredCat = true;
                }
                if (!(seenS >= 2 || sawSBeforePredCat && seenPredCat || seenNP != 0 && (seenNP != 1 || seenPredCat))) {
                    cat = cat + "-G";
                }
            }
            if (this.englishTrain.splitNumNP && baseCat.equals("NP")) {
                boolean seenNum = false;
                for (int i = 0; i < kids.length; ++i) {
                    String cat2 = kids[i].label().value();
                    if (!cat2.startsWith("QP") && !cat2.startsWith("CD") && !cat2.startsWith("$") && !cat2.startsWith("#") && (!cat2.startsWith("NN") || cat2.indexOf("-%") < 0)) continue;
                    seenNum = true;
                    break;
                }
                if (seenNum) {
                    cat = cat + "-NUM";
                }
            }
            if (this.englishTrain.splitPoss > 0 && baseCat.equals("NP") && kids[kids.length - 1].label().value().startsWith("POS")) {
                if (this.englishTrain.splitPoss == 2) {
                    CategoryWordTag labelBot = t.isPrePreTerminal() ? new CategoryWordTag("NP^POSSP-B", word, tag) : new CategoryWordTag("NP^POSSP", word, tag);
                    t.setLabel(labelBot);
                    List<Tree> oldKids = t.getChildrenAsList();
                    ArrayList<Tree> newKids = new ArrayList<Tree>();
                    for (int i = 0; i < oldKids.size() - 1; ++i) {
                        newKids.add(oldKids.get(i));
                    }
                    t.setChildren(newKids);
                    cat = this.changeBaseCat(cat, "POSSP");
                    CategoryWordTag labelTop = new CategoryWordTag(cat, word, tag);
                    ArrayList<Tree> newerChildren = new ArrayList<Tree>(2);
                    newerChildren.add(t);
                    Tree last = oldKids.get(oldKids.size() - 1);
                    if (!last.value().equals("POS^NP")) {
                        System.err.println("Unexpected POS value (!): " + last);
                    }
                    last.setValue("POS^POSSP");
                    newerChildren.add(last);
                    return categoryWordTagTreeFactory.newTreeNode(labelTop, newerChildren);
                }
                cat = cat + "-P";
            }
            if (this.englishTrain.splitBaseNP > 0 && baseCat.equals("NP") && t.isPrePreTerminal()) {
                if (this.englishTrain.splitBaseNP == 2) {
                    if (!parentStr.startsWith("NP")) {
                        CategoryWordTag labelBot = new CategoryWordTag("NP^NP-B", word, tag);
                        t.setLabel(labelBot);
                        CategoryWordTag labelTop = new CategoryWordTag(cat, word, tag);
                        ArrayList<Tree> newerChildren = new ArrayList<Tree>(1);
                        newerChildren.add(t);
                        return categoryWordTagTreeFactory.newTreeNode(labelTop, newerChildren);
                    }
                    cat = cat + "-B";
                } else {
                    cat = cat + "-B";
                }
            }
            if (this.englishTrain.rightPhrasal && EnglishTreebankParserParams.rightPhrasal(t)) {
                cat = cat + "-RX";
            }
        }
        t.setLabel(new CategoryWordTag(cat, word, tag));
        return t;
    }

    private boolean containsVP(Tree t) {
        String cat = this.tlp.basicCategory(t.label().value());
        if (cat.equals("VP")) {
            return true;
        }
        Tree[] kids = t.children();
        for (int i = 0; i < kids.length; ++i) {
            if (!this.containsVP(kids[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean firstOfSeveralNNP(Tree parent, Tree t) {
        boolean firstIsT = false;
        int numNNP = 0;
        Tree[] kids = parent.children();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].value().startsWith("NNP")) continue;
            if (t.equals(kids[i]) && numNNP == 0) {
                firstIsT = true;
            }
            ++numNNP;
        }
        return numNNP > 1 && firstIsT;
    }

    private static boolean lastOfSeveralNNP(Tree parent, Tree t) {
        Tree last = null;
        int numNNP = 0;
        Tree[] kids = parent.children();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].value().startsWith("NNP")) continue;
            ++numNNP;
            last = kids[i];
        }
        return numNNP > 1 && t.equals(last);
    }

    private static String deduceTag(String w) {
        String word = w.toLowerCase();
        if (word.endsWith("ing")) {
            return "VBG";
        }
        if (word.endsWith("d") || word.endsWith("t")) {
            return "VBN";
        }
        if (word.endsWith("s")) {
            return "VBZ";
        }
        if (word.equals("to")) {
            return "TO";
        }
        return "VB";
    }

    private static boolean rightPhrasal(Tree t) {
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith("NP") && !str.startsWith("PP") && !str.startsWith("VP") && !str.startsWith("S") && !str.startsWith("Q") && !str.startsWith("A")) continue;
            return true;
        }
        return false;
    }

    private static String subCatify(Tree t) {
        StringBuilder sb = new StringBuilder("^a");
        boolean n = false;
        boolean s = false;
        boolean p = false;
        for (int i = 0; i < t.children().length; ++i) {
            String childStr = t.children()[i].label().value();
            n = n || childStr.startsWith("NP");
            s = s || childStr.startsWith("S");
            p = p || childStr.startsWith("PP");
        }
        n = false;
        if (n) {
            sb.append("N");
        }
        if (p) {
            sb.append("P");
        }
        if (s) {
            sb.append("S");
        }
        return sb.toString();
    }

    private String ditrans(Tree t) {
        int n = 0;
        Tree[] kids = t.children();
        int len = kids.length;
        for (int i = 0; i < len; ++i) {
            String childStr = kids[i].label().value();
            if (childStr.startsWith("NP") && !childStr.contains("-TMP")) {
                ++n;
                continue;
            }
            if (this.englishTrain.markDitransV != 1 || !childStr.startsWith("S")) continue;
            ++n;
        }
        if (n >= 2) {
            return "^2Arg";
        }
        return "";
    }

    private String changeBaseCat(String cat, String newBaseCat) {
        int i;
        int leng = cat.length();
        for (i = 1; i < leng && !this.tlp.isLabelAnnotationIntroducingCharacter(cat.charAt(i)); ++i) {
        }
        if (i < leng) {
            return newBaseCat + cat.substring(i);
        }
        return newBaseCat;
    }

    private static boolean hasClausalV(Tree tree) {
        if (tree.isPhrasal()) {
            Tree[] kids;
            if (tree.isPrePreTerminal() && tree.value().startsWith("NP")) {
                return false;
            }
            for (Tree t : kids = tree.children()) {
                if (!EnglishTreebankParserParams.hasClausalV(t)) continue;
                return true;
            }
            return false;
        }
        String str = tree.value();
        return str.startsWith("VB") || str.startsWith("MD");
    }

    private static boolean hasV(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            String str = tags.get(i).toString();
            if (!str.startsWith("V") && !str.startsWith("MD")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasI(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            if (!tags.get(i).toString().startsWith("I")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasC(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            if (!tags.get(i).toString().startsWith("CC")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void display() {
        this.englishTrain.display();
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-splitIN")) {
            this.englishTrain.splitIN = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitPercent")) {
            this.englishTrain.splitPercent = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitQuotes")) {
            this.englishTrain.splitQuotes = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitSFP")) {
            this.englishTrain.splitSFP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNNP")) {
            this.englishTrain.splitNNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-rbGPA")) {
            this.englishTrain.tagRBGPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitTRJJ")) {
            this.englishTrain.splitTRJJ = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitJJCOMP")) {
            this.englishTrain.splitJJCOMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitMoreLess")) {
            this.englishTrain.splitMoreLess = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryDT")) {
            this.englishTrain.unaryDT = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryRB")) {
            this.englishTrain.unaryRB = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryIN")) {
            this.englishTrain.unaryIN = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markReflexivePRP")) {
            this.englishTrain.markReflexivePRP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitCC") && i + 1 < args.length) {
            this.englishTrain.splitCC = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitRB")) {
            this.englishTrain.splitRB = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitAux") && i + 1 < args.length) {
            this.englishTrain.splitAux = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSbar") && i + 1 < args.length) {
            this.englishTrain.splitSbar = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitVP") && i + 1 < args.length) {
            this.englishTrain.splitVP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitVPNPAgr")) {
            this.englishTrain.splitVPNPAgr = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gpaRootVP")) {
            this.englishTrain.gpaRootVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-makePPTOintoIN")) {
            this.englishTrain.makePPTOintoIN = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSTag")) {
            this.englishTrain.splitSTag = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSGapped") && i + 1 < args.length) {
            this.englishTrain.splitSGapped = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPpercent") && i + 1 < args.length) {
            this.englishTrain.splitNPpercent = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPPRP")) {
            this.englishTrain.splitNPPRP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesV") && i + 1 < args.length) {
            this.englishTrain.dominatesV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-dominatesI")) {
            this.englishTrain.dominatesI = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesC")) {
            this.englishTrain.dominatesC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNPNNP") && i + 1 < args.length) {
            this.englishTrain.splitNPNNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitTMP") && i + 1 < args.length) {
            this.englishTrain.splitTMP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPADV") && i + 1 < args.length) {
            this.englishTrain.splitNPADV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markContainedVP")) {
            this.englishTrain.markContainedVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markDitransV") && i + 1 < args.length) {
            this.englishTrain.markDitransV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitPoss") && i + 1 < args.length) {
            this.englishTrain.splitPoss = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-baseNP") && i + 1 < args.length) {
            this.englishTrain.splitBaseNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-joinNounTags")) {
            this.englishTrain.joinNounTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-correctTags")) {
            this.englishTrain.correctTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noCorrectTags")) {
            this.englishTrain.correctTags = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markCC") && i + 1 < args.length) {
            this.englishTrain.markCC = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noAnnotations")) {
            this.englishTrain.splitVP = 0;
            this.englishTrain.splitTMP = 0;
            this.englishTrain.splitSGapped = 0;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainNPTMPSubcategories")) {
            this.englishTest.retainNPTMPSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainTMPSubcategories")) {
            this.englishTest.retainTMPSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainADVSubcategories")) {
            this.englishTest.retainADVSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-leaveItAll") && i + 1 < args.length) {
            this.englishTrain.leaveItAll = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                this.headFinder = (HeadFinder)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println("Warning: Default HeadFinder will be used.");
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-makeCopulaHead")) {
            this.englishTest.makeCopulaHead = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-acl03pcfg")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 1;
            this.englishTrain.splitVP = 2;
            this.englishTrain.splitSGapped = 3;
            this.englishTrain.dominatesV = 1;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-jenny")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 1;
            this.englishTrain.splitVP = 2;
            this.englishTrain.splitSGapped = 3;
            this.englishTrain.dominatesV = 1;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-linguisticPCFG")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 2;
            this.englishTrain.splitVP = 3;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 0;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            this.englishTrain.splitMoreLess = true;
            this.englishTrain.correctTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-goodPCFG")) {
            this.englishTrain.splitIN = 4;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitNPpercent = 0;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 1;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 2;
            this.englishTrain.splitVP = 3;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 1;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitNPADV = 1;
            this.englishTrain.splitBaseNP = 1;
            this.englishTrain.correctTags = true;
            this.englishTrain.markDitransV = 2;
            ++i;
        } else if (args[i].equalsIgnoreCase("-ijcai03")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = false;
            this.englishTrain.unaryRB = false;
            this.englishTrain.splitAux = 0;
            this.englishTrain.splitVP = 2;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 0;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-goodFactored")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = false;
            this.englishTrain.unaryRB = false;
            this.englishTrain.splitAux = 0;
            this.englishTrain.splitVP = 3;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 0;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            this.englishTrain.correctTags = true;
            ++i;
        }
        return i;
    }

    public List<Word> defaultTestSentence() {
        String[] sent;
        ArrayList<Word> ret = new ArrayList<Word>();
        for (String str : sent = new String[]{"This", "is", "just", "a", "test", "."}) {
            ret.add(new Word(str));
        }
        return ret;
    }

    @Override
    public List<GrammaticalStructure> readGrammaticalStructureFromFile(String filename) {
        try {
            return EnglishGrammaticalStructure.readCoNLLXGrammaticStructureCollection(filename);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public GrammaticalStructure getGrammaticalStructure(Tree t, Filter<String> filter, HeadFinder hf) {
        return new EnglishGrammaticalStructure(t, filter, hf);
    }

    public static void main(String[] args) {
        EnglishTreebankParserParams tlpp = new EnglishTreebankParserParams();
        MemoryTreebank tb = tlpp.memoryTreebank();
        tb.loadPath(args[0]);
        for (Tree t : tb) {
            t.pennPrint();
        }
    }

    public static class EnglishTrain
    implements Serializable {
        public int leaveItAll = 0;
        public int splitIN = 0;
        public boolean splitQuotes = false;
        public boolean splitSFP = false;
        public boolean splitPercent = false;
        public int splitNPpercent = 0;
        public boolean tagRBGPA = false;
        public int splitNNP = 0;
        public boolean joinPound = false;
        public boolean joinJJ = false;
        public boolean joinNounTags = false;
        public boolean splitPPJJ = false;
        public boolean splitTRJJ = false;
        public boolean splitJJCOMP = false;
        public boolean splitMoreLess = false;
        public boolean unaryDT = false;
        public boolean unaryRB = false;
        public boolean unaryPRP = false;
        public boolean markReflexivePRP = false;
        public boolean unaryIN = false;
        public int splitCC = 0;
        public boolean splitNOT = false;
        public boolean splitRB = false;
        public int splitAux = 0;
        public boolean vpSubCat = false;
        public int markDitransV = 0;
        public int splitVP = 0;
        public boolean splitVPNPAgr = false;
        public int splitSTag = 0;
        public boolean markContainedVP = false;
        public boolean splitNPPRP = false;
        public int dominatesV = 0;
        public boolean dominatesI = false;
        public boolean dominatesC = false;
        public int markCC = 0;
        public int splitSGapped = 0;
        public boolean splitNumNP = false;
        public int splitPoss = 0;
        public int splitBaseNP = 0;
        public int splitTMP = 0;
        public int splitSbar = 0;
        public int splitNPADV = 0;
        public int splitNPNNP = 0;
        public boolean correctTags = false;
        public boolean rightPhrasal = false;
        public int sisterSplitLevel = 1;
        public boolean gpaRootVP = false;
        public int makePPTOintoIN = 0;
        private static final long serialVersionUID = 1831576434872643L;

        EnglishTrain() {
        }

        public void display() {
            String englishParams = "Using EnglishTreebankParserParams splitIN=" + this.splitIN + " sPercent=" + this.splitPercent + " sNNP=" + this.splitNNP + " sQuotes=" + this.splitQuotes + " sSFP=" + this.splitSFP + " rbGPA=" + this.tagRBGPA + " j#=" + this.joinPound + " jJJ=" + this.joinJJ + " jNounTags=" + this.joinNounTags + " sPPJJ=" + this.splitPPJJ + " sTRJJ=" + this.splitTRJJ + " sJJCOMP=" + this.splitJJCOMP + " sMoreLess=" + this.splitMoreLess + " unaryDT=" + this.unaryDT + " unaryRB=" + this.unaryRB + " unaryPRP=" + this.unaryPRP + " reflPRP=" + this.markReflexivePRP + " unaryIN=" + this.unaryIN + " sCC=" + this.splitCC + " sNT=" + this.splitNOT + " sRB=" + this.splitRB + " sAux=" + this.splitAux + " vpSubCat=" + this.vpSubCat + " mDTV=" + this.markDitransV + " sVP=" + this.splitVP + " sVPNPAgr=" + this.splitVPNPAgr + " sSTag=" + this.splitSTag + " mVP=" + this.markContainedVP + " sNP%=" + this.splitNPpercent + " sNPPRP=" + this.splitNPPRP + " dominatesV=" + this.dominatesV + " dominatesI=" + this.dominatesI + " dominatesC=" + this.dominatesC + " mCC=" + this.markCC + " sSGapped=" + this.splitSGapped + " numNP=" + this.splitNumNP + " sPoss=" + this.splitPoss + " baseNP=" + this.splitBaseNP + " sNPNNP=" + this.splitNPNNP + " sTMP=" + this.splitTMP + " sNPADV=" + this.splitNPADV + " cTags=" + this.correctTags + " rightPhrasal=" + this.rightPhrasal + " gpaRootVP=" + this.gpaRootVP + " splitSbar=" + this.splitSbar + " mPPTOiIN=" + this.makePPTOintoIN;
            System.err.println(englishParams);
        }
    }

    public static class EnglishTest
    implements Serializable {
        boolean retainNPTMPSubcategories = false;
        boolean retainTMPSubcategories = false;
        boolean retainADVSubcategories = false;
        boolean makeCopulaHead = false;
        private static final long serialVersionUID = 183157656745674521L;

        EnglishTest() {
        }
    }

    protected class EnglishSubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected EnglishSubcategoryStripper() {
        }

        @Override
        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            String s = lab.value();
            String tag = null;
            if (lab instanceof HasTag) {
                tag = ((HasTag)((Object)lab)).tag();
            }
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(lab);
                leaf.setScore(tree.score());
                return leaf;
            }
            if (tree.isPhrasal()) {
                Tree[] kids;
                if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTest.retainADVSubcategories && s.contains("-ADV")) {
                    s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
                    s = s + "-ADV";
                } else if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTest.retainTMPSubcategories && s.contains("-TMP")) {
                    s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
                    s = s + "-TMP";
                } else {
                    s = ((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTest.retainNPTMPSubcategories && s.startsWith("NP-TMP") ? "NP-TMP" : EnglishTreebankParserParams.this.tlp.basicCategory(s);
                }
                if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitBaseNP == 2 && s.equals("NP") && (kids = tree.children()).length == 1 && EnglishTreebankParserParams.this.tlp.basicCategory(kids[0].value()).equals("NP")) {
                    ArrayList<Tree> kidkids = new ArrayList<Tree>();
                    for (int cNum = 0; cNum < kids[0].children().length; ++cNum) {
                        Tree child = kids[0].children()[cNum];
                        Tree newChild = this.transformTree(child);
                        if (newChild == null) continue;
                        kidkids.add(newChild);
                    }
                    CategoryWordTag myLabel = new CategoryWordTag(lab);
                    myLabel.setCategory(s);
                    return this.tf.newTreeNode(myLabel, kidkids);
                }
                if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitPoss == 2 && s.equals("POSSP")) {
                    kids = tree.children();
                    ArrayList<Tree> newkids = new ArrayList<Tree>();
                    for (int j = 0; j < kids.length - 1; ++j) {
                        for (int cNum = 0; cNum < kids[j].children().length; ++cNum) {
                            Tree child = kids[0].children()[cNum];
                            Tree newChild = this.transformTree(child);
                            if (newChild == null) continue;
                            newkids.add(newChild);
                        }
                    }
                    Tree finalChild = this.transformTree(kids[kids.length - 1]);
                    newkids.add(finalChild);
                    CategoryWordTag myLabel = new CategoryWordTag(lab);
                    myLabel.setCategory("NP");
                    return this.tf.newTreeNode(myLabel, newkids);
                }
            } else {
                s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
                if (tag != null) {
                    tag = EnglishTreebankParserParams.this.tlp.basicCategory(tag);
                }
            }
            ArrayList<Tree> children = new ArrayList<Tree>();
            for (int cNum = 0; cNum < tree.numChildren(); ++cNum) {
                Tree child = tree.getChild(cNum);
                Tree newChild = this.transformTree(child);
                if (newChild == null) continue;
                children.add(newChild);
            }
            if (children.isEmpty()) {
                return null;
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            newLabel.setCategory(s);
            if (tag != null) {
                newLabel.setTag(tag);
            }
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }
}

