/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.maxent.Convert;
import edu.stanford.nlp.optimization.Function;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class ResultStoringMonitor
implements Function {
    int i = 0;
    final int outputFreq;
    final String filename;

    public ResultStoringMonitor(int outputFreq, String filename) {
        this.filename = filename.lastIndexOf(46) >= 0 ? filename.substring(0, filename.lastIndexOf(46)) + ".ddat" : filename + ".ddat";
        this.outputFreq = outputFreq;
    }

    @Override
    public double valueAt(double[] x) {
        if (++this.i % this.outputFreq == 0) {
            System.err.print("Storing interim (double) weights to " + this.filename + " ... ");
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(this.filename))));
                Convert.saveDoubleArr(dos, x);
                dos.close();
            }
            catch (IOException e) {
                System.err.println("ERROR!");
                return 1.0;
            }
            System.err.println("DONE.");
        }
        return 0.0;
    }

    @Override
    public int domainDimension() {
        return 0;
    }
}

