
### Bi-Associative Matrix class
###
### just call exec-axction to bootstrap a game procedure (see BAMatrix and
### BAMAction classes
###
### arguments are  e.g. "look at" and "console"
###
### The client rows and columns have an empty string in it
### The actions in the matrix are empty but the rows and column indexed items
### exist

use Game::Quest::BAMatrix;

class BAM {

	has @!client-row; ### row header, top of matrix
	has @!client-column; ### column header, left of matrix

	has $!matrix;

	submethod BUILD(:$nrows, :$ncols) {
		.init($nrows,$ncols);
	}

	multi method init($n, $m) {
		.client-row = ();
		.client-column = ();
		loop (my $i = 0 ; $i < $n; $i++) { ### row full of column text items
			push(.client-row, Str.new(""));
		}
		loop (my $j = 0 ; $j < $m; $j++) { ### column full of row text items
			push(.client-column, Str.new(""));
		}
		
		### NOTE : the matrix has no default BAMActions to start with
		.matrix = BAMatrix.new(.client-column.elems, .client-row.elems);
	}

	multi method set-row-member($rowindex, Str $text) {
		.client-row[$rowindex] = $text;
	}

	multi method set-column-member($columnindex, Str $text) {
		.client-column[$columnindex] = $text;
	}

	multi method set-action($rown, $colm, $bamaction) {
		.matrix.set-on-indexs-nm($rown, $colm, $bamaction);
	}

	multi method exec-action(Str $row-text, Str $column-text, $player, $room) {
		my $row-index = .client-row.first($row-text, :k); ### fetch index
		my $column-index = .client-row.first($column-text, :k);

		return .matrix.execute($row-index, $column-index, $player, $room);
	}
}
