/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormControlType;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class FormField {
    private String name;
    private int userValueCount = 0;
    private boolean allowsMultipleValues = false;
    private LinkedHashSet predefinedValues = null;
    private int position;
    private transient FormControlType firstEncounteredFormControlType = null;
    private transient boolean updateable = false;
    static Comparator COMPARATOR = new PositionComparator();

    FormField(String string, int n, FormControlType formControlType) {
        this.name = string;
        this.position = n;
        this.firstEncounteredFormControlType = formControlType;
        this.updateable = true;
    }

    public String getName() {
        return this.name;
    }

    public int getUserValueCount() {
        return this.userValueCount;
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public Collection getPredefinedValues() {
        return this.predefinedValues;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Field: ").append(this.name).append(", UserValueCount=").append(this.userValueCount).append(", AllowsMultipleValues=").append(this.allowsMultipleValues);
        if (this.predefinedValues != null) {
            Iterator iterator = this.predefinedValues.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\nPredefinedValue: ");
                stringBuffer.append(iterator.next());
            }
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    void setLowerPosition(int n) {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        if (n < this.position) {
            this.position = n;
        }
    }

    void incrementUserValueCount() {
        ++this.userValueCount;
    }

    void addPredefinedValue(String string) {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        if (this.predefinedValues == null) {
            this.predefinedValues = new LinkedHashSet();
        }
        this.predefinedValues.add(string);
    }

    void setMultipleValues() {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        this.allowsMultipleValues = true;
    }

    void setMultipleValues(FormControlType formControlType) {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        if (!this.allowsMultipleValues) {
            this.allowsMultipleValues = this.calculateMultipleValues(formControlType);
        }
    }

    private boolean calculateMultipleValues(FormControlType formControlType) {
        if (this.userValueCount > 0 || formControlType.allowsMultipleValues() || this.firstEncounteredFormControlType.allowsMultipleValues()) {
            return true;
        }
        if (formControlType == this.firstEncounteredFormControlType) {
            return false;
        }
        return !formControlType.isSubmit() || !this.firstEncounteredFormControlType.isSubmit();
    }

    void merge(FormField formField) {
        this.updateable = false;
        formField.updateable = false;
        if (formField.userValueCount > this.userValueCount) {
            this.userValueCount = formField.userValueCount;
        }
        boolean bl = this.allowsMultipleValues = this.allowsMultipleValues || formField.allowsMultipleValues;
        if (this.predefinedValues == null) {
            this.predefinedValues = formField.predefinedValues;
        } else if (formField.predefinedValues != null) {
            Iterator iterator = formField.getPredefinedValues().iterator();
            while (iterator.hasNext()) {
                this.predefinedValues.add(iterator.next());
            }
        }
    }

    private static class NoLongerUpdateableException
    extends RuntimeException {
        public NoLongerUpdateableException() {
            super("Internal Error: FormField objects are no longer updateable after merge or deserialisation");
        }
    }

    private static class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof FormField) || !(object2 instanceof FormField)) {
                throw new ClassCastException();
            }
            FormField formField = (FormField)object;
            FormField formField2 = (FormField)object2;
            if (formField.position < formField2.position) {
                return -1;
            }
            if (formField.position > formField2.position) {
                return 1;
            }
            return formField.name.compareTo(formField2.name);
        }
    }
}

