package Google::Ads::AdWords::v201109::KeywordMatchTypeSearchParameter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109::SearchParameter);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SearchParameter__Type_of :ATTR(:get<SearchParameter__Type>);
my %keywordMatchTypes_of :ATTR(:get<keywordMatchTypes>);

__PACKAGE__->_factory(
    [ qw(        SearchParameter__Type
        keywordMatchTypes

    ) ],
    {
        'SearchParameter__Type' => \%SearchParameter__Type_of,
        'keywordMatchTypes' => \%keywordMatchTypes_of,
    },
    {
        'SearchParameter__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'keywordMatchTypes' => 'Google::Ads::AdWords::v201109::KeywordMatchType',
    },
    {

        'SearchParameter__Type' => 'SearchParameter.Type',
        'keywordMatchTypes' => 'keywordMatchTypes',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::KeywordMatchTypeSearchParameter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
KeywordMatchTypeSearchParameter from the namespace https://adwords.google.com/api/adwords/o/v201109.

A {@link SearchParameter} for {@code KEYWORD} {@link IdeaType}s that specifies the {@link KeywordMatchType}s that all results must match. For example, results may be limited to only Broad or Exact matches. Setting no {@link KeywordMatchTypeSearchParameter} will match all targeting ideas, regardless of {@link KeywordMatchType}. If multiple {@link KeywordMatchType}s are set, a result need only match one match type to be returned. <p>This element is supported by following {@link IdeaType}s: KEYWORD. <p>This element is supported by following {@link RequestType}s: IDEAS, STATS. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * keywordMatchTypes




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::KeywordMatchTypeSearchParameter
   keywordMatchTypes => $some_value, # KeywordMatchType
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

