# Generated by default/object.tt
package Paws::MWAA::LastUpdate;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str');
  has Error => (is => 'ro', isa => 'Paws::MWAA::UpdateError');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MWAA::LastUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MWAA::LastUpdate object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MWAA::LastUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

The status of the last update on the environment, and any errors that
were encountered.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The day and time of the last update on the environment.


=head2 Error => L<Paws::MWAA::UpdateError>

The error that was encountered during the last update of the
environment.


=head2 Status => Str

The status of the last update on the environment. Valid values:
C<SUCCESS>, C<PENDING>, C<FAILED>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MWAA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

