/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;

public class PDType1Font
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDType1Font.class);
    public static final PDType1Font TIMES_ROMAN = new PDType1Font("Times-Roman");
    public static final PDType1Font TIMES_BOLD = new PDType1Font("Times-Bold");
    public static final PDType1Font TIMES_ITALIC = new PDType1Font("Times-Italic");
    public static final PDType1Font TIMES_BOLD_ITALIC = new PDType1Font("Times-BoldItalic");
    public static final PDType1Font HELVETICA = new PDType1Font("Helvetica");
    public static final PDType1Font HELVETICA_BOLD = new PDType1Font("Helvetica-Bold");
    public static final PDType1Font HELVETICA_OBLIQUE = new PDType1Font("Helvetica-Oblique");
    public static final PDType1Font HELVETICA_BOLD_OBLIQUE = new PDType1Font("Helvetica-BoldOblique");
    public static final PDType1Font COURIER = new PDType1Font("Courier");
    public static final PDType1Font COURIER_BOLD = new PDType1Font("Courier-Bold");
    public static final PDType1Font COURIER_OBLIQUE = new PDType1Font("Courier-Oblique");
    public static final PDType1Font COURIER_BOLD_OBLIQUE = new PDType1Font("Courier-BoldOblique");
    public static final PDType1Font SYMBOL = new PDType1Font("Symbol");
    public static final PDType1Font ZAPF_DINGBATS = new PDType1Font("ZapfDingbats");
    private static final int TYPE1_FONT = 1;
    private static final Map STANDARD_14 = new HashMap();
    private Font awtFont = null;

    public PDType1Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE1);
    }

    public PDType1Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public PDType1Font(String baseFont) {
        this();
        this.setBaseFont(baseFont);
    }

    public static PDType1Font getStandardFont(String name) {
        return (PDType1Font)STANDARD_14.get(name);
    }

    public static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        if (this.awtFont == null) {
            String baseFont = this.getBaseFont();
            PDFontDescriptor fd = this.getFontDescriptor();
            if (fd != null && fd instanceof PDFontDescriptorDictionary) {
                PDFontDescriptorDictionary fdDictionary = (PDFontDescriptorDictionary)fd;
                PDStream ffStream = fdDictionary.getFontFile();
                if (ffStream == null && fdDictionary.getFontFile3() != null) {
                    log.info((Object)("Embedded font-type is not supported " + fd.getFontName()));
                }
                if (ffStream != null) {
                    try {
                        this.awtFont = Font.createFont(1, ffStream.createInputStream());
                    }
                    catch (FontFormatException e) {
                        log.info((Object)("Can't read the embedded font " + fd.getFontName()));
                    }
                } else {
                    this.awtFont = FontManager.getAwtFont(fd.getFontName());
                    if (this.awtFont == null) {
                        log.info((Object)("Can't find the specified font " + fd.getFontName()));
                    }
                }
            } else {
                this.awtFont = FontManager.getAwtFont(baseFont);
                if (this.awtFont == null) {
                    log.info((Object)("Can't find the specified basefont " + baseFont));
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                log.info((Object)("Using font " + this.awtFont.getName() + " instead"));
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.writeFont(g2d, at, this.awtFont, fontSize, x, y, string);
    }

    static {
        STANDARD_14.put(TIMES_ROMAN.getBaseFont(), TIMES_ROMAN);
        STANDARD_14.put(TIMES_BOLD.getBaseFont(), TIMES_BOLD);
        STANDARD_14.put(TIMES_ITALIC.getBaseFont(), TIMES_ITALIC);
        STANDARD_14.put(TIMES_BOLD_ITALIC.getBaseFont(), TIMES_BOLD_ITALIC);
        STANDARD_14.put(HELVETICA.getBaseFont(), HELVETICA);
        STANDARD_14.put(HELVETICA_BOLD.getBaseFont(), HELVETICA_BOLD);
        STANDARD_14.put(HELVETICA_OBLIQUE.getBaseFont(), HELVETICA_OBLIQUE);
        STANDARD_14.put(HELVETICA_BOLD_OBLIQUE.getBaseFont(), HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(COURIER.getBaseFont(), COURIER);
        STANDARD_14.put(COURIER_BOLD.getBaseFont(), COURIER_BOLD);
        STANDARD_14.put(COURIER_OBLIQUE.getBaseFont(), COURIER_OBLIQUE);
        STANDARD_14.put(COURIER_BOLD_OBLIQUE.getBaseFont(), COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(SYMBOL.getBaseFont(), SYMBOL);
        STANDARD_14.put(ZAPF_DINGBATS.getBaseFont(), ZAPF_DINGBATS);
    }
}

