## TFSA-2021-164: FPE in LSH in TFLite

### CVE Number
CVE-2021-37691

### Impact
An attacker can craft a TFLite model that would trigger a division by zero
error in LSH
[implementation](https://github.com/tensorflow/tensorflow/blob/149562d49faa709ea80df1d99fc41d005b81082a/tensorflow/lite/kernels/lsh_projection.cc#L118).

```cc
int RunningSignBit(const TfLiteTensor* input, const TfLiteTensor* weight,
                   float seed) {
  int input_item_bytes = input->bytes / SizeOfDimension(input, 0);
  // ...
}
```

There is no check that the first dimension of the input is non zero.

### Patches
We have patched the issue in GitHub commit
[0575b640091680cfb70f4dd93e70658de43b94f9](https://github.com/tensorflow/tensorflow/commit/0575b640091680cfb70f4dd93e70658de43b94f9).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang of Baidu Security.
