## TFSA-2021-145: Reference binding to nullptr in map operations

### CVE Number
CVE-2021-37671

### Impact
An attacker can cause undefined behavior via binding a reference to null pointer
in `tf.raw_ops.Map*` and `tf.raw_ops.OrderedMap*` operations:

```python
import tensorflow as tf

tf.raw_ops.MapPeek(
  key=tf.constant([8],dtype=tf.int64),
  indices=[],
  dtypes=[tf.int32],
  capacity=8,
  memory_limit=128)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/kernels/map_stage_op.cc#L222-L248)
has a check in place to ensure that `indices` is in ascending order, but does
not check that `indices` is not empty.

### Patches
We have patched the issue in GitHub commit
[532f5c5a547126c634fefd43bbad1dc6417678ac](https://github.com/tensorflow/tensorflow/commit/532f5c5a547126c634fefd43bbad1dc6417678ac).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
