#pragma once

#include <cstdint>
#include "common/image/image.h"

namespace meteor
{
    namespace mtvza
    {
        class MTVZAReader
        {
        private:
            std::vector<uint16_t> channels[30];
            void parse_samples(uint8_t *data, int ch_start, int offset, int ch_cnt, int nsamples, int counter);

        public:
            MTVZAReader();
            ~MTVZAReader();

            int lines;
            std::vector<double> timestamps;

            double latest_msumr_timestamp = -1;

            void work(uint8_t *data);
            image::Image<uint16_t> getChannel(int channel);

            bool endian_mode = false;
        };
    }
}