## Do you want to contribute?

This is a README for developers wanting to contribute to the MongoDB PHP
driver.


## Current branches

* 1.3 is the current stable branch, critical fixes only allowed here
* master is the development branch for new features (to become 1.4)


## Github

The official repository of this driver is on
[Github](http://www.github.com/mongodb/mongo-php-driver/).  When fixing a bug
in the current release branch, please ensure you branch from it, and submit the
Pull Request against it again.  If there has been a while since you update your
local fork, please ensure you rebase it properly :)

Bugfixes and Pull Requests should be filed against the *lowest release branch*
All *new* development happens in master (i.e. new features, BC changes, ..).


## Running the tests

To run the test, you'll have to configure the tests/utils/cfg.inc file (copy
the [tests/utils/cfg.inc.template](tests/utils/cfg.inc.template) to
tests/mongo-test-cfg.inc and edit it).

The testing framework bootstraps mongod environments (standalone, replicaset,
sharding, authentication...) with the help of the mongo shell utility, on
non-standard ports, so there is no need to worry about overwriting your local
environment.

To boot up the environment run:

    $ make servers

And to tear it down again, after running the tests, run:

    $ make stop-servers

If you'd only like to bootup (and run) specific set of setups you can enable
individual setups by defining an environment variable called
MONGO_SERVER_[STANDALONE|REPLICASET|MONGOS]=yes before executing 'make servers'.

And finally, to execute the tests run:

    $ make test


## Writing tests

All tests 


## Test template for a Standalone MongoDB
    --TEST--
    Test for PHP-XYZ: The ticket title
    --SKIPIF--
    <?php require_once "tests/utils/standalone.inc"; ?>
    --FILE--
    <?php
    require_once "tests/utils/server.inc";

    $host = MongoShellServer::getStandaloneInfo();
    $mc = new MongoClient($host);

    /** Write your test code here **/
    ?>
    ===DONE===
    <?php exit(0); ?>
    --EXPECTF--
    ** Expected output here **
    ===DONE===

Some notes about the template:

* Please use a collection named after the ticket number (for easier tracking)
* The exit(0); statement allows you to run the testcase standalone from
  the command line (without running it via run-tests.php) and see what is going
  on without being flooded with hundred of lines from the --EXPECTF-- section.
* Other available skipif tests:
 * standalone.inc (MongoShellServer::getStandaloneInfo())
 * auth-standalone.inc (MongoShellServer::getStandaloneInfo(true))
 * replicaset.inc (MongoShellServer::getReplicasetInfo())
 * auth-replicaset.inc (MongoShellServer::getReplicasetInfo(true))
 * replicaset-failover.inc (MongoShellServer::getReplicasetInfo(true))
 * bridge.inc (MongoShellServer::getBridgeInfo())
 * mongos.inc (MongoShellServer::getShardInfo())


## Code coverage

Code coverage is generated by running the test suite after having enabled
coverage before compiling the driver

    $ phpize
    $ ./configure --enable-coverage
    $ make clean all tests

Then you should have a coverage/ folder with the juicy details.


