/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute a variance-to-mean ratio (VMR) incrementally.
*
* @module @stdlib/stats/incr/vmr
*
* @example
* var incrvmr = require( '@stdlib/stats/incr/vmr' );
*
* var accumulator = incrvmr();
*
* var D = accumulator();
* // returns null
*
* D = accumulator( 2.0 );
* // returns 0.0
*
* D = accumulator( 1.0 );
* // returns ~0.33
*
* D = accumulator();
* // returns ~0.33
*/

// MODULES //

var incrvmr = require( './main.js' );


// EXPORTS //

module.exports = incrvmr;
