/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSConstructor;
import sharpen.core.csharp.ast.CSMember;
import sharpen.core.csharp.ast.CSType;
import sharpen.core.csharp.ast.CSTypeParameter;
import sharpen.core.csharp.ast.CSTypeParameterProvider;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;

public abstract class CSTypeDeclaration
extends CSType
implements CSTypeParameterProvider {
    protected List<CSMember> _members = new ArrayList<CSMember>();
    protected List<CSTypeReferenceExpression> _baseTypes = new ArrayList<CSTypeReferenceExpression>();
    protected List<CSTypeParameter> _typeParameters = new ArrayList<CSTypeParameter>();
    private boolean _partial;

    CSTypeDeclaration(String name) {
        super(name);
    }

    public boolean isSealed() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public void addMember(CSMember member) {
        this._members.add(member);
    }

    public List<CSMember> members() {
        return Collections.unmodifiableList(this._members);
    }

    public List<CSConstructor> constructors() {
        ArrayList<CSConstructor> ctors = new ArrayList<CSConstructor>();
        for (CSMember member : this._members) {
            if (!(member instanceof CSConstructor)) continue;
            ctors.add((CSConstructor)member);
        }
        return Collections.unmodifiableList(ctors);
    }

    public void addBaseType(CSTypeReferenceExpression typeRef) {
        this._baseTypes.add(typeRef);
    }

    public void clearBaseTypes() {
        this._baseTypes.clear();
    }

    public List<CSTypeReferenceExpression> baseTypes() {
        return Collections.unmodifiableList(this._baseTypes);
    }

    @Override
    public void addTypeParameter(CSTypeParameter typeParameter) {
        this._typeParameters.add(typeParameter);
    }

    @Override
    public List<CSTypeParameter> typeParameters() {
        return Collections.unmodifiableList(this._typeParameters);
    }

    public void partial(boolean partial) {
        this._partial = partial;
    }

    public boolean partial() {
        return this._partial;
    }

    public CSMember getMember(String name) {
        for (CSMember member : this._members) {
            if (!member.name().equals(name)) continue;
            return member;
        }
        return null;
    }
}

