"""
This script how to generate a mitmproxy dump file,
as it would also be generated by passing `-w` to mitmproxy.
In contrast to `-w`, this gives you full control over which
flows should be saved and also allows you to rotate files or log
to multiple files in parallel.
"""
import random
import sys
from mitmproxy import io


class Writer:
    def __init__(self, path):
        if path == "-":
            f = sys.stdout
        else:
            f = open(path, "wb")
        self.w = io.FlowWriter(f)

    def response(self, flow):
        if random.choice([True, False]):
            self.w.add(flow)


def start():
    if len(sys.argv) != 2:
        raise ValueError('Usage: -s "flowriter.py filename"')
    return Writer(sys.argv[1])
