/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.AbstractDetailPane;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.browser.detail.elementvalues.ClassElementValueEntryDetailPane;
import org.gjt.jclasslib.browser.detail.elementvalues.ConstElementValueEntryDetailPane;
import org.gjt.jclasslib.browser.detail.elementvalues.EnumElementValueEntryDetailPane;
import org.gjt.jclasslib.browser.detail.elementvalues.GenericElementValueDetailPane;
import org.gjt.jclasslib.structures.elementvalues.ClassElementValue;
import org.gjt.jclasslib.structures.elementvalues.ConstElementValue;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;
import org.gjt.jclasslib.structures.elementvalues.EnumElementValue;

public class ElementValueDetailPane
extends AbstractDetailPane {
    private static final String SCREEN_UNKNOWN = "Unknown";
    private static final String SCREEN_CONST_VALUE = "Const";
    private static final String SCREEN_CLASS_VALUE = "Class";
    private static final String SCREEN_ENUM_VALUE = "Enum";
    private HashMap elementTypeToDetailPane;
    private JPanel specificInfoPane;
    private GenericElementValueDetailPane genericInfoPane;

    public ElementValueDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupComponent() {
        this.buildGenericInfoPane();
        this.buildSpecificInfoPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.genericInfoPane, "North");
        this.add((Component)this.specificInfoPane, "Center");
    }

    public void show(TreePath treePath) {
        ElementValue elementValue = (ElementValue)((BrowserTreeNode)treePath.getLastPathComponent()).getElement();
        String string = null;
        if (elementValue instanceof ConstElementValue) {
            string = SCREEN_CONST_VALUE;
        } else if (elementValue instanceof ClassElementValue) {
            string = SCREEN_CLASS_VALUE;
        } else if (elementValue instanceof EnumElementValue) {
            string = SCREEN_ENUM_VALUE;
        }
        CardLayout cardLayout = (CardLayout)this.specificInfoPane.getLayout();
        if (string == null) {
            cardLayout.show(this.specificInfoPane, SCREEN_UNKNOWN);
        } else {
            AbstractDetailPane abstractDetailPane = (AbstractDetailPane)this.elementTypeToDetailPane.get(string);
            abstractDetailPane.show(treePath);
            cardLayout.show(this.specificInfoPane, string);
        }
        this.genericInfoPane.show(treePath);
    }

    private void buildGenericInfoPane() {
        this.genericInfoPane = new GenericElementValueDetailPane(this.services);
        this.genericInfoPane.setBorder(this.createTitledBorder("Generic info:"));
    }

    private void buildSpecificInfoPane() {
        this.specificInfoPane = new JPanel();
        this.specificInfoPane.setBorder(this.createTitledBorder("Specific info:"));
        this.specificInfoPane.setLayout(new CardLayout());
        this.elementTypeToDetailPane = new HashMap();
        JPanel jPanel = new JPanel();
        this.specificInfoPane.add((Component)jPanel, SCREEN_UNKNOWN);
        this.addScreen(new ConstElementValueEntryDetailPane(this.services), SCREEN_CONST_VALUE);
        this.addScreen(new ClassElementValueEntryDetailPane(this.services), SCREEN_CLASS_VALUE);
        this.addScreen(new EnumElementValueEntryDetailPane(this.services), SCREEN_ENUM_VALUE);
    }

    private void addScreen(AbstractDetailPane abstractDetailPane, String string) {
        if (abstractDetailPane instanceof FixedListDetailPane) {
            this.specificInfoPane.add((Component)((FixedListDetailPane)abstractDetailPane).getScrollPane(), string);
        } else {
            this.specificInfoPane.add((Component)abstractDetailPane, string);
        }
        this.elementTypeToDetailPane.put(string, abstractDetailPane);
    }

    private Border createTitledBorder(String string) {
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
        return titledBorder;
    }
}

